/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.serializer.JavaSerializationComparator;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.Utils;
import org.junit.Assert;
import org.junit.Test;

public class TestJavaSerialization {
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+');
    private final Path INPUT_DIR = new Path(TEST_ROOT_DIR + "/input");
    private final Path OUTPUT_DIR = new Path(TEST_ROOT_DIR + "/out");
    private final Path INPUT_FILE = new Path(this.INPUT_DIR, "inp");

    private void cleanAndCreateInput(FileSystem fs) throws IOException {
        fs.delete(this.INPUT_DIR, true);
        fs.delete(this.OUTPUT_DIR, true);
        FSDataOutputStream os = fs.create(this.INPUT_FILE);
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os);
        wr.write("b a\n");
        ((Writer)wr).close();
    }

    @Test
    public void testMapReduceJob() throws Exception {
        JobConf conf = new JobConf(TestJavaSerialization.class);
        conf.setJobName("JavaSerialization");
        FileSystem fs = FileSystem.get((Configuration)conf);
        this.cleanAndCreateInput(fs);
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputKeyClass(String.class);
        conf.setOutputValueClass(Long.class);
        conf.setOutputKeyComparatorClass(JavaSerializationComparator.class);
        conf.setMapperClass(WordCountMapper.class);
        conf.setReducerClass(SumReducer.class);
        conf.set("mapreduce.framework.name", "local");
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{this.INPUT_DIR});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)this.OUTPUT_DIR);
        String inputFileContents = FileUtils.readFileToString((File)new File(this.INPUT_FILE.toUri().getPath()));
        Assert.assertTrue((String)("Input file contents not as expected; contents are '" + inputFileContents + "', expected \"b a\n\" "), (boolean)inputFileContents.equals("b a\n"));
        JobClient.runJob((JobConf)conf);
        Path[] outputFiles = FileUtil.stat2Paths((FileStatus[])fs.listStatus(this.OUTPUT_DIR, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()));
        Assert.assertEquals((long)1L, (long)outputFiles.length);
        try (FSDataInputStream is = fs.open(outputFiles[0]);){
            String reduceOutput = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            String[] lines = reduceOutput.split("\n");
            Assert.assertEquals((String)("Unexpected output; received output '" + reduceOutput + "'"), (Object)"a\t1", (Object)lines[0]);
            Assert.assertEquals((String)("Unexpected output; received output '" + reduceOutput + "'"), (Object)"b\t1", (Object)lines[1]);
            Assert.assertEquals((String)("Reduce output has extra lines; output is '" + reduceOutput + "'"), (long)2L, (long)lines.length);
        }
    }

    @Test
    public void testWriteToSequencefile() throws Exception {
        JobConf conf = new JobConf(TestJavaSerialization.class);
        conf.setJobName("JavaSerialization");
        FileSystem fs = FileSystem.get((Configuration)conf);
        this.cleanAndCreateInput(fs);
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        conf.setOutputKeyClass(String.class);
        conf.setOutputValueClass(Long.class);
        conf.setOutputKeyComparatorClass(JavaSerializationComparator.class);
        conf.setMapperClass(WordCountMapper.class);
        conf.setReducerClass(SumReducer.class);
        conf.set("mapreduce.framework.name", "local");
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{this.INPUT_DIR});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)this.OUTPUT_DIR);
        JobClient.runJob((JobConf)conf);
        Path[] outputFiles = FileUtil.stat2Paths((FileStatus[])fs.listStatus(this.OUTPUT_DIR, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()));
        Assert.assertEquals((long)1L, (long)outputFiles.length);
    }

    static class SumReducer<K>
    extends MapReduceBase
    implements Reducer<K, Long, K, Long> {
        SumReducer() {
        }

        public void reduce(K key, Iterator<Long> values, OutputCollector<K, Long> output, Reporter reporter) throws IOException {
            long sum = 0L;
            while (values.hasNext()) {
                sum += values.next().longValue();
            }
            output.collect(key, (Object)sum);
        }
    }

    static class WordCountMapper
    extends MapReduceBase
    implements Mapper<LongWritable, Text, String, Long> {
        WordCountMapper() {
        }

        public void map(LongWritable key, Text value, OutputCollector<String, Long> output, Reporter reporter) throws IOException {
            StringTokenizer st = new StringTokenizer(value.toString());
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                Assert.assertTrue((String)("Invalid token; expected 'a' or 'b', got " + token), (token.equals("a") || token.equals("b") ? 1 : 0) != 0);
                output.collect((Object)token, (Object)1L);
            }
        }
    }
}

