/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.csi.adaptor;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.CsiAdaptorPlugin;
import org.apache.hadoop.yarn.csi.adaptor.CsiAdaptorFactory;
import org.apache.hadoop.yarn.csi.adaptor.CsiAdaptorProtocolService;
import org.apache.hadoop.yarn.server.api.ApplicationInitializationContext;
import org.apache.hadoop.yarn.server.api.ApplicationTerminationContext;
import org.apache.hadoop.yarn.server.api.AuxiliaryService;
import org.apache.hadoop.yarn.util.csi.CsiConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsiAdaptorServices
extends AuxiliaryService {
    private static final Logger LOG = LoggerFactory.getLogger(CsiAdaptorServices.class);
    private List<CsiAdaptorProtocolService> serviceList = new ArrayList<CsiAdaptorProtocolService>();

    protected CsiAdaptorServices() {
        super(CsiAdaptorServices.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        String[] names = CsiConfigUtils.getCsiDriverNames((Configuration)conf);
        if (names != null && names.length > 0) {
            for (String driverName : names) {
                LOG.info("Adding csi-driver-adaptor for csi-driver {}", (Object)driverName);
                CsiAdaptorPlugin serviceImpl = CsiAdaptorFactory.getAdaptor(driverName, conf);
                serviceImpl.init(driverName, conf);
                CsiAdaptorProtocolService service = new CsiAdaptorProtocolService(serviceImpl);
                this.serviceList.add(service);
                service.serviceInit(conf);
            }
        }
        super.serviceInit(conf);
    }

    protected void serviceStop() throws Exception {
        if (this.serviceList != null && this.serviceList.size() > 0) {
            for (CsiAdaptorProtocolService service : this.serviceList) {
                try {
                    service.serviceStop();
                }
                catch (Exception e) {
                    LOG.warn("Unable to stop service " + service.getName(), (Throwable)e);
                }
            }
        }
    }

    protected void serviceStart() throws Exception {
        if (this.serviceList != null && this.serviceList.size() > 0) {
            for (CsiAdaptorProtocolService service : this.serviceList) {
                service.serviceStart();
            }
        }
    }

    public void initializeApplication(ApplicationInitializationContext initAppContext) {
    }

    public void stopApplication(ApplicationTerminationContext stopAppContext) {
    }

    public ByteBuffer getMetaData() {
        return ByteBuffer.allocate(0);
    }
}

