/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement;

import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.CandidateNodeSet;

public class SimpleCandidateNodeSet<N extends SchedulerNode>
implements CandidateNodeSet<N> {
    private Map<NodeId, N> map;
    private String partition;

    public SimpleCandidateNodeSet(N node) {
        if (null != node) {
            this.map = ImmutableMap.of((Object)((SchedulerNode)node).getNodeID(), node);
            this.partition = ((SchedulerNode)node).getPartition();
        } else {
            this.map = Collections.emptyMap();
            this.partition = "<DEFAULT_PARTITION>";
        }
    }

    public SimpleCandidateNodeSet(Map<NodeId, N> map, String partition) {
        this.map = map;
        this.partition = partition;
    }

    @Override
    public Map<NodeId, N> getAllNodes() {
        return this.map;
    }

    @Override
    public long getVersion() {
        return 0L;
    }

    @Override
    public String getPartition() {
        return this.partition;
    }
}

