/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.federation.router.Quota;
import org.apache.hadoop.hdfs.server.federation.router.RouterAdminServer;
import org.apache.hadoop.hdfs.server.federation.router.RouterPermissionChecker;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaUsage;
import org.apache.hadoop.hdfs.server.federation.store.MountTableStore;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreOperationResult;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetDestinationRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetDestinationResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RefreshMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RefreshMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.federation.store.records.Query;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MountTableStoreImpl
extends MountTableStore {
    public MountTableStoreImpl(StateStoreDriver driver) {
        super(driver);
    }

    private void checkMountTableEntryPermission(String src, FsAction action) throws IOException {
        RouterPermissionChecker pc;
        MountTable partial = MountTable.newInstance();
        partial.setSourcePath(src);
        Query<MountTable> query = new Query<MountTable>(partial);
        MountTable entry = this.getDriver().get(this.getRecordClass(), query);
        if (entry != null && (pc = RouterAdminServer.getPermissionChecker()) != null) {
            pc.checkPermission(entry, action);
        }
    }

    private void checkMountTablePermission(String src) throws IOException {
        String parent = src.substring(0, src.lastIndexOf("/"));
        this.checkMountTableEntryPermission(parent, FsAction.WRITE);
        while (!parent.isEmpty()) {
            parent = parent.substring(0, parent.lastIndexOf("/"));
            this.checkMountTableEntryPermission(parent, FsAction.EXECUTE);
        }
    }

    @Override
    public AddMountTableEntryResponse addMountTableEntry(AddMountTableEntryRequest request) throws IOException {
        MountTable mountTable = request.getEntry();
        if (mountTable != null) {
            mountTable.validate();
            String src = mountTable.getSourcePath();
            this.checkMountTablePermission(src);
            boolean status = this.getDriver().put(mountTable, false, true);
            AddMountTableEntryResponse response = AddMountTableEntryResponse.newInstance();
            response.setStatus(status);
            if (status) {
                this.updateCacheAllRouters();
            }
            return response;
        }
        AddMountTableEntryResponse response = AddMountTableEntryResponse.newInstance();
        response.setStatus(false);
        return response;
    }

    @Override
    public AddMountTableEntriesResponse addMountTableEntries(AddMountTableEntriesRequest request) throws IOException {
        List<MountTable> mountTables = request.getEntries();
        if (mountTables == null || mountTables.size() == 0) {
            AddMountTableEntriesResponse response = AddMountTableEntriesResponse.newInstance();
            response.setStatus(false);
            response.setFailedRecordsKeys(Collections.emptyList());
            return response;
        }
        for (MountTable mountTable : mountTables) {
            mountTable.validate();
            String src = mountTable.getSourcePath();
            this.checkMountTablePermission(src);
        }
        StateStoreOperationResult result = this.getDriver().putAll(mountTables, false, true);
        boolean status = result.isOperationSuccessful();
        AddMountTableEntriesResponse response = AddMountTableEntriesResponse.newInstance();
        response.setStatus(status);
        response.setFailedRecordsKeys(result.getFailedRecordsKeys());
        if (status) {
            this.updateCacheAllRouters();
        }
        return response;
    }

    @Override
    public UpdateMountTableEntryResponse updateMountTableEntry(UpdateMountTableEntryRequest request) throws IOException {
        MountTable mountTable = request.getEntry();
        if (mountTable != null) {
            mountTable.validate();
            String srcPath = mountTable.getSourcePath();
            this.checkMountTableEntryPermission(srcPath, FsAction.WRITE);
            boolean status = this.getDriver().put(mountTable, true, true);
            UpdateMountTableEntryResponse response = UpdateMountTableEntryResponse.newInstance();
            response.setStatus(status);
            if (status) {
                this.updateCacheAllRouters();
            }
            return response;
        }
        UpdateMountTableEntryResponse response = UpdateMountTableEntryResponse.newInstance();
        response.setStatus(false);
        return response;
    }

    @Override
    public RemoveMountTableEntryResponse removeMountTableEntry(RemoveMountTableEntryRequest request) throws IOException {
        String srcPath = request.getSrcPath();
        MountTable partial = MountTable.newInstance();
        partial.setSourcePath(srcPath);
        Query<MountTable> query = new Query<MountTable>(partial);
        MountTable deleteEntry = this.getDriver().get(this.getRecordClass(), query);
        boolean status = false;
        if (deleteEntry != null) {
            RouterPermissionChecker pc = RouterAdminServer.getPermissionChecker();
            if (pc != null) {
                pc.checkPermission(deleteEntry, FsAction.WRITE);
            }
            status = this.getDriver().remove(deleteEntry);
        }
        RemoveMountTableEntryResponse response = RemoveMountTableEntryResponse.newInstance();
        response.setStatus(status);
        if (status) {
            this.updateCacheAllRouters();
        }
        return response;
    }

    @Override
    public GetMountTableEntriesResponse getMountTableEntries(GetMountTableEntriesRequest request) throws IOException {
        RouterPermissionChecker pc = RouterAdminServer.getPermissionChecker();
        List<MountTable> records = this.getCachedRecords();
        Collections.sort(records, MountTable.SOURCE_COMPARATOR);
        String reqSrcPath = request.getSrcPath();
        if (reqSrcPath != null && !reqSrcPath.isEmpty()) {
            Iterator it = records.iterator();
            while (it.hasNext()) {
                RouterQuotaUsage quota;
                MountTable record = (MountTable)it.next();
                String srcPath = record.getSourcePath();
                if (!DFSUtil.isParentEntry((String)srcPath, (String)reqSrcPath)) {
                    it.remove();
                } else if (pc != null) {
                    try {
                        pc.checkPermission(record, FsAction.READ);
                    }
                    catch (AccessControlException ignored) {
                        it.remove();
                    }
                }
                if (this.getQuotaManager() == null || (quota = this.getQuotaManager().getQuotaUsage(record.getSourcePath())) == null) continue;
                RouterQuotaUsage oldquota = record.getQuota();
                RouterQuotaUsage.Builder builder = new RouterQuotaUsage.Builder().fileAndDirectoryCount(quota.getFileAndDirectoryCount()).quota(oldquota.getQuota()).spaceConsumed(quota.getSpaceConsumed()).spaceQuota(oldquota.getSpaceQuota());
                Quota.eachByStorageType(t -> {
                    builder.typeQuota((StorageType)t, oldquota.getTypeQuota((StorageType)t));
                    builder.typeConsumed((StorageType)t, quota.getTypeConsumed((StorageType)t));
                });
                record.setQuota(builder.build());
            }
        }
        GetMountTableEntriesResponse response = GetMountTableEntriesResponse.newInstance();
        response.setEntries(records);
        response.setTimestamp(Time.now());
        return response;
    }

    @Override
    public RefreshMountTableEntriesResponse refreshMountTableEntries(RefreshMountTableEntriesRequest request) throws IOException {
        boolean result = this.loadCache(true);
        RefreshMountTableEntriesResponse response = RefreshMountTableEntriesResponse.newInstance();
        response.setResult(result);
        return response;
    }

    @Override
    public GetDestinationResponse getDestination(GetDestinationRequest request) throws IOException {
        throw new UnsupportedOperationException("Requires the RouterRpcServer");
    }
}

