/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc.security;

import java.io.IOException;
import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Verifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecurityHandler {
    public static final Logger LOG = LoggerFactory.getLogger(SecurityHandler.class);

    public abstract String getUser();

    public abstract boolean shouldSilentlyDrop(RpcCall var1);

    public abstract Verifier getVerifer(RpcCall var1) throws IOException;

    public boolean isUnwrapRequired() {
        return false;
    }

    public boolean isWrapRequired() {
        return false;
    }

    public XDR unwrap(RpcCall request, byte[] data) throws IOException {
        throw new UnsupportedOperationException();
    }

    public byte[] wrap(RpcCall request, XDR response) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int getUid() {
        throw new UnsupportedOperationException();
    }

    public int getGid() {
        throw new UnsupportedOperationException();
    }

    public int[] getAuxGids() {
        throw new UnsupportedOperationException();
    }
}

