/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl.prefetch;

import org.apache.hadoop.fs.impl.prefetch.BlockData;
import org.apache.hadoop.fs.impl.prefetch.ExceptionAsserts;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestBlockData
extends AbstractHadoopTestBase {
    @Test
    public void testArgChecks() throws Exception {
        new BlockData(10L, 5);
        new BlockData(5L, 10);
        new BlockData(0L, 10);
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'fileSize' must not be negative", () -> new BlockData(-1L, 2));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'blockSize' must be a positive integer", () -> new BlockData(10L, 0));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'blockSize' must be a positive integer", () -> new BlockData(10L, -2));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'blockNumber' (-1) must be within the range [0, 3]", () -> new BlockData(10L, 3).isLastBlock(-1));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'blockNumber' (11) must be within the range [0, 3]", () -> new BlockData(10L, 3).isLastBlock(11));
    }

    @Test
    public void testComputedFields() throws Exception {
        this.testComputedFieldsHelper(0L, 10);
        this.testComputedFieldsHelper(1L, 10);
        this.testComputedFieldsHelper(10L, 1);
        this.testComputedFieldsHelper(10L, 2);
        this.testComputedFieldsHelper(10L, 3);
    }

    private void testComputedFieldsHelper(long fileSize, int blockSize) throws Exception {
        BlockData bd = new BlockData(fileSize, blockSize);
        if (fileSize == 0L) {
            Assert.assertFalse((boolean)bd.isLastBlock(0));
            Assert.assertFalse((boolean)bd.isLastBlock(1));
            Assert.assertFalse((boolean)bd.isValidOffset(0L));
            Assert.assertEquals((long)0L, (long)bd.getSize(0));
            Assert.assertEquals((Object)"", (Object)bd.getStateString());
            ExceptionAsserts.assertThrows(IllegalArgumentException.class, "'offset' (0) must be within the range [0, -1]", () -> bd.getBlockNumber(0L));
            ExceptionAsserts.assertThrows(IllegalArgumentException.class, "'blockNumber' (0) must be within the range [0, -1]", () -> bd.getStartOffset(0));
            ExceptionAsserts.assertThrows(IllegalArgumentException.class, "'offset' (0) must be within the range [0, -1]", () -> bd.getRelativeOffset(0, 0L));
            ExceptionAsserts.assertThrows(IllegalArgumentException.class, "'blockNumber' (0) must be within the range [0, -1]", () -> bd.getState(0));
            ExceptionAsserts.assertThrows(IllegalArgumentException.class, "'blockNumber' (0) must be within the range [0, -1]", () -> bd.setState(0, BlockData.State.READY));
            return;
        }
        Assert.assertEquals((long)fileSize, (long)bd.getFileSize());
        Assert.assertEquals((long)blockSize, (long)bd.getBlockSize());
        int expectedNumBlocks = (int)(fileSize / (long)blockSize);
        if (fileSize % (long)blockSize > 0L) {
            ++expectedNumBlocks;
        }
        Assert.assertEquals((long)expectedNumBlocks, (long)bd.getNumBlocks());
        int lastBlockNumber = expectedNumBlocks - 1;
        for (int b = 0; b < lastBlockNumber; ++b) {
            Assert.assertFalse((boolean)bd.isLastBlock(b));
            Assert.assertEquals((long)blockSize, (long)bd.getSize(b));
        }
        Assert.assertTrue((boolean)bd.isLastBlock(lastBlockNumber));
        int lastBlockSize = (int)(fileSize - (long)(blockSize * (expectedNumBlocks - 1)));
        Assert.assertEquals((long)lastBlockSize, (long)bd.getSize(lastBlockNumber));
        for (long offset = 0L; offset < fileSize; ++offset) {
            int expectedBlockNumber = (int)(offset / (long)blockSize);
            Assert.assertEquals((long)expectedBlockNumber, (long)bd.getBlockNumber(offset));
            for (int b = 0; b < expectedNumBlocks - 1; ++b) {
                long expectedStartOffset = b * blockSize;
                Assert.assertEquals((long)expectedStartOffset, (long)bd.getStartOffset(b));
                int expectedRelativeOffset = (int)(offset - expectedStartOffset);
                Assert.assertEquals((long)expectedRelativeOffset, (long)bd.getRelativeOffset(b, offset));
            }
        }
        for (int b = 0; b < expectedNumBlocks; ++b) {
            Assert.assertEquals((long)(b * blockSize), (long)bd.getStartOffset(b));
            Assert.assertEquals((Object)BlockData.State.NOT_READY, (Object)bd.getState(b));
            bd.setState(b, BlockData.State.QUEUED);
            Assert.assertEquals((Object)BlockData.State.QUEUED, (Object)bd.getState(b));
            bd.setState(b, BlockData.State.READY);
            Assert.assertEquals((Object)BlockData.State.READY, (Object)bd.getState(b));
            bd.setState(b, BlockData.State.CACHED);
            Assert.assertEquals((Object)BlockData.State.CACHED, (Object)bd.getState(b));
        }
    }
}

