/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AppendRequestParameters;
import org.apache.hadoop.fs.azurebfs.security.ContextEncryptionAdapter;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsLease;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStreamContext;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStreamStatistics;
import org.apache.hadoop.fs.azurebfs.services.AbfsPerfInfo;
import org.apache.hadoop.fs.azurebfs.services.AbfsPerfTracker;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.utils.CachedSASToken;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.impl.BackReference;
import org.apache.hadoop.fs.impl.StoreImplementationUtils;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.store.BlockUploadStatistics;
import org.apache.hadoop.fs.store.DataBlocks;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbfsOutputStream
extends OutputStream
implements Syncable,
StreamCapabilities,
IOStatisticsSource {
    private final AbfsClient client;
    private final String path;
    private long position;
    private boolean closed;
    private boolean supportFlush;
    private boolean disableOutputStreamFlush;
    private boolean enableSmallWriteOptimization;
    private boolean isAppendBlob;
    private boolean isExpectHeaderEnabled;
    private volatile IOException lastError;
    private long lastFlushOffset;
    private long lastTotalAppendOffset = 0L;
    private final int bufferSize;
    private byte[] buffer;
    private int bufferIndex;
    private int numOfAppendsToServerSinceLastFlush;
    private final int maxConcurrentRequestCount;
    private final int maxRequestsThatCanBeQueued;
    private ConcurrentLinkedDeque<WriteOperation> writeOperations;
    private final ContextEncryptionAdapter contextEncryptionAdapter;
    private CachedSASToken cachedSasToken;
    private final String outputStreamId;
    private final TracingContext tracingContext;
    private Listener listener;
    private AbfsLease lease;
    private String leaseId;
    private final FileSystem.Statistics statistics;
    private final AbfsOutputStreamStatistics outputStreamStatistics;
    private IOStatistics ioStatistics;
    private static final Logger LOG = LoggerFactory.getLogger(AbfsOutputStream.class);
    private final DataBlocks.BlockFactory blockFactory;
    private DataBlocks.DataBlock activeBlock;
    private long blockCount = 0L;
    private final int blockSize;
    private final ListeningExecutorService executorService;
    private final BackReference fsBackRef;

    public AbfsOutputStream(AbfsOutputStreamContext abfsOutputStreamContext) throws IOException {
        this.client = abfsOutputStreamContext.getClient();
        this.statistics = abfsOutputStreamContext.getStatistics();
        this.path = abfsOutputStreamContext.getPath();
        this.position = abfsOutputStreamContext.getPosition();
        this.closed = false;
        this.supportFlush = abfsOutputStreamContext.isEnableFlush();
        this.isExpectHeaderEnabled = abfsOutputStreamContext.isExpectHeaderEnabled();
        this.disableOutputStreamFlush = abfsOutputStreamContext.isDisableOutputStreamFlush();
        this.enableSmallWriteOptimization = abfsOutputStreamContext.isEnableSmallWriteOptimization();
        this.isAppendBlob = abfsOutputStreamContext.isAppendBlob();
        this.lastError = null;
        this.lastFlushOffset = 0L;
        this.bufferSize = abfsOutputStreamContext.getWriteBufferSize();
        this.bufferIndex = 0;
        this.numOfAppendsToServerSinceLastFlush = 0;
        this.writeOperations = new ConcurrentLinkedDeque();
        this.outputStreamStatistics = abfsOutputStreamContext.getStreamStatistics();
        this.fsBackRef = abfsOutputStreamContext.getFsBackRef();
        this.contextEncryptionAdapter = abfsOutputStreamContext.getEncryptionAdapter();
        this.maxConcurrentRequestCount = this.isAppendBlob ? 1 : abfsOutputStreamContext.getWriteMaxConcurrentRequestCount();
        this.maxRequestsThatCanBeQueued = abfsOutputStreamContext.getMaxWriteRequestsToQueue();
        this.lease = abfsOutputStreamContext.getLease();
        this.leaseId = abfsOutputStreamContext.getLeaseId();
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)abfsOutputStreamContext.getExecutorService());
        this.cachedSasToken = new CachedSASToken(abfsOutputStreamContext.getSasTokenRenewPeriodForStreamsInSeconds());
        this.outputStreamId = this.createOutputStreamId();
        this.tracingContext = new TracingContext(abfsOutputStreamContext.getTracingContext());
        this.tracingContext.setStreamID(this.outputStreamId);
        this.tracingContext.setOperation(FSOperationType.WRITE);
        this.ioStatistics = this.outputStreamStatistics.getIOStatistics();
        this.blockFactory = abfsOutputStreamContext.getBlockFactory();
        this.blockSize = this.bufferSize;
        this.createBlockIfNeeded();
    }

    private String createOutputStreamId() {
        return StringUtils.right((String)UUID.randomUUID().toString(), (int)12);
    }

    public boolean hasCapability(String capability) {
        return this.supportFlush && StoreImplementationUtils.isProbeForSyncable((String)capability);
    }

    @Override
    public void write(int byteVal) throws IOException {
        this.write(new byte[]{(byte)(byteVal & 0xFF)});
    }

    @Override
    public synchronized void write(byte[] data, int off, int length) throws IOException {
        DataBlocks.validateWriteArgs((byte[])data, (int)off, (int)length);
        this.maybeThrowLastError();
        if (off < 0 || length < 0 || length > data.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.hasLease() && this.isLeaseFreed()) {
            throw new PathIOException(this.path, "Attempted to write to file without lease");
        }
        DataBlocks.DataBlock block = this.createBlockIfNeeded();
        int written = block.write(data, off, length);
        int remainingCapacity = block.remainingCapacity();
        if (written < length) {
            LOG.debug("writing more data than block capacity -triggering upload");
            this.uploadCurrentBlock();
            this.write(data, off + written, length - written);
        } else if (remainingCapacity == 0) {
            this.uploadCurrentBlock();
        }
        this.incrementWriteOps();
    }

    private synchronized DataBlocks.DataBlock createBlockIfNeeded() throws IOException {
        if (this.activeBlock == null) {
            ++this.blockCount;
            this.activeBlock = this.blockFactory.create(this.blockCount, this.blockSize, (BlockUploadStatistics)this.outputStreamStatistics);
        }
        return this.activeBlock;
    }

    private synchronized void uploadCurrentBlock() throws IOException {
        Preconditions.checkState((boolean)this.hasActiveBlock(), (Object)"No active block");
        LOG.debug("Writing block # {}", (Object)this.blockCount);
        try {
            this.uploadBlockAsync(this.getActiveBlock(), false, false);
        }
        finally {
            this.clearActiveBlock();
        }
    }

    private void uploadBlockAsync(DataBlocks.DataBlock blockToUpload, boolean isFlush, boolean isClose) throws IOException {
        if (this.isAppendBlob) {
            this.writeAppendBlobCurrentBufferToService();
            return;
        }
        if (!blockToUpload.hasData()) {
            return;
        }
        ++this.numOfAppendsToServerSinceLastFlush;
        int bytesLength = blockToUpload.dataSize();
        long offset = this.position;
        this.position += (long)bytesLength;
        this.outputStreamStatistics.bytesToUpload(bytesLength);
        this.outputStreamStatistics.writeCurrentBuffer();
        DataBlocks.BlockUploadData blockUploadData = blockToUpload.startUpload();
        ListenableFuture job = this.executorService.submit(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        this.writeOperations.add(new WriteOperation((Future<Void>)job, offset, bytesLength));
        this.shrinkWriteOperationQueue();
    }

    private void failureWhileSubmit(Exception ex) throws IOException {
        if (ex instanceof AbfsRestOperationException && ((AbfsRestOperationException)ex).getStatusCode() == 404) {
            throw new FileNotFoundException(ex.getMessage());
        }
        this.lastError = ex instanceof IOException ? (IOException)ex : new IOException(ex);
        throw this.lastError;
    }

    private synchronized DataBlocks.DataBlock getActiveBlock() {
        return this.activeBlock;
    }

    private synchronized boolean hasActiveBlock() {
        return this.activeBlock != null;
    }

    private boolean hasActiveBlockDataToUpload() {
        return this.hasActiveBlock() && this.getActiveBlock().hasData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearActiveBlock() {
        if (this.activeBlock != null) {
            LOG.debug("Clearing active block");
        }
        AbfsOutputStream abfsOutputStream = this;
        synchronized (abfsOutputStream) {
            this.activeBlock = null;
        }
    }

    private void incrementWriteOps() {
        if (this.statistics != null) {
            this.statistics.incrementWriteOps(1);
        }
    }

    private void maybeThrowLastError() throws IOException {
        if (this.lastError != null) {
            throw this.lastError;
        }
    }

    @Override
    public void flush() throws IOException {
        if (!this.disableOutputStreamFlush) {
            this.flushInternalAsync();
        }
    }

    public void hsync() throws IOException {
        if (this.supportFlush) {
            this.flushInternal(false);
        }
    }

    public void hflush() throws IOException {
        if (this.supportFlush) {
            this.flushInternal(false);
        }
    }

    public String getStreamID() {
        return this.outputStreamId;
    }

    public void registerListener(Listener listener1) {
        this.listener = listener1;
        this.tracingContext.setListener(this.listener);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            if (this.hasActiveBlockDataToUpload() && this.executorService.isShutdown()) {
                throw new PathIOException(this.path, "Executor Service closed before writes could be completed.");
            }
            this.flushInternal(true);
        }
        catch (IOException e) {
            throw IOUtils.wrapException((String)this.path, (String)e.getMessage(), (IOException)e);
        }
        finally {
            if (this.contextEncryptionAdapter != null) {
                this.contextEncryptionAdapter.destroy();
            }
            if (this.hasLease()) {
                this.lease.free();
                this.lease = null;
            }
            this.lastError = new IOException("Stream is closed!");
            this.buffer = null;
            this.bufferIndex = 0;
            this.closed = true;
            this.writeOperations.clear();
            if (this.hasActiveBlock()) {
                this.clearActiveBlock();
            }
        }
        LOG.debug("Closing AbfsOutputStream : {}", (Object)this);
    }

    private synchronized void flushInternal(boolean isClose) throws IOException {
        this.maybeThrowLastError();
        if (!this.isAppendBlob && this.enableSmallWriteOptimization && this.numOfAppendsToServerSinceLastFlush == 0 && this.writeOperations.size() == 0 && this.hasActiveBlockDataToUpload()) {
            this.smallWriteOptimizedflushInternal(isClose);
            return;
        }
        if (this.hasActiveBlockDataToUpload()) {
            this.uploadCurrentBlock();
        }
        this.flushWrittenBytesToService(isClose);
        this.numOfAppendsToServerSinceLastFlush = 0;
    }

    private synchronized void smallWriteOptimizedflushInternal(boolean isClose) throws IOException {
        this.uploadBlockAsync(this.getActiveBlock(), true, isClose);
        this.waitForAppendsToComplete();
        this.shrinkWriteOperationQueue();
        this.maybeThrowLastError();
        this.numOfAppendsToServerSinceLastFlush = 0;
    }

    private synchronized void flushInternalAsync() throws IOException {
        this.maybeThrowLastError();
        if (this.hasActiveBlockDataToUpload()) {
            this.uploadCurrentBlock();
        }
        this.waitForAppendsToComplete();
        this.flushWrittenBytesToServiceAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void writeAppendBlobCurrentBufferToService() throws IOException {
        Throwable throwable;
        AbfsPerfInfo perfInfo;
        DataBlocks.BlockUploadData uploadData;
        int bytesLength;
        DataBlocks.DataBlock activeBlock;
        block17: {
            block18: {
                activeBlock = this.getActiveBlock();
                if (!this.hasActiveBlockDataToUpload()) {
                    return;
                }
                bytesLength = activeBlock.dataSize();
                uploadData = activeBlock.startUpload();
                this.clearActiveBlock();
                this.outputStreamStatistics.writeCurrentBuffer();
                this.outputStreamStatistics.bytesToUpload(bytesLength);
                long offset = this.position;
                this.position += (long)bytesLength;
                AbfsPerfTracker tracker = this.client.getAbfsPerfTracker();
                perfInfo = new AbfsPerfInfo(tracker, "writeCurrentBufferToService", "append");
                throwable = null;
                AppendRequestParameters reqParams = new AppendRequestParameters(offset, 0, bytesLength, AppendRequestParameters.Mode.APPEND_MODE, true, this.leaseId, this.isExpectHeaderEnabled);
                AbfsRestOperation op = this.getClient().append(this.path, uploadData.toByteArray(), reqParams, this.cachedSasToken.get(), this.contextEncryptionAdapter, new TracingContext(this.tracingContext));
                this.cachedSasToken.update(op.getSasToken());
                this.outputStreamStatistics.uploadSuccessful(bytesLength);
                perfInfo.registerResult(op.getResult());
                perfInfo.registerSuccess(true);
                if (perfInfo == null) break block17;
                if (throwable == null) break block18;
                try {
                    perfInfo.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block17;
            }
            perfInfo.close();
        }
        org.apache.commons.io.IOUtils.close((Closeable[])new Closeable[]{uploadData, activeBlock});
        return;
        {
            catch (Throwable throwable3) {
                try {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (perfInfo != null) {
                                if (throwable != null) {
                                    try {
                                        perfInfo.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    perfInfo.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (Exception ex) {
                        this.outputStreamStatistics.uploadFailed(bytesLength);
                        this.failureWhileSubmit(ex);
                        org.apache.commons.io.IOUtils.close((Closeable[])new Closeable[]{uploadData, activeBlock});
                    }
                }
                catch (Throwable throwable6) {
                    org.apache.commons.io.IOUtils.close((Closeable[])new Closeable[]{uploadData, activeBlock});
                    throw throwable6;
                }
            }
        }
    }

    private synchronized void waitForAppendsToComplete() throws IOException {
        for (WriteOperation writeOperation : this.writeOperations) {
            try {
                writeOperation.task.get();
            }
            catch (Exception ex2) {
                AzureBlobFileSystemException ex2;
                this.outputStreamStatistics.uploadFailed(writeOperation.length);
                if (ex2.getCause() instanceof AbfsRestOperationException && ((AbfsRestOperationException)ex2.getCause()).getStatusCode() == 404) {
                    throw new FileNotFoundException(ex2.getMessage());
                }
                if (ex2.getCause() instanceof AzureBlobFileSystemException) {
                    ex2 = (AzureBlobFileSystemException)ex2.getCause();
                }
                this.lastError = new IOException(ex2);
                throw this.lastError;
            }
        }
    }

    private synchronized void flushWrittenBytesToService(boolean isClose) throws IOException {
        this.waitForAppendsToComplete();
        this.flushWrittenBytesToServiceInternal(this.position, false, isClose);
    }

    private synchronized void flushWrittenBytesToServiceAsync() throws IOException {
        this.shrinkWriteOperationQueue();
        if (this.lastTotalAppendOffset > this.lastFlushOffset) {
            this.flushWrittenBytesToServiceInternal(this.lastTotalAppendOffset, true, false);
        }
    }

    private synchronized void flushWrittenBytesToServiceInternal(long offset, boolean retainUncommitedData, boolean isClose) throws IOException {
        if (this.isAppendBlob && !isClose) {
            return;
        }
        AbfsPerfTracker tracker = this.client.getAbfsPerfTracker();
        try (AbfsPerfInfo perfInfo = new AbfsPerfInfo(tracker, "flushWrittenBytesToServiceInternal", "flush");){
            AbfsRestOperation op = this.getClient().flush(this.path, offset, retainUncommitedData, isClose, this.cachedSasToken.get(), this.leaseId, this.contextEncryptionAdapter, new TracingContext(this.tracingContext));
            this.cachedSasToken.update(op.getSasToken());
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
        catch (AzureBlobFileSystemException ex) {
            if (ex instanceof AbfsRestOperationException && ((AbfsRestOperationException)ex).getStatusCode() == 404) {
                throw new FileNotFoundException(ex.getMessage());
            }
            this.lastError = new IOException(ex);
            throw this.lastError;
        }
        this.lastFlushOffset = offset;
    }

    private synchronized void shrinkWriteOperationQueue() throws IOException {
        try {
            WriteOperation peek = this.writeOperations.peek();
            while (peek != null && peek.task.isDone()) {
                peek.task.get();
                this.lastTotalAppendOffset += peek.length;
                this.writeOperations.remove();
                peek = this.writeOperations.peek();
                this.outputStreamStatistics.queueShrunk();
            }
        }
        catch (Exception e) {
            this.lastError = e.getCause() instanceof AzureBlobFileSystemException ? (AzureBlobFileSystemException)e.getCause() : new IOException(e);
            throw this.lastError;
        }
    }

    @VisibleForTesting
    public synchronized void waitForPendingUploads() throws IOException {
        this.waitForAppendsToComplete();
    }

    @VisibleForTesting
    public AbfsOutputStreamStatistics getOutputStreamStatistics() {
        return this.outputStreamStatistics;
    }

    @VisibleForTesting
    public int getWriteOperationsSize() {
        return this.writeOperations.size();
    }

    @VisibleForTesting
    int getMaxConcurrentRequestCount() {
        return this.maxConcurrentRequestCount;
    }

    @VisibleForTesting
    int getMaxRequestsThatCanBeQueued() {
        return this.maxRequestsThatCanBeQueued;
    }

    @VisibleForTesting
    Boolean isAppendBlobStream() {
        return this.isAppendBlob;
    }

    public IOStatistics getIOStatistics() {
        return this.ioStatistics;
    }

    @VisibleForTesting
    public boolean isLeaseFreed() {
        if (this.lease == null) {
            return true;
        }
        return this.lease.isFreed();
    }

    @VisibleForTesting
    public boolean hasLease() {
        return this.lease != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("AbfsOutputStream@").append(this.hashCode());
        sb.append("){");
        sb.append(this.outputStreamStatistics.toString());
        sb.append("}");
        return sb.toString();
    }

    @VisibleForTesting
    BackReference getFsBackRef() {
        return this.fsBackRef;
    }

    @VisibleForTesting
    ListeningExecutorService getExecutorService() {
        return this.executorService;
    }

    @VisibleForTesting
    AbfsClient getClient() {
        return this.client;
    }

    private static class WriteOperation {
        private final Future<Void> task;
        private final long startOffset;
        private final long length;

        WriteOperation(Future<Void> task, long startOffset, long length) {
            Preconditions.checkNotNull(task, (Object)"task");
            Preconditions.checkArgument((startOffset >= 0L ? 1 : 0) != 0, (Object)"startOffset");
            Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"length");
            this.task = task;
            this.startOffset = startOffset;
            this.length = length;
        }
    }
}

