/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356;

import java.util.Map;
import org.apache.hadoop.shaded.javax.websocket.ClientEndpointConfig;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.client.io.UpgradeListener;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.JsrHandshakeResponse;

public class JsrUpgradeListener
implements UpgradeListener {
    private ClientEndpointConfig.Configurator configurator;

    public JsrUpgradeListener(ClientEndpointConfig.Configurator configurator) {
        this.configurator = configurator;
    }

    public void onHandshakeRequest(UpgradeRequest request) {
        if (this.configurator == null) {
            return;
        }
        Map headers = request.getHeaders();
        this.configurator.beforeRequest(headers);
        request.setHeaders(headers);
    }

    public void onHandshakeResponse(UpgradeResponse response) {
        if (this.configurator == null) {
            return;
        }
        JsrHandshakeResponse hr = new JsrHandshakeResponse(response);
        this.configurator.afterResponse(hr);
    }
}

