/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.impl.prefetch.Validate;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.federation.policies.RouterPolicyFacade;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.resolver.SubClusterResolver;
import org.apache.hadoop.yarn.server.federation.retry.FederationActionRetry;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.NodeIDsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebAppUtil;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ActivitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppActivitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppAttemptsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppPriority;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppQueue;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppState;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppTimeoutInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppTimeoutsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationStatisticsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationSubmissionContextInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.BulkActivitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterUserInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.DelegationToken;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.LabelsToNodesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeLabelInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeLabelsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsEntry;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsEntryList;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.RMQueueAclInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationDefinitionInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationDeleteRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationSubmissionRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationUpdateRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceOptionInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerTypeInfo;
import org.apache.hadoop.yarn.server.router.RouterAuditLogger;
import org.apache.hadoop.yarn.server.router.RouterMetrics;
import org.apache.hadoop.yarn.server.router.RouterServerUtil;
import org.apache.hadoop.yarn.server.router.clientrm.ClientMethod;
import org.apache.hadoop.yarn.server.router.clientrm.RouterClientRMService;
import org.apache.hadoop.yarn.server.router.security.RouterDelegationTokenSecretManager;
import org.apache.hadoop.yarn.server.router.webapp.AbstractRESTRequestInterceptor;
import org.apache.hadoop.yarn.server.router.webapp.DefaultRequestInterceptorREST;
import org.apache.hadoop.yarn.server.router.webapp.RESTRequestInterceptor;
import org.apache.hadoop.yarn.server.router.webapp.RouterWebServiceUtil;
import org.apache.hadoop.yarn.server.router.webapp.cache.RouterAppInfoCacheKey;
import org.apache.hadoop.yarn.server.router.webapp.dao.FederationBulkActivitiesInfo;
import org.apache.hadoop.yarn.server.router.webapp.dao.FederationClusterInfo;
import org.apache.hadoop.yarn.server.router.webapp.dao.FederationClusterUserInfo;
import org.apache.hadoop.yarn.server.router.webapp.dao.FederationConfInfo;
import org.apache.hadoop.yarn.server.router.webapp.dao.FederationRMQueueAclInfo;
import org.apache.hadoop.yarn.server.router.webapp.dao.FederationSchedulerTypeInfo;
import org.apache.hadoop.yarn.server.router.webapp.dao.SubClusterResult;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainersInfo;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.LRUCacheHashMap;
import org.apache.hadoop.yarn.util.MonotonicClock;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.apache.hadoop.yarn.webapp.dao.ConfInfo;
import org.apache.hadoop.yarn.webapp.dao.SchedConfUpdateInfo;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationInterceptorREST
extends AbstractRESTRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(FederationInterceptorREST.class);
    private int numSubmitRetries;
    private FederationStateStoreFacade federationFacade;
    private RouterPolicyFacade policyFacade;
    private RouterMetrics routerMetrics;
    private final Clock clock = new MonotonicClock();
    private boolean returnPartialReport;
    private boolean appInfosCacheEnabled;
    private int appInfosCacheCount;
    private boolean allowPartialResult;
    private long submitIntervalTime;
    private Map<SubClusterId, DefaultRequestInterceptorREST> interceptors;
    private LRUCacheHashMap<RouterAppInfoCacheKey, AppsInfo> appInfosCaches;
    private ExecutorService threadpool;

    @Override
    public void init(String user) {
        super.init(user);
        this.federationFacade = FederationStateStoreFacade.getInstance((Configuration)this.getConf());
        Configuration conf = this.getConf();
        try {
            SubClusterResolver subClusterResolver = this.federationFacade.getSubClusterResolver();
            this.policyFacade = new RouterPolicyFacade(conf, this.federationFacade, subClusterResolver, null);
        }
        catch (FederationPolicyInitializationException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        this.numSubmitRetries = conf.getInt("yarn.router.submit.retry", 3);
        this.interceptors = new HashMap<SubClusterId, DefaultRequestInterceptorREST>();
        this.routerMetrics = RouterMetrics.getMetrics();
        this.threadpool = HadoopExecutors.newCachedThreadPool((ThreadFactory)new ThreadFactoryBuilder().setNameFormat("FederationInterceptorREST #%d").build());
        this.returnPartialReport = conf.getBoolean("yarn.router.webapp.partial-result.enabled", false);
        this.appInfosCacheEnabled = conf.getBoolean("yarn.router.webapp.appsinfo-enabled", false);
        if (this.appInfosCacheEnabled) {
            this.appInfosCacheCount = conf.getInt("yarn.router.webapp.appsinfo-cached-count", 100);
            this.appInfosCaches = new LRUCacheHashMap(this.appInfosCacheCount, true);
        }
        this.allowPartialResult = conf.getBoolean("yarn.router.interceptor.allow-partial-result.enable", false);
        this.submitIntervalTime = conf.getTimeDuration("yarn.router.submit.interval.time", YarnConfiguration.DEFAULT_CLIENTRM_SUBMIT_INTERVAL_TIME, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    protected DefaultRequestInterceptorREST getInterceptorForSubCluster(SubClusterId subClusterId) {
        if (this.interceptors.containsKey(subClusterId)) {
            return this.interceptors.get(subClusterId);
        }
        LOG.error("The interceptor for SubCluster {} does not exist in the cache.", (Object)subClusterId);
        return null;
    }

    private DefaultRequestInterceptorREST createInterceptorForSubCluster(SubClusterId subClusterId, String webAppAddress) {
        DefaultRequestInterceptorREST interceptorInstance;
        Configuration conf = this.getConf();
        String interceptorClassName = conf.get("yarn.router.webapp.default-interceptor-class", "org.apache.hadoop.yarn.server.router.webapp.DefaultRequestInterceptorREST");
        try {
            Class interceptorClass = conf.getClassByName(interceptorClassName);
            if (!DefaultRequestInterceptorREST.class.isAssignableFrom(interceptorClass)) {
                throw new YarnRuntimeException("Class: " + interceptorClassName + " not instance of " + DefaultRequestInterceptorREST.class.getCanonicalName());
            }
            interceptorInstance = (DefaultRequestInterceptorREST)ReflectionUtils.newInstance((Class)interceptorClass, (Configuration)conf);
            String userName = this.getUser().getUserName();
            interceptorInstance.init(userName);
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate ApplicationMasterRequestInterceptor: " + interceptorClassName, (Throwable)e);
        }
        String webAppAddressWithScheme = WebAppUtils.getHttpSchemePrefix((Configuration)conf) + webAppAddress;
        interceptorInstance.setWebAppAddress(webAppAddressWithScheme);
        interceptorInstance.setSubClusterId(subClusterId);
        this.interceptors.put(subClusterId, interceptorInstance);
        return interceptorInstance;
    }

    protected DefaultRequestInterceptorREST getOrCreateInterceptorForSubCluster(SubClusterInfo subClusterInfo) {
        if (subClusterInfo != null) {
            SubClusterId subClusterId = subClusterInfo.getSubClusterId();
            String webServiceAddress = subClusterInfo.getRMWebServiceAddress();
            return this.getOrCreateInterceptorForSubCluster(subClusterId, webServiceAddress);
        }
        return null;
    }

    protected DefaultRequestInterceptorREST getOrCreateInterceptorByAppId(String appId) throws YarnException {
        RouterServerUtil.validateApplicationId(appId);
        SubClusterInfo subClusterInfo = this.getHomeSubClusterInfoByAppId(appId);
        LOG.info("appId = {} : subClusterInfo = {}.", (Object)appId, (Object)subClusterInfo.getSubClusterId());
        return this.getOrCreateInterceptorForSubCluster(subClusterInfo);
    }

    protected DefaultRequestInterceptorREST getOrCreateInterceptorByNodeId(String nodeId) {
        SubClusterInfo subClusterInfo = this.getNodeSubcluster(nodeId);
        return this.getOrCreateInterceptorForSubCluster(subClusterInfo);
    }

    @VisibleForTesting
    protected DefaultRequestInterceptorREST getOrCreateInterceptorForSubCluster(SubClusterId subClusterId, String webAppAddress) {
        DefaultRequestInterceptorREST interceptor = this.getInterceptorForSubCluster(subClusterId);
        String webAppAddressWithScheme = WebAppUtils.getHttpSchemePrefix((Configuration)this.getConf()) + webAppAddress;
        if (interceptor == null || !webAppAddressWithScheme.equals(interceptor.getWebAppAddress())) {
            interceptor = this.createInterceptorForSubCluster(subClusterId, webAppAddress);
        }
        return interceptor;
    }

    public Response createNewApplication(HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        long startTime = this.clock.getTime();
        try {
            Map subClustersActive = this.federationFacade.getSubClusters(true);
            ArrayList blackList = new ArrayList();
            int actualRetryNums = this.federationFacade.getRetryNumbers(this.numSubmitRetries);
            Response response = (Response)((FederationActionRetry)retryCount -> this.invokeGetNewApplication(subClustersActive, blackList, hsr, retryCount)).runWithRetries(actualRetryNums, this.submitIntervalTime);
            if (response != null && response.getStatus() == 200) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededAppsCreated(stopTime - startTime);
                return response;
            }
        }
        catch (FederationPolicyException e) {
            this.routerMetrics.incrAppsFailedCreated();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get New App", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)e.getLocalizedMessage()).build();
        }
        catch (Exception e) {
            this.routerMetrics.incrAppsFailedCreated();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get New App", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).build();
        }
        String errMsg = "Fail to create a new application.";
        LOG.error(errMsg);
        this.routerMetrics.incrAppsFailedCreated();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get New App", "UNKNOWN", "RouterWebServices", errMsg);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
    }

    private Response invokeGetNewApplication(Map<SubClusterId, SubClusterInfo> subClustersActive, List<SubClusterId> blackList, HttpServletRequest hsr, int retryCount) throws YarnException, IOException, InterruptedException {
        SubClusterId subClusterId = FederationStateStoreFacade.getRandomActiveSubCluster(subClustersActive, blackList);
        LOG.info("getNewApplication try #{} on SubCluster {}.", (Object)retryCount, (Object)subClusterId);
        DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorForSubCluster(subClusterId, subClustersActive.get(subClusterId).getRMWebServiceAddress());
        try {
            Response response = interceptor.createNewApplication(hsr);
            if (response != null && response.getStatus() == 200) {
                ApplicationId applicationId = ApplicationId.fromString((String)response.getEntity().toString());
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Get New App", "RouterWebServices", applicationId, subClusterId);
                return response;
            }
        }
        catch (Exception e) {
            blackList.add(subClusterId);
            RouterServerUtil.logAndThrowException(e.getMessage(), e);
        }
        String msg = String.format("Unable to create a new ApplicationId in SubCluster %s.", subClusterId.getId());
        throw new YarnException(msg);
    }

    public Response submitApplication(ApplicationSubmissionContextInfo newApp, HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        long startTime = this.clock.getTime();
        if (newApp == null || newApp.getApplicationId() == null) {
            this.routerMetrics.incrAppsFailedSubmitted();
            String errMsg = "Missing ApplicationSubmissionContextInfo or applicationSubmissionContext information.";
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Submit New App", "UNKNOWN", "RouterWebServices", errMsg);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
        try {
            String applicationId = newApp.getApplicationId();
            RouterServerUtil.validateApplicationId(applicationId);
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrAppsFailedSubmitted();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Submit New App", "UNKNOWN", "RouterWebServices", e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getLocalizedMessage()).build();
        }
        ArrayList blackList = new ArrayList();
        try {
            int activeSubClustersCount = this.federationFacade.getActiveSubClustersCount();
            int actualRetryNums = Math.min(activeSubClustersCount, this.numSubmitRetries);
            Response response = (Response)((FederationActionRetry)retryCount -> this.invokeSubmitApplication(newApp, blackList, hsr, retryCount)).runWithRetries(actualRetryNums, this.submitIntervalTime);
            if (response != null) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededAppsSubmitted(stopTime - startTime);
                return response;
            }
        }
        catch (Exception e) {
            this.routerMetrics.incrAppsFailedSubmitted();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Submit New App", "UNKNOWN", "RouterWebServices", e.getMessage());
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)e.getLocalizedMessage()).build();
        }
        this.routerMetrics.incrAppsFailedSubmitted();
        String errMsg = String.format("Application %s with appId %s failed to be submitted.", newApp.getApplicationName(), newApp.getApplicationId());
        LOG.error(errMsg);
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Submit New App", "UNKNOWN", "RouterWebServices", errMsg);
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)errMsg).build();
    }

    private Response invokeSubmitApplication(ApplicationSubmissionContextInfo submissionContext, List<SubClusterId> blackList, HttpServletRequest hsr, int retryCount) throws YarnException, IOException, InterruptedException {
        ApplicationSubmissionContext context = RMWebAppUtil.createAppSubmissionContext((ApplicationSubmissionContextInfo)submissionContext, (Configuration)this.getConf());
        ApplicationId applicationId = ApplicationId.fromString((String)submissionContext.getApplicationId());
        SubClusterId subClusterId = null;
        try {
            subClusterId = this.policyFacade.getHomeSubcluster(context, blackList);
            LOG.info("submitApplication appId {} try #{} on SubCluster {}.", new Object[]{applicationId, retryCount, subClusterId});
            ApplicationSubmissionContext trimmedAppSubmissionContext = RouterServerUtil.getTrimmedAppSubmissionContext(context);
            this.federationFacade.addOrUpdateApplicationHomeSubCluster(applicationId, subClusterId, retryCount, trimmedAppSubmissionContext);
            SubClusterInfo subClusterInfo = this.federationFacade.getSubCluster(subClusterId);
            if (subClusterInfo == null) {
                throw new YarnException("Can't Find SubClusterId = " + subClusterId);
            }
            Response response = this.getOrCreateInterceptorForSubCluster(subClusterId, subClusterInfo.getRMWebServiceAddress()).submitApplication(submissionContext, hsr);
            if (response != null && response.getStatus() == 202) {
                LOG.info("Application {} with appId {} submitted on {}.", new Object[]{context.getApplicationName(), applicationId, subClusterId});
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Submit New App", "RouterWebServices", applicationId, subClusterId);
                return response;
            }
            String msg = String.format("application %s failed to be submitted.", applicationId);
            throw new YarnException(msg);
        }
        catch (Exception e) {
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Submit New App", "UNKNOWN", "RouterWebServices", e.getMessage(), applicationId, subClusterId);
            LOG.warn("Unable to submit the application {} to SubCluster {}.", new Object[]{applicationId, subClusterId, e});
            if (subClusterId != null) {
                blackList.add(subClusterId);
            }
            throw e;
        }
    }

    public AppInfo getApp(HttpServletRequest hsr, String appId, Set<String> unselectedFields) {
        try {
            long startTime = this.clock.getTime();
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorByAppId(appId);
            if (interceptor == null) {
                this.routerMetrics.incrAppsFailedRetrieved();
                return null;
            }
            AppInfo response = interceptor.getApp(hsr, appId, unselectedFields);
            long stopTime = this.clock.getTime();
            this.routerMetrics.succeededAppsRetrieved(stopTime - startTime);
            return response;
        }
        catch (YarnException e) {
            this.routerMetrics.incrAppsFailedRetrieved();
            LOG.error("getApp Error, applicationId = {}.", (Object)appId, (Object)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrAppsFailedRetrieved();
            throw e;
        }
    }

    public Response updateAppState(AppState targetState, HttpServletRequest hsr, String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        SubClusterInfo subClusterInfo;
        SubClusterId subClusterId;
        ApplicationId applicationId;
        long startTime = this.clock.getTime();
        try {
            applicationId = ApplicationId.fromString((String)appId);
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrAppsFailedKilled();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getLocalizedMessage()).build();
        }
        try {
            subClusterId = this.federationFacade.getApplicationHomeSubCluster(applicationId);
            subClusterInfo = this.federationFacade.getSubCluster(subClusterId);
        }
        catch (YarnException e) {
            this.routerMetrics.incrAppsFailedKilled();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getLocalizedMessage()).build();
        }
        Response response = this.getOrCreateInterceptorForSubCluster(subClusterId, subClusterInfo.getRMWebServiceAddress()).updateAppState(targetState, hsr, appId);
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededAppsRetrieved(stopTime - startTime);
        return response;
    }

    public AppsInfo getApps(HttpServletRequest hsr, String stateQuery, Set<String> statesQuery, String finalStatusQuery, String userQuery, String queueQuery, String count, String startedBegin, String startedEnd, String finishBegin, String finishEnd, Set<String> applicationTypes, Set<String> applicationTags, String name, Set<String> unselectedFields) {
        RouterAppInfoCacheKey routerAppInfoCacheKey = RouterAppInfoCacheKey.newInstance(hsr, stateQuery, statesQuery, finalStatusQuery, userQuery, queueQuery, count, startedBegin, startedEnd, finishBegin, finishEnd, applicationTypes, applicationTags, name, unselectedFields);
        if (this.appInfosCacheEnabled && routerAppInfoCacheKey != null && this.appInfosCaches.containsKey((Object)routerAppInfoCacheKey)) {
            return (AppsInfo)this.appInfosCaches.get((Object)routerAppInfoCacheKey);
        }
        AppsInfo apps = new AppsInfo();
        long startTime = this.clock.getTime();
        HttpServletRequestWrapper hsrCopy = this.clone(hsr);
        Collection subClusterInfos = this.federationFacade.getActiveSubClusters();
        List<AppsInfo> appsInfos = subClusterInfos.parallelStream().map(arg_0 -> this.lambda$getApps$2((HttpServletRequest)hsrCopy, stateQuery, statesQuery, finalStatusQuery, userQuery, queueQuery, count, startedBegin, startedEnd, finishBegin, finishEnd, applicationTypes, applicationTags, name, unselectedFields, arg_0)).collect(Collectors.toList());
        appsInfos.forEach(appsInfo -> {
            if (appsInfo != null) {
                apps.addAll(appsInfo.getApps());
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededMultipleAppsRetrieved(stopTime - startTime);
            }
        });
        if (apps.getApps().isEmpty()) {
            return new AppsInfo();
        }
        AppsInfo resultAppsInfo = RouterWebServiceUtil.mergeAppsInfo(apps.getApps(), this.returnPartialReport);
        if (this.appInfosCacheEnabled && routerAppInfoCacheKey != null) {
            this.appInfosCaches.put((Object)routerAppInfoCacheKey, (Object)resultAppsInfo);
        }
        return resultAppsInfo;
    }

    private HttpServletRequestWrapper clone(HttpServletRequest hsr) {
        if (hsr == null) {
            return null;
        }
        final Map parameterMap = hsr.getParameterMap();
        final String pathInfo = hsr.getPathInfo();
        final String user = hsr.getRemoteUser();
        final Principal principal = hsr.getUserPrincipal();
        final String mediaType = RouterWebServiceUtil.getMediaTypeFromHttpServletRequest(hsr, AppsInfo.class);
        return new HttpServletRequestWrapper(hsr){

            public Map<String, String[]> getParameterMap() {
                return parameterMap;
            }

            public String getPathInfo() {
                return pathInfo;
            }

            public String getRemoteUser() {
                return user;
            }

            public Principal getUserPrincipal() {
                return principal;
            }

            public String getHeader(String value) {
                if (value.equals("Accept")) {
                    return mediaType;
                }
                return null;
            }
        };
    }

    private SubClusterInfo getActiveSubCluster(String subClusterId) throws NotFoundException {
        try {
            SubClusterId pSubClusterId = SubClusterId.newInstance((String)subClusterId);
            return this.federationFacade.getSubCluster(pSubClusterId);
        }
        catch (YarnException e) {
            throw new NotFoundException(e.getMessage());
        }
    }

    public NodeInfo getNode(String nodeId) {
        Collection subClustersActive = this.federationFacade.getActiveSubClusters();
        if (subClustersActive.isEmpty()) {
            throw new NotFoundException("No active SubCluster available to submit the request.");
        }
        Map<SubClusterInfo, NodeInfo> results = this.getNode(subClustersActive, nodeId);
        NodeInfo nodeInfo = null;
        for (NodeInfo nodeResponse : results.values()) {
            try {
                if (nodeInfo != null && nodeInfo.getLastHealthUpdate() >= nodeResponse.getLastHealthUpdate()) continue;
                nodeInfo = nodeResponse;
            }
            catch (Throwable e) {
                LOG.warn("Failed to get node report ", e);
            }
        }
        if (nodeInfo == null) {
            throw new NotFoundException("nodeId, " + nodeId + ", is not found");
        }
        return nodeInfo;
    }

    private Map<SubClusterInfo, NodeInfo> getNode(Collection<SubClusterInfo> subClusters, String nodeId) {
        Stream<Pair> pairStream = subClusters.parallelStream().map(subClusterInfo -> {
            SubClusterId subClusterId = subClusterInfo.getSubClusterId();
            try {
                DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorForSubCluster((SubClusterInfo)subClusterInfo);
                return Pair.of((Object)subClusterInfo, (Object)interceptor.getNode(nodeId));
            }
            catch (Exception e) {
                LOG.error("Subcluster {} failed to return nodeInfo.", (Object)subClusterId, (Object)e);
                return null;
            }
        });
        HashMap<SubClusterInfo, NodeInfo> results = new HashMap<SubClusterInfo, NodeInfo>();
        pairStream.forEach(pair -> {
            if (pair != null) {
                SubClusterInfo subCluster = (SubClusterInfo)pair.getKey();
                NodeInfo nodeInfo = (NodeInfo)pair.getValue();
                results.put(subCluster, nodeInfo);
            }
        });
        return results;
    }

    private SubClusterInfo getNodeSubcluster(String nodeId) throws NotFoundException {
        Collection subClusters = this.federationFacade.getActiveSubClusters();
        Map<SubClusterInfo, NodeInfo> results = this.getNode(subClusters, nodeId);
        SubClusterInfo subcluster = null;
        NodeInfo nodeInfo = null;
        for (Map.Entry<SubClusterInfo, NodeInfo> entry : results.entrySet()) {
            NodeInfo nodeResponse = entry.getValue();
            if (nodeInfo != null && nodeInfo.getLastHealthUpdate() >= nodeResponse.getLastHealthUpdate()) continue;
            subcluster = entry.getKey();
            nodeInfo = nodeResponse;
        }
        if (subcluster == null) {
            throw new NotFoundException("Cannot find " + nodeId + " in any subcluster");
        }
        return subcluster;
    }

    public NodesInfo getNodes(String states) {
        NodesInfo nodes = new NodesInfo();
        try {
            Collection subClustersActive = this.federationFacade.getActiveSubClusters();
            Class[] argsClasses = new Class[]{String.class};
            Object[] args = new Object[]{states};
            ClientMethod remoteMethod = new ClientMethod("getNodes", argsClasses, args);
            Map<SubClusterInfo, NodesInfo> nodesMap = this.invokeConcurrent(subClustersActive, remoteMethod, NodesInfo.class);
            nodesMap.values().forEach(nodesInfo -> nodes.addAll(nodesInfo.getNodes()));
        }
        catch (NotFoundException e) {
            LOG.error("get all active sub cluster(s) error.", (Throwable)e);
            throw e;
        }
        catch (YarnException e) {
            LOG.error("getNodes by states = {} error.", (Object)states, (Object)e);
            throw new YarnRuntimeException((Throwable)e);
        }
        catch (IOException e) {
            LOG.error("getNodes by states = {} error with io error.", (Object)states, (Object)e);
            throw new YarnRuntimeException((Throwable)e);
        }
        return RouterWebServiceUtil.deleteDuplicateNodesInfo(nodes.getNodes());
    }

    public ResourceInfo updateNodeResource(HttpServletRequest hsr, String nodeId, ResourceOptionInfo resourceOption) {
        DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorByNodeId(nodeId);
        return interceptor.updateNodeResource(hsr, nodeId, resourceOption);
    }

    public ClusterMetricsInfo getClusterMetricsInfo() {
        ClusterMetricsInfo metrics = new ClusterMetricsInfo();
        Collection subClusterInfos = this.federationFacade.getActiveSubClusters();
        Stream<ClusterMetricsInfo> clusterMetricsInfoStream = subClusterInfos.parallelStream().map(subClusterInfo -> {
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorForSubCluster((SubClusterInfo)subClusterInfo);
            try {
                return interceptor.getClusterMetricsInfo();
            }
            catch (Exception e) {
                LOG.error("Subcluster {} failed to return Cluster Metrics.", (Object)subClusterInfo.getSubClusterId());
                return null;
            }
        });
        clusterMetricsInfoStream.forEach(clusterMetricsInfo -> {
            try {
                if (clusterMetricsInfo != null) {
                    RouterWebServiceUtil.mergeMetrics(metrics, clusterMetricsInfo);
                }
            }
            catch (Throwable e) {
                LOG.warn("Failed to get nodes report.", e);
            }
        });
        return metrics;
    }

    public AppState getAppState(HttpServletRequest hsr, String appId) throws AuthorizationException {
        try {
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorByAppId(appId);
            if (interceptor != null) {
                return interceptor.getAppState(hsr, appId);
            }
        }
        catch (IllegalArgumentException | YarnException e) {
            LOG.error("getHomeSubClusterInfoByAppId error, applicationId = {}.", (Object)appId, (Object)e);
        }
        return new AppState();
    }

    public ClusterInfo get() {
        return this.getClusterInfo();
    }

    public ClusterInfo getClusterInfo() {
        try {
            long startTime = Time.now();
            Collection subClustersActive = this.federationFacade.getActiveSubClusters();
            Class[] argsClasses = new Class[]{};
            Object[] args = new Object[]{};
            ClientMethod remoteMethod = new ClientMethod("getClusterInfo", argsClasses, args);
            Map<SubClusterInfo, ClusterInfo> subClusterInfoMap = this.invokeConcurrent(subClustersActive, remoteMethod, ClusterInfo.class);
            FederationClusterInfo federationClusterInfo = new FederationClusterInfo();
            subClusterInfoMap.forEach((subClusterInfo, clusterInfo) -> {
                SubClusterId subClusterId = subClusterInfo.getSubClusterId();
                clusterInfo.setSubClusterId(subClusterId.getId());
                federationClusterInfo.getList().add((ClusterInfo)clusterInfo);
            });
            long stopTime = Time.now();
            RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Get ClusterInfo", "RouterWebServices");
            this.routerMetrics.succeededGetClusterInfoRetrieved(stopTime - startTime);
            return federationClusterInfo;
        }
        catch (NotFoundException e) {
            this.routerMetrics.incrGetClusterInfoFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get ClusterInfo", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("Get all active sub cluster(s) error.", e);
        }
        catch (IOException | YarnException e) {
            this.routerMetrics.incrGetClusterInfoFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get ClusterInfo", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("getClusterInfo error.", e);
        }
        this.routerMetrics.incrGetClusterInfoFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get ClusterInfo", "UNKNOWN", "RouterWebServices", "getClusterInfo error.");
        throw new RuntimeException("getClusterInfo error.");
    }

    public ClusterUserInfo getClusterUserInfo(HttpServletRequest hsr) {
        try {
            long startTime = Time.now();
            Collection subClustersActive = this.federationFacade.getActiveSubClusters();
            HttpServletRequestWrapper hsrCopy = this.clone(hsr);
            Class[] argsClasses = new Class[]{HttpServletRequest.class};
            Object[] args = new Object[]{hsrCopy};
            ClientMethod remoteMethod = new ClientMethod("getClusterUserInfo", argsClasses, args);
            Map<SubClusterInfo, ClusterUserInfo> subClusterInfoMap = this.invokeConcurrent(subClustersActive, remoteMethod, ClusterUserInfo.class);
            FederationClusterUserInfo federationClusterUserInfo = new FederationClusterUserInfo();
            subClusterInfoMap.forEach((subClusterInfo, clusterUserInfo) -> {
                SubClusterId subClusterId = subClusterInfo.getSubClusterId();
                clusterUserInfo.setSubClusterId(subClusterId.getId());
                federationClusterUserInfo.getList().add((ClusterUserInfo)clusterUserInfo);
            });
            long stopTime = Time.now();
            RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Get ClusterUserInfo", "RouterWebServices");
            this.routerMetrics.succeededGetClusterUserInfoRetrieved(stopTime - startTime);
            return federationClusterUserInfo;
        }
        catch (NotFoundException e) {
            this.routerMetrics.incrGetClusterUserInfoFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get ClusterUserInfo", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("Get all active sub cluster(s) error.", e);
        }
        catch (IOException | YarnException e) {
            this.routerMetrics.incrGetClusterUserInfoFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get ClusterUserInfo", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("getClusterUserInfo error.", e);
        }
        this.routerMetrics.incrGetClusterUserInfoFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get ClusterUserInfo", "UNKNOWN", "RouterWebServices", "getClusterUserInfo error.");
        throw new RuntimeException("getClusterUserInfo error.");
    }

    public SchedulerTypeInfo getSchedulerInfo() {
        try {
            long startTime = Time.now();
            Collection subClustersActive = this.federationFacade.getActiveSubClusters();
            Class[] argsClasses = new Class[]{};
            Object[] args = new Object[]{};
            ClientMethod remoteMethod = new ClientMethod("getSchedulerInfo", argsClasses, args);
            Map<SubClusterInfo, SchedulerTypeInfo> subClusterInfoMap = this.invokeConcurrent(subClustersActive, remoteMethod, SchedulerTypeInfo.class);
            FederationSchedulerTypeInfo federationSchedulerTypeInfo = new FederationSchedulerTypeInfo();
            subClusterInfoMap.forEach((subClusterInfo, schedulerTypeInfo) -> {
                SubClusterId subClusterId = subClusterInfo.getSubClusterId();
                schedulerTypeInfo.setSubClusterId(subClusterId.getId());
                federationSchedulerTypeInfo.getList().add((SchedulerTypeInfo)schedulerTypeInfo);
            });
            long stopTime = Time.now();
            RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Get SchedulerInfo", "RouterWebServices");
            this.routerMetrics.succeededGetSchedulerInfoRetrieved(stopTime - startTime);
            return federationSchedulerTypeInfo;
        }
        catch (NotFoundException e) {
            this.routerMetrics.incrGetSchedulerInfoFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get SchedulerInfo", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("Get all active sub cluster(s) error.", e);
        }
        catch (IOException | YarnException e) {
            this.routerMetrics.incrGetSchedulerInfoFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get SchedulerInfo", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("getSchedulerInfo error.", e);
        }
        this.routerMetrics.incrGetSchedulerInfoFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get SchedulerInfo", "UNKNOWN", "RouterWebServices", "getSchedulerInfo error.");
        throw new RuntimeException("getSchedulerInfo error.");
    }

    public String dumpSchedulerLogs(String time, HttpServletRequest hsr) throws IOException {
        if (StringUtils.isBlank((CharSequence)time)) {
            this.routerMetrics.incrDumpSchedulerLogsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Dump SchedulerLogs", "UNKNOWN", "RouterWebServices", "Parameter error, the time is empty or null.");
            throw new IllegalArgumentException("Parameter error, the time is empty or null.");
        }
        try {
            int period = Integer.parseInt(time);
            if (period <= 0) {
                throw new IllegalArgumentException("time must be greater than 0.");
            }
        }
        catch (NumberFormatException e) {
            this.routerMetrics.incrDumpSchedulerLogsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Dump SchedulerLogs", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            throw new IllegalArgumentException("time must be a number.");
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrDumpSchedulerLogsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Dump SchedulerLogs", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            throw e;
        }
        try {
            long startTime = this.clock.getTime();
            Collection subClustersActive = this.federationFacade.getActiveSubClusters();
            HttpServletRequestWrapper hsrCopy = this.clone(hsr);
            Class[] argsClasses = new Class[]{String.class, HttpServletRequest.class};
            Object[] args = new Object[]{time, hsrCopy};
            ClientMethod remoteMethod = new ClientMethod("dumpSchedulerLogs", argsClasses, args);
            Map<SubClusterInfo, String> dumpSchedulerLogsMap = this.invokeConcurrent(subClustersActive, remoteMethod, String.class);
            StringBuilder stringBuilder = new StringBuilder();
            dumpSchedulerLogsMap.forEach((subClusterInfo, msg) -> {
                SubClusterId subClusterId = subClusterInfo.getSubClusterId();
                stringBuilder.append("subClusterId").append(subClusterId).append(" : ").append((String)msg).append("; ");
            });
            long stopTime = this.clock.getTime();
            RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Dump SchedulerLogs", "RouterWebServices");
            this.routerMetrics.succeededDumpSchedulerLogsRetrieved(stopTime - startTime);
            return stringBuilder.toString();
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrDumpSchedulerLogsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Dump SchedulerLogs", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException(e, "Unable to dump SchedulerLogs by time: %s.", time);
        }
        catch (YarnException e) {
            this.routerMetrics.incrDumpSchedulerLogsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Dump SchedulerLogs", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException(e, "dumpSchedulerLogs by time = %s error .", time);
        }
        this.routerMetrics.incrDumpSchedulerLogsFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Dump SchedulerLogs", "UNKNOWN", "RouterWebServices", "dumpSchedulerLogs Failed.");
        throw new RuntimeException("dumpSchedulerLogs Failed.");
    }

    public ActivitiesInfo getActivities(HttpServletRequest hsr, String nodeId, String groupBy) {
        try {
            Validate.checkNotNullAndNotEmpty((String)nodeId, (String)"nodeId");
            Validate.checkNotNullAndNotEmpty((String)groupBy, (String)"groupBy");
            long startTime = this.clock.getTime();
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorByNodeId(nodeId);
            HttpServletRequestWrapper hsrCopy = this.clone(hsr);
            ActivitiesInfo activitiesInfo = interceptor.getActivities((HttpServletRequest)hsrCopy, nodeId, groupBy);
            if (activitiesInfo != null) {
                long stopTime = this.clock.getTime();
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Get Activities", "RouterWebServices");
                this.routerMetrics.succeededGetActivitiesLatencyRetrieved(stopTime - startTime);
                return activitiesInfo;
            }
        }
        catch (IllegalArgumentException | NotFoundException e) {
            this.routerMetrics.incrGetActivitiesFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get Activities", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            throw e;
        }
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get Activities", "UNKNOWN", "RouterWebServices", "getActivities Failed.");
        this.routerMetrics.incrGetActivitiesFailedRetrieved();
        throw new RuntimeException("getActivities Failed.");
    }

    public BulkActivitiesInfo getBulkActivities(HttpServletRequest hsr, String groupBy, int activitiesCount) throws InterruptedException {
        try {
            Validate.checkNotNullAndNotEmpty((String)groupBy, (String)"groupBy");
            Validate.checkNotNegative((long)activitiesCount, (String)"activitiesCount");
            Collection subClustersActive = this.federationFacade.getActiveSubClusters();
            HttpServletRequestWrapper hsrCopy = this.clone(hsr);
            Class[] argsClasses = new Class[]{HttpServletRequest.class, String.class, Integer.TYPE};
            Object[] args = new Object[]{hsrCopy, groupBy, activitiesCount};
            ClientMethod remoteMethod = new ClientMethod("getBulkActivities", argsClasses, args);
            Map<SubClusterInfo, BulkActivitiesInfo> appStatisticsMap = this.invokeConcurrent(subClustersActive, remoteMethod, BulkActivitiesInfo.class);
            long startTime = this.clock.getTime();
            FederationBulkActivitiesInfo fedBulkActivitiesInfo = new FederationBulkActivitiesInfo();
            appStatisticsMap.forEach((subClusterInfo, bulkActivitiesInfo) -> {
                SubClusterId subClusterId = subClusterInfo.getSubClusterId();
                bulkActivitiesInfo.setSubClusterId(subClusterId.getId());
                fedBulkActivitiesInfo.getList().add((BulkActivitiesInfo)bulkActivitiesInfo);
            });
            RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Get BulkActivities", "RouterWebServices");
            long stopTime = this.clock.getTime();
            this.routerMetrics.succeededGetBulkActivitiesRetrieved(stopTime - startTime);
            return fedBulkActivitiesInfo;
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrGetBulkActivitiesFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get BulkActivities", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            throw e;
        }
        catch (NotFoundException e) {
            this.routerMetrics.incrGetBulkActivitiesFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get BulkActivities", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("get all active sub cluster(s) error.", e);
        }
        catch (IOException e) {
            this.routerMetrics.incrGetBulkActivitiesFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get BulkActivities", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException(e, "getBulkActivities by groupBy = %s, activitiesCount = %s with io error.", groupBy, String.valueOf(activitiesCount));
        }
        catch (YarnException e) {
            this.routerMetrics.incrGetBulkActivitiesFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get BulkActivities", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException(e, "getBulkActivities by groupBy = %s, activitiesCount = %s with yarn error.", groupBy, String.valueOf(activitiesCount));
        }
        this.routerMetrics.incrGetBulkActivitiesFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get BulkActivities", "UNKNOWN", "RouterWebServices", "getBulkActivities Failed.");
        throw new RuntimeException("getBulkActivities Failed.");
    }

    public AppActivitiesInfo getAppActivities(HttpServletRequest hsr, String appId, String time, Set<String> requestPriorities, Set<String> allocationRequestIds, String groupBy, String limit, Set<String> actions, boolean summarize) {
        try {
            long startTime = this.clock.getTime();
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorByAppId(appId);
            HttpServletRequestWrapper hsrCopy = this.clone(hsr);
            AppActivitiesInfo appActivitiesInfo = interceptor.getAppActivities((HttpServletRequest)hsrCopy, appId, time, requestPriorities, allocationRequestIds, groupBy, limit, actions, summarize);
            if (appActivitiesInfo != null) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededGetAppActivitiesRetrieved(stopTime - startTime);
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Get AppActivities", "RouterWebServices");
                return appActivitiesInfo;
            }
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrGetAppActivitiesFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get AppActivities", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException(e, "Unable to get subCluster by appId: %s.", appId);
        }
        catch (YarnException e) {
            this.routerMetrics.incrGetAppActivitiesFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get AppActivities", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException(e, "getAppActivities by appId = %s error .", appId);
        }
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get AppActivities", "UNKNOWN", "RouterWebServices", "getAppActivities Failed.");
        this.routerMetrics.incrGetAppActivitiesFailedRetrieved();
        throw new RuntimeException("getAppActivities Failed.");
    }

    public ApplicationStatisticsInfo getAppStatistics(HttpServletRequest hsr, Set<String> stateQueries, Set<String> typeQueries) {
        try {
            long startTime = this.clock.getTime();
            Collection subClustersActive = this.federationFacade.getActiveSubClusters();
            HttpServletRequestWrapper hsrCopy = this.clone(hsr);
            Class[] argsClasses = new Class[]{HttpServletRequest.class, Set.class, Set.class};
            Object[] args = new Object[]{hsrCopy, stateQueries, typeQueries};
            ClientMethod remoteMethod = new ClientMethod("getAppStatistics", argsClasses, args);
            Map<SubClusterInfo, ApplicationStatisticsInfo> appStatisticsMap = this.invokeConcurrent(subClustersActive, remoteMethod, ApplicationStatisticsInfo.class);
            ApplicationStatisticsInfo applicationStatisticsInfo = RouterWebServiceUtil.mergeApplicationStatisticsInfo(appStatisticsMap.values());
            if (applicationStatisticsInfo != null) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededGetAppStatisticsRetrieved(stopTime - startTime);
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Get AppStatistics", "RouterWebServices");
                return applicationStatisticsInfo;
            }
        }
        catch (NotFoundException e) {
            this.routerMetrics.incrGetAppStatisticsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get AppStatistics", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("get all active sub cluster(s) error.", e);
        }
        catch (IOException e) {
            this.routerMetrics.incrGetAppStatisticsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get AppStatistics", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException(e, "getAppStatistics error by stateQueries = %s, typeQueries = %s with io error.", StringUtils.join(stateQueries, (String)","), StringUtils.join(typeQueries, (String)","));
        }
        catch (YarnException e) {
            this.routerMetrics.incrGetAppStatisticsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get AppStatistics", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException(e, "getAppStatistics by stateQueries = %s, typeQueries = %s with yarn error.", StringUtils.join(stateQueries, (String)","), StringUtils.join(typeQueries, (String)","));
        }
        this.routerMetrics.incrGetAppStatisticsFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get AppStatistics", "UNKNOWN", "RouterWebServices", "getAppStatistics Failed.");
        throw RouterServerUtil.logAndReturnRunTimeException("getAppStatistics by stateQueries = %s, typeQueries = %s Failed.", StringUtils.join(stateQueries, (String)","), StringUtils.join(typeQueries, (String)","));
    }

    public NodeToLabelsInfo getNodeToLabels(HttpServletRequest hsr) throws IOException {
        try {
            long startTime = this.clock.getTime();
            Collection subClustersActive = this.federationFacade.getActiveSubClusters();
            HttpServletRequestWrapper hsrCopy = this.clone(hsr);
            Class[] argsClasses = new Class[]{HttpServletRequest.class};
            Object[] args = new Object[]{hsrCopy};
            ClientMethod remoteMethod = new ClientMethod("getNodeToLabels", argsClasses, args);
            Map<SubClusterInfo, NodeToLabelsInfo> nodeToLabelsInfoMap = this.invokeConcurrent(subClustersActive, remoteMethod, NodeToLabelsInfo.class);
            NodeToLabelsInfo nodeToLabelsInfo = RouterWebServiceUtil.mergeNodeToLabels(nodeToLabelsInfoMap);
            if (nodeToLabelsInfo != null) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededGetNodeToLabelsRetrieved(stopTime - startTime);
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Get NodeToLabels", "RouterWebServices");
                return nodeToLabelsInfo;
            }
        }
        catch (NotFoundException e) {
            this.routerMetrics.incrNodeToLabelsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get NodeToLabels", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowIOException("get all active sub cluster(s) error.", e);
        }
        catch (YarnException e) {
            this.routerMetrics.incrNodeToLabelsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get NodeToLabels", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowIOException("getNodeToLabels error.", e);
        }
        this.routerMetrics.incrNodeToLabelsFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get NodeToLabels", "UNKNOWN", "RouterWebServices", "getNodeToLabels Failed.");
        throw new RuntimeException("getNodeToLabels Failed.");
    }

    public NodeLabelsInfo getRMNodeLabels(HttpServletRequest hsr) throws IOException {
        try {
            long startTime = this.clock.getTime();
            Collection subClustersActive = this.federationFacade.getActiveSubClusters();
            HttpServletRequestWrapper hsrCopy = this.clone(hsr);
            Class[] argsClasses = new Class[]{HttpServletRequest.class};
            Object[] args = new Object[]{hsrCopy};
            ClientMethod remoteMethod = new ClientMethod("getRMNodeLabels", argsClasses, args);
            Map<SubClusterInfo, NodeLabelsInfo> nodeToLabelsInfoMap = this.invokeConcurrent(subClustersActive, remoteMethod, NodeLabelsInfo.class);
            NodeLabelsInfo nodeToLabelsInfo = RouterWebServiceUtil.mergeNodeLabelsInfo(nodeToLabelsInfoMap);
            if (nodeToLabelsInfo != null) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededGetRMNodeLabelsRetrieved(stopTime - startTime);
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Get RMNodeLabels", "RouterWebServices");
                return nodeToLabelsInfo;
            }
        }
        catch (NotFoundException e) {
            this.routerMetrics.incrGetRMNodeLabelsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get RMNodeLabels", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowIOException("get all active sub cluster(s) error.", e);
        }
        catch (YarnException e) {
            this.routerMetrics.incrGetRMNodeLabelsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get RMNodeLabels", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowIOException("getRMNodeLabels error.", e);
        }
        this.routerMetrics.incrGetRMNodeLabelsFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get RMNodeLabels", "UNKNOWN", "RouterWebServices", "getRMNodeLabels Failed.");
        throw new RuntimeException("getRMNodeLabels Failed.");
    }

    public LabelsToNodesInfo getLabelsToNodes(Set<String> labels) throws IOException {
        try {
            long startTime = this.clock.getTime();
            Collection subClustersActive = this.federationFacade.getActiveSubClusters();
            Class[] argsClasses = new Class[]{Set.class};
            Object[] args = new Object[]{labels};
            ClientMethod remoteMethod = new ClientMethod("getLabelsToNodes", argsClasses, args);
            Map<SubClusterInfo, LabelsToNodesInfo> labelsToNodesInfoMap = this.invokeConcurrent(subClustersActive, remoteMethod, LabelsToNodesInfo.class);
            HashMap labelToNodesMap = new HashMap();
            labelsToNodesInfoMap.values().forEach(labelsToNode -> {
                Map values = labelsToNode.getLabelsToNodes();
                for (Map.Entry item : values.entrySet()) {
                    NodeLabelInfo key = (NodeLabelInfo)item.getKey();
                    NodeIDsInfo leftValue = (NodeIDsInfo)item.getValue();
                    NodeIDsInfo rightValue = labelToNodesMap.getOrDefault(key, null);
                    NodeIDsInfo newValue = NodeIDsInfo.add((NodeIDsInfo)leftValue, (NodeIDsInfo)rightValue);
                    labelToNodesMap.put(key, newValue);
                }
            });
            LabelsToNodesInfo labelsToNodesInfo = new LabelsToNodesInfo(labelToNodesMap);
            if (labelsToNodesInfo != null) {
                long stopTime = this.clock.getTime();
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Get LabelsToNodes", "RouterWebServices");
                this.routerMetrics.succeededGetLabelsToNodesRetrieved(stopTime - startTime);
                return labelsToNodesInfo;
            }
        }
        catch (NotFoundException e) {
            this.routerMetrics.incrLabelsToNodesFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get LabelsToNodes", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowIOException("get all active sub cluster(s) error.", e);
        }
        catch (YarnException e) {
            this.routerMetrics.incrLabelsToNodesFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get LabelsToNodes", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowIOException(e, "getLabelsToNodes by labels = %s with yarn error.", StringUtils.join(labels, (String)","));
        }
        this.routerMetrics.incrLabelsToNodesFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get LabelsToNodes", "UNKNOWN", "RouterWebServices", "getLabelsToNodes Failed.");
        throw RouterServerUtil.logAndReturnRunTimeException("getLabelsToNodes by labels = %s Failed.", StringUtils.join(labels, (String)","));
    }

    public Response replaceLabelsOnNodes(NodeToLabelsEntryList newNodeToLabels, HttpServletRequest hsr) throws IOException {
        if (newNodeToLabels == null) {
            this.routerMetrics.incrReplaceLabelsOnNodesFailedRetrieved();
            throw new IllegalArgumentException("Parameter error, newNodeToLabels must not be empty.");
        }
        ArrayList nodeToLabelsEntries = newNodeToLabels.getNodeToLabels();
        if (CollectionUtils.isEmpty((Collection)nodeToLabelsEntries)) {
            this.routerMetrics.incrReplaceLabelsOnNodesFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Replace LabelsOnNodes", "UNKNOWN", "RouterWebServices", "Parameter error, nodeToLabelsEntries must not be empty.");
            throw new IllegalArgumentException("Parameter error, nodeToLabelsEntries must not be empty.");
        }
        try {
            HashMap<String, NodeToLabelsEntry> nodeIdToLabels = new HashMap<String, NodeToLabelsEntry>();
            newNodeToLabels.getNodeToLabels().forEach(nodeIdToLabel -> {
                String nodeId = nodeIdToLabel.getNodeId();
                nodeIdToLabels.put(nodeId, (NodeToLabelsEntry)nodeIdToLabel);
            });
            HashMap<SubClusterInfo, NodeToLabelsEntryList> subClusterToNodeToLabelsEntryList = new HashMap<SubClusterInfo, NodeToLabelsEntryList>();
            nodeIdToLabels.forEach((nodeId, nodeToLabelsEntry) -> {
                SubClusterInfo subClusterInfo = this.getNodeSubcluster((String)nodeId);
                NodeToLabelsEntryList nodeToLabelsEntryList = subClusterToNodeToLabelsEntryList.getOrDefault(subClusterInfo, new NodeToLabelsEntryList());
                nodeToLabelsEntryList.getNodeToLabels().add(nodeToLabelsEntry);
                subClusterToNodeToLabelsEntryList.put(subClusterInfo, nodeToLabelsEntryList);
            });
            long startTime = this.clock.getTime();
            HttpServletRequestWrapper hsrCopy = this.clone(hsr);
            StringBuilder builder = new StringBuilder();
            subClusterToNodeToLabelsEntryList.forEach((arg_0, arg_1) -> this.lambda$replaceLabelsOnNodes$17((HttpServletRequest)hsrCopy, builder, arg_0, arg_1));
            long stopTime = this.clock.getTime();
            RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Replace LabelsOnNodes", "RouterWebServices");
            this.routerMetrics.succeededReplaceLabelsOnNodesRetrieved(stopTime - startTime);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)builder.toString()).build();
        }
        catch (Exception e) {
            this.routerMetrics.incrReplaceLabelsOnNodesFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Replace LabelsOnNodes", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            throw e;
        }
    }

    public Response replaceLabelsOnNode(Set<String> newNodeLabelsName, HttpServletRequest hsr, String nodeId) throws Exception {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            this.routerMetrics.incrReplaceLabelsOnNodeFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Replace LabelsOnNode", "UNKNOWN", "RouterWebServices", "Parameter error, nodeId must not be null or empty.");
            throw new IllegalArgumentException("Parameter error, nodeId must not be null or empty.");
        }
        if (CollectionUtils.isEmpty(newNodeLabelsName)) {
            this.routerMetrics.incrReplaceLabelsOnNodeFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Replace LabelsOnNode", "UNKNOWN", "RouterWebServices", "Parameter error, newNodeLabelsName must not be empty.");
            throw new IllegalArgumentException("Parameter error, newNodeLabelsName must not be empty.");
        }
        try {
            long startTime = this.clock.getTime();
            SubClusterInfo subClusterInfo = this.getNodeSubcluster(nodeId);
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorByNodeId(nodeId);
            HttpServletRequestWrapper hsrCopy = this.clone(hsr);
            interceptor.replaceLabelsOnNode(newNodeLabelsName, (HttpServletRequest)hsrCopy, nodeId);
            long stopTime = this.clock.getTime();
            RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Replace LabelsOnNode", "RouterWebServices");
            this.routerMetrics.succeededReplaceLabelsOnNodeRetrieved(stopTime - startTime);
            String msg = "subCluster#" + subClusterInfo.getSubClusterId().getId() + ":Success;";
            return Response.status((Response.Status)Response.Status.OK).entity((Object)msg).build();
        }
        catch (Exception e) {
            this.routerMetrics.incrReplaceLabelsOnNodeFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Replace LabelsOnNode", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            throw e;
        }
    }

    public NodeLabelsInfo getClusterNodeLabels(HttpServletRequest hsr) throws IOException {
        try {
            long startTime = this.clock.getTime();
            Collection subClustersActive = this.federationFacade.getActiveSubClusters();
            HttpServletRequestWrapper hsrCopy = this.clone(hsr);
            Class[] argsClasses = new Class[]{HttpServletRequest.class};
            Object[] args = new Object[]{hsrCopy};
            ClientMethod remoteMethod = new ClientMethod("getClusterNodeLabels", argsClasses, args);
            Map<SubClusterInfo, NodeLabelsInfo> nodeToLabelsInfoMap = this.invokeConcurrent(subClustersActive, remoteMethod, NodeLabelsInfo.class);
            HashSet hashSets = Sets.newHashSet();
            nodeToLabelsInfoMap.values().forEach(item -> hashSets.addAll(item.getNodeLabels()));
            NodeLabelsInfo nodeLabelsInfo = new NodeLabelsInfo((Collection)hashSets);
            if (nodeLabelsInfo != null) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededGetClusterNodeLabelsRetrieved(stopTime - startTime);
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Get ClusterNodeLabels", "RouterWebServices");
                return nodeLabelsInfo;
            }
        }
        catch (NotFoundException e) {
            this.routerMetrics.incrClusterNodeLabelsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get ClusterNodeLabels", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowIOException("get all active sub cluster(s) error.", e);
        }
        catch (YarnException e) {
            this.routerMetrics.incrClusterNodeLabelsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get ClusterNodeLabels", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowIOException("getClusterNodeLabels with yarn error.", e);
        }
        this.routerMetrics.incrClusterNodeLabelsFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get ClusterNodeLabels", "UNKNOWN", "RouterWebServices", "getClusterNodeLabels Failed.");
        throw new RuntimeException("getClusterNodeLabels Failed.");
    }

    public Response addToClusterNodeLabels(NodeLabelsInfo newNodeLabels, HttpServletRequest hsr) throws Exception {
        if (newNodeLabels == null) {
            this.routerMetrics.incrAddToClusterNodeLabelsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Add To ClusterNodeLabels", "UNKNOWN", "RouterWebServices", "Parameter error, the newNodeLabels is null.");
            throw new IllegalArgumentException("Parameter error, the newNodeLabels is null.");
        }
        ArrayList nodeLabelInfos = newNodeLabels.getNodeLabelsInfo();
        if (CollectionUtils.isEmpty((Collection)nodeLabelInfos)) {
            this.routerMetrics.incrAddToClusterNodeLabelsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Add To ClusterNodeLabels", "UNKNOWN", "RouterWebServices", "Parameter error, the nodeLabelsInfo is null or empty.");
            throw new IllegalArgumentException("Parameter error, the nodeLabelsInfo is null or empty.");
        }
        try {
            long startTime = this.clock.getTime();
            Collection subClustersActives = this.federationFacade.getActiveSubClusters();
            HttpServletRequestWrapper hsrCopy = this.clone(hsr);
            Class[] argsClasses = new Class[]{NodeLabelsInfo.class, HttpServletRequest.class};
            Object[] args = new Object[]{newNodeLabels, hsrCopy};
            ClientMethod remoteMethod = new ClientMethod("addToClusterNodeLabels", argsClasses, args);
            Map<SubClusterInfo, Response> responseInfoMap = this.invokeConcurrent(subClustersActives, remoteMethod, Response.class);
            StringBuffer buffer = new StringBuffer();
            responseInfoMap.forEach((subClusterInfo, response) -> this.buildAppendMsg((SubClusterInfo)subClusterInfo, buffer, (Response)response));
            long stopTime = this.clock.getTime();
            RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Add To ClusterNodeLabels", "RouterWebServices");
            this.routerMetrics.succeededAddToClusterNodeLabelsRetrieved(stopTime - startTime);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)buffer.toString()).build();
        }
        catch (NotFoundException e) {
            this.routerMetrics.incrAddToClusterNodeLabelsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Add To ClusterNodeLabels", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowIOException("get all active sub cluster(s) error.", e);
        }
        catch (YarnException e) {
            this.routerMetrics.incrAddToClusterNodeLabelsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Add To ClusterNodeLabels", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowIOException("addToClusterNodeLabels with yarn error.", e);
        }
        this.routerMetrics.incrAddToClusterNodeLabelsFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Add To ClusterNodeLabels", "UNKNOWN", "RouterWebServices", "addToClusterNodeLabels Failed.");
        throw new RuntimeException("addToClusterNodeLabels Failed.");
    }

    public Response removeFromClusterNodeLabels(Set<String> oldNodeLabels, HttpServletRequest hsr) throws Exception {
        if (CollectionUtils.isEmpty(oldNodeLabels)) {
            this.routerMetrics.incrRemoveFromClusterNodeLabelsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Remove From ClusterNodeLabels", "UNKNOWN", "RouterWebServices", "Parameter error, the oldNodeLabels is null or empty.");
            throw new IllegalArgumentException("Parameter error, the oldNodeLabels is null or empty.");
        }
        try {
            long startTime = this.clock.getTime();
            Collection subClustersActives = this.federationFacade.getActiveSubClusters();
            HttpServletRequestWrapper hsrCopy = this.clone(hsr);
            Class[] argsClasses = new Class[]{Set.class, HttpServletRequest.class};
            Object[] args = new Object[]{oldNodeLabels, hsrCopy};
            ClientMethod remoteMethod = new ClientMethod("removeFromClusterNodeLabels", argsClasses, args);
            Map<SubClusterInfo, Response> responseInfoMap = this.invokeConcurrent(subClustersActives, remoteMethod, Response.class);
            StringBuffer buffer = new StringBuffer();
            responseInfoMap.forEach((subClusterInfo, response) -> this.buildAppendMsg((SubClusterInfo)subClusterInfo, buffer, (Response)response));
            long stopTime = this.clock.getTime();
            RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Remove From ClusterNodeLabels", "RouterWebServices");
            this.routerMetrics.succeededRemoveFromClusterNodeLabelsRetrieved(stopTime - startTime);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)buffer.toString()).build();
        }
        catch (NotFoundException e) {
            this.routerMetrics.incrRemoveFromClusterNodeLabelsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Remove From ClusterNodeLabels", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowIOException("get all active sub cluster(s) error.", e);
        }
        catch (YarnException e) {
            this.routerMetrics.incrRemoveFromClusterNodeLabelsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Remove From ClusterNodeLabels", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowIOException("removeFromClusterNodeLabels with yarn error.", e);
        }
        this.routerMetrics.incrRemoveFromClusterNodeLabelsFailedRetrieved();
        throw new RuntimeException("removeFromClusterNodeLabels Failed.");
    }

    private void buildAppendMsg(SubClusterInfo subClusterInfo, StringBuffer buffer, Response response) {
        SubClusterId subClusterId = subClusterInfo.getSubClusterId();
        String state = response != null && response.getStatus() == Response.Status.OK.getStatusCode() ? "SUCCESS" : "FAILED";
        buffer.append("SubCluster-").append(subClusterId.getId()).append(":").append(state).append(",");
    }

    public NodeLabelsInfo getLabelsOnNode(HttpServletRequest hsr, String nodeId) throws IOException {
        try {
            long startTime = this.clock.getTime();
            Collection subClustersActive = this.federationFacade.getActiveSubClusters();
            HttpServletRequestWrapper hsrCopy = this.clone(hsr);
            Class[] argsClasses = new Class[]{HttpServletRequest.class, String.class};
            Object[] args = new Object[]{hsrCopy, nodeId};
            ClientMethod remoteMethod = new ClientMethod("getLabelsOnNode", argsClasses, args);
            Map<SubClusterInfo, NodeLabelsInfo> nodeToLabelsInfoMap = this.invokeConcurrent(subClustersActive, remoteMethod, NodeLabelsInfo.class);
            HashSet hashSets = Sets.newHashSet();
            nodeToLabelsInfoMap.values().forEach(item -> hashSets.addAll(item.getNodeLabels()));
            NodeLabelsInfo nodeLabelsInfo = new NodeLabelsInfo((Collection)hashSets);
            if (nodeLabelsInfo != null) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededGetLabelsToNodesRetrieved(stopTime - startTime);
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Get LabelsOnNode", "RouterWebServices");
                return nodeLabelsInfo;
            }
        }
        catch (NotFoundException e) {
            this.routerMetrics.incrLabelsToNodesFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get LabelsOnNode", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowIOException("get all active sub cluster(s) error.", e);
        }
        catch (YarnException e) {
            this.routerMetrics.incrLabelsToNodesFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get LabelsOnNode", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowIOException(e, "getLabelsOnNode nodeId = %s with yarn error.", nodeId);
        }
        this.routerMetrics.incrLabelsToNodesFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get LabelsOnNode", "UNKNOWN", "RouterWebServices", "getLabelsOnNode by nodeId = " + nodeId + " Failed.");
        throw RouterServerUtil.logAndReturnRunTimeException("getLabelsOnNode by nodeId = %s Failed.", nodeId);
    }

    public AppPriority getAppPriority(HttpServletRequest hsr, String appId) throws AuthorizationException {
        try {
            long startTime = this.clock.getTime();
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorByAppId(appId);
            AppPriority appPriority = interceptor.getAppPriority(hsr, appId);
            if (appPriority != null) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededGetAppPriorityRetrieved(stopTime - startTime);
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Get AppPriority", "RouterWebServices");
                return appPriority;
            }
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrGetAppPriorityFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get AppPriority", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException(e, "Unable to get the getAppPriority appId: %s.", appId);
        }
        catch (YarnException e) {
            this.routerMetrics.incrGetAppPriorityFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get AppPriority", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("getAppPriority error.", e);
        }
        this.routerMetrics.incrGetAppPriorityFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get AppPriority", "UNKNOWN", "RouterWebServices", "getAppPriority Failed.");
        throw new RuntimeException("getAppPriority Failed.");
    }

    public Response updateApplicationPriority(AppPriority targetPriority, HttpServletRequest hsr, String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        if (targetPriority == null) {
            this.routerMetrics.incrUpdateAppPriorityFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Update ApplicationPriority", "UNKNOWN", "RouterWebServices", "Parameter error, the targetPriority is empty or null.");
            throw new IllegalArgumentException("Parameter error, the targetPriority is empty or null.");
        }
        try {
            long startTime = this.clock.getTime();
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorByAppId(appId);
            Response response = interceptor.updateApplicationPriority(targetPriority, hsr, appId);
            if (response != null) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededUpdateAppPriorityRetrieved(stopTime - startTime);
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Update ApplicationPriority", "RouterWebServices");
                return response;
            }
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrUpdateAppPriorityFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Update ApplicationPriority", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException(e, "Unable to get the updateApplicationPriority appId: %s.", appId);
        }
        catch (YarnException e) {
            this.routerMetrics.incrUpdateAppPriorityFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Update ApplicationPriority", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("updateApplicationPriority error.", e);
        }
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Update ApplicationPriority", "UNKNOWN", "RouterWebServices", "getAppPriority Failed.");
        this.routerMetrics.incrUpdateAppPriorityFailedRetrieved();
        throw new RuntimeException("updateApplicationPriority Failed.");
    }

    public AppQueue getAppQueue(HttpServletRequest hsr, String appId) throws AuthorizationException {
        try {
            long startTime = this.clock.getTime();
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorByAppId(appId);
            AppQueue queue = interceptor.getAppQueue(hsr, appId);
            if (queue != null) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededGetAppQueueRetrieved(stopTime - startTime);
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Get QueueInfo", "RouterWebServices");
                return queue;
            }
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrGetAppQueueFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get QueueInfo", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException(e, "Unable to get queue by appId: %s.", appId);
        }
        catch (YarnException e) {
            this.routerMetrics.incrGetAppQueueFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get QueueInfo", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("getAppQueue error.", e);
        }
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get QueueInfo", "UNKNOWN", "RouterWebServices", "getAppQueue Failed.");
        this.routerMetrics.incrGetAppQueueFailedRetrieved();
        throw new RuntimeException("getAppQueue Failed.");
    }

    public Response updateAppQueue(AppQueue targetQueue, HttpServletRequest hsr, String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        if (targetQueue == null) {
            this.routerMetrics.incrUpdateAppQueueFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Update AppQueue", "UNKNOWN", "RouterWebServices", "Parameter error, the targetQueue is null.");
            throw new IllegalArgumentException("Parameter error, the targetQueue is null.");
        }
        try {
            long startTime = this.clock.getTime();
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorByAppId(appId);
            Response response = interceptor.updateAppQueue(targetQueue, hsr, appId);
            if (response != null) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededUpdateAppQueueRetrieved(stopTime - startTime);
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Update AppQueue", "RouterWebServices");
                return response;
            }
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrUpdateAppQueueFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Update AppQueue", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException(e, "Unable to update app queue by appId: %s.", appId);
        }
        catch (YarnException e) {
            this.routerMetrics.incrUpdateAppQueueFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Update AppQueue", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("updateAppQueue error.", e);
        }
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Update AppQueue", "UNKNOWN", "RouterWebServices", "updateAppQueue Failed.");
        this.routerMetrics.incrUpdateAppQueueFailedRetrieved();
        throw new RuntimeException("updateAppQueue Failed.");
    }

    public Response postDelegationToken(DelegationToken tokenData, HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException, Exception {
        if (tokenData == null || hsr == null) {
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Post DelegationToken", "UNKNOWN", "RouterWebServices", "Parameter error, the tokenData or hsr is null.");
            throw new IllegalArgumentException("Parameter error, the tokenData or hsr is null.");
        }
        try {
            Configuration conf = this.federationFacade.getConf();
            UserGroupInformation callerUGI = RouterWebServiceUtil.getKerberosUserGroupInformation(conf, hsr);
            return this.createDelegationToken(tokenData, callerUGI);
        }
        catch (YarnException e) {
            LOG.error("Create delegation token request failed.", (Throwable)e);
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Post DelegationToken", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getMessage()).build();
        }
    }

    private Response createDelegationToken(DelegationToken dtoken, UserGroupInformation callerUGI) throws IOException, InterruptedException {
        String renewer = dtoken.getRenewer();
        GetDelegationTokenResponse resp = (GetDelegationTokenResponse)callerUGI.doAs(() -> {
            GetDelegationTokenRequest createReq = GetDelegationTokenRequest.newInstance((String)renewer);
            return this.getRouterClientRMService().getDelegationToken(createReq);
        });
        DelegationToken respToken = this.getDelegationToken(renewer, resp);
        RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Post DelegationToken", "RouterWebServices");
        return Response.status((Response.Status)Response.Status.OK).entity((Object)respToken).build();
    }

    private DelegationToken getDelegationToken(String renewer, GetDelegationTokenResponse resp) throws IOException {
        Token<RMDelegationTokenIdentifier> tk = FederationInterceptorREST.getToken(resp);
        String tokenKind = tk.getKind().toString();
        RMDelegationTokenIdentifier tokenIdentifier = (RMDelegationTokenIdentifier)tk.decodeIdentifier();
        String owner = tokenIdentifier.getOwner().toString();
        long maxDate = tokenIdentifier.getMaxDate();
        RouterClientRMService clientRMService = this.getRouterClientRMService();
        RouterDelegationTokenSecretManager tokenSecretManager = clientRMService.getRouterDTSecretManager();
        long currentExpiration = tokenSecretManager.getRenewDate(tokenIdentifier);
        DelegationToken delegationToken = new DelegationToken(tk.encodeToUrlString(), renewer, owner, tokenKind, Long.valueOf(currentExpiration), Long.valueOf(maxDate));
        return delegationToken;
    }

    private static Token<RMDelegationTokenIdentifier> getToken(GetDelegationTokenResponse resp) {
        org.apache.hadoop.yarn.api.records.Token token = resp.getRMDelegationToken();
        byte[] identifier = token.getIdentifier().array();
        byte[] password = token.getPassword().array();
        Text kind = new Text(token.getKind());
        Text service = new Text(token.getService());
        return new Token(identifier, password, kind, service);
    }

    public Response postDelegationTokenExpiration(HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException, Exception {
        if (hsr == null) {
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Post DelegationTokenExpiration", "UNKNOWN", "RouterWebServices", "Parameter error, the hsr is null.");
            throw new IllegalArgumentException("Parameter error, the hsr is null.");
        }
        try {
            Configuration conf = this.federationFacade.getConf();
            UserGroupInformation callerUGI = RouterWebServiceUtil.getKerberosUserGroupInformation(conf, hsr);
            return this.renewDelegationToken(hsr, callerUGI);
        }
        catch (YarnException e) {
            LOG.error("Renew delegation token request failed.", (Throwable)e);
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Post DelegationTokenExpiration", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getMessage()).build();
        }
    }

    private Response renewDelegationToken(HttpServletRequest hsr, UserGroupInformation callerUGI) throws IOException, InterruptedException {
        DelegationToken tokenData = new DelegationToken();
        String encodeToken = RouterWebServiceUtil.extractToken(hsr).encodeToUrlString();
        tokenData.setToken(encodeToken);
        Token<RMDelegationTokenIdentifier> token = RouterWebServiceUtil.extractToken(tokenData.getToken());
        org.apache.hadoop.yarn.api.records.Token dToken = BuilderUtils.newDelegationToken((byte[])token.getIdentifier(), (String)token.getKind().toString(), (byte[])token.getPassword(), (String)token.getService().toString());
        RenewDelegationTokenResponse resp = (RenewDelegationTokenResponse)callerUGI.doAs(() -> {
            RenewDelegationTokenRequest req = RenewDelegationTokenRequest.newInstance((org.apache.hadoop.yarn.api.records.Token)dToken);
            return this.getRouterClientRMService().renewDelegationToken(req);
        });
        long renewTime = resp.getNextExpirationTime();
        DelegationToken respToken = new DelegationToken();
        respToken.setNextExpirationTime(renewTime);
        RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Post DelegationTokenExpiration", "RouterWebServices");
        return Response.status((Response.Status)Response.Status.OK).entity((Object)respToken).build();
    }

    public Response cancelDelegationToken(HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException, Exception {
        try {
            Configuration conf = this.federationFacade.getConf();
            UserGroupInformation callerUGI = RouterWebServiceUtil.getKerberosUserGroupInformation(conf, hsr);
            Token<RMDelegationTokenIdentifier> token = RouterWebServiceUtil.extractToken(hsr);
            org.apache.hadoop.yarn.api.records.Token dToken = BuilderUtils.newDelegationToken((byte[])token.getIdentifier(), (String)token.getKind().toString(), (byte[])token.getPassword(), (String)token.getService().toString());
            callerUGI.doAs(() -> {
                CancelDelegationTokenRequest req = CancelDelegationTokenRequest.newInstance((org.apache.hadoop.yarn.api.records.Token)dToken);
                return this.getRouterClientRMService().cancelDelegationToken(req);
            });
            RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Cancel DelegationToken", "RouterWebServices");
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (YarnException e) {
            LOG.error("Cancel delegation token request failed.", (Throwable)e);
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Cancel DelegationToken", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getMessage()).build();
        }
    }

    public Response createNewReservation(HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        long startTime = this.clock.getTime();
        try {
            Map subClustersActive = this.federationFacade.getSubClusters(true);
            ArrayList blackList = new ArrayList();
            int actualRetryNums = this.federationFacade.getRetryNumbers(this.numSubmitRetries);
            Response response = (Response)((FederationActionRetry)retryCount -> this.invokeCreateNewReservation(subClustersActive, blackList, hsr, retryCount)).runWithRetries(actualRetryNums, this.submitIntervalTime);
            if (response != null && response.getStatus() == 200) {
                long stopTime = this.clock.getTime();
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Get NewReservation", "RouterWebServices");
                this.routerMetrics.succeededGetNewReservationRetrieved(stopTime - startTime);
                return response;
            }
        }
        catch (FederationPolicyException e) {
            this.routerMetrics.incrGetNewReservationFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get NewReservation", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)e.getLocalizedMessage()).build();
        }
        catch (Exception e) {
            this.routerMetrics.incrGetNewReservationFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get NewReservation", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).build();
        }
        String errMsg = "Fail to create a new reservation.";
        LOG.error(errMsg);
        this.routerMetrics.incrGetNewReservationFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get NewReservation", "UNKNOWN", "RouterWebServices", errMsg);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
    }

    private Response invokeCreateNewReservation(Map<SubClusterId, SubClusterInfo> subClustersActive, List<SubClusterId> blackList, HttpServletRequest hsr, int retryCount) throws YarnException {
        SubClusterId subClusterId = FederationStateStoreFacade.getRandomActiveSubCluster(subClustersActive, blackList);
        LOG.info("createNewReservation try #{} on SubCluster {}.", (Object)retryCount, (Object)subClusterId);
        SubClusterInfo subClusterInfo = subClustersActive.get(subClusterId);
        DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorForSubCluster(subClusterId, subClusterInfo.getRMWebServiceAddress());
        try {
            Response response = interceptor.createNewReservation(hsr);
            if (response != null && response.getStatus() == 200) {
                return response;
            }
        }
        catch (Exception e) {
            blackList.add(subClusterId);
            RouterServerUtil.logAndThrowException(e.getMessage(), e);
        }
        String msg = String.format("Unable to create a new ReservationId in SubCluster %s.", subClusterId.getId());
        throw new YarnException(msg);
    }

    public Response submitReservation(ReservationSubmissionRequestInfo resContext, HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        long startTime = this.clock.getTime();
        if (resContext == null || resContext.getReservationId() == null || resContext.getReservationDefinition() == null || resContext.getQueue() == null) {
            this.routerMetrics.incrSubmitReservationFailedRetrieved();
            String errMsg = "Missing submitReservation resContext or reservationId or reservation definition or queue.";
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Submit Reservation", "UNKNOWN", "RouterWebServices", errMsg);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
        String resId = resContext.getReservationId();
        try {
            RouterServerUtil.validateReservationId(resId);
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrSubmitReservationFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Submit Reservation", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            throw e;
        }
        ArrayList blackList = new ArrayList();
        try {
            int activeSubClustersCount = this.federationFacade.getActiveSubClustersCount();
            int actualRetryNums = Math.min(activeSubClustersCount, this.numSubmitRetries);
            Response response = (Response)((FederationActionRetry)retryCount -> this.invokeSubmitReservation(resContext, blackList, hsr, retryCount)).runWithRetries(actualRetryNums, this.submitIntervalTime);
            if (response != null) {
                long stopTime = this.clock.getTime();
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Submit Reservation", "RouterWebServices");
                this.routerMetrics.succeededSubmitReservationRetrieved(stopTime - startTime);
                return response;
            }
        }
        catch (Exception e) {
            this.routerMetrics.incrSubmitReservationFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Submit Reservation", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)e.getLocalizedMessage()).build();
        }
        this.routerMetrics.incrSubmitReservationFailedRetrieved();
        String msg = String.format("Reservation %s failed to be submitted.", resId);
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Submit Reservation", "UNKNOWN", "RouterWebServices", msg);
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)msg).build();
    }

    private Response invokeSubmitReservation(ReservationSubmissionRequestInfo requestContext, List<SubClusterId> blackList, HttpServletRequest hsr, int retryCount) throws YarnException, IOException, InterruptedException {
        String resId = requestContext.getReservationId();
        ReservationId reservationId = ReservationId.parseReservationId((String)resId);
        ReservationDefinitionInfo definitionInfo = requestContext.getReservationDefinition();
        ReservationDefinition definition = RouterServerUtil.convertReservationDefinition(definitionInfo);
        ReservationSubmissionRequest request = ReservationSubmissionRequest.newInstance((ReservationDefinition)definition, (String)requestContext.getQueue(), (ReservationId)reservationId);
        SubClusterId subClusterId = null;
        try {
            subClusterId = this.policyFacade.getReservationHomeSubCluster(request);
            LOG.info("submitReservation ReservationId {} try #{} on SubCluster {}.", new Object[]{reservationId, retryCount, subClusterId});
            this.federationFacade.addOrUpdateReservationHomeSubCluster(reservationId, subClusterId, retryCount);
            SubClusterInfo subClusterInfo = this.federationFacade.getSubCluster(subClusterId);
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorForSubCluster(subClusterInfo.getSubClusterId(), subClusterInfo.getRMWebServiceAddress());
            HttpServletRequestWrapper hsrCopy = this.clone(hsr);
            Response response = interceptor.submitReservation(requestContext, (HttpServletRequest)hsrCopy);
            if (response != null && response.getStatus() == 202) {
                LOG.info("Reservation {} submitted on subCluster {}.", (Object)reservationId, (Object)subClusterId);
                return response;
            }
            String msg = String.format("application %s failed to be submitted.", resId);
            throw new YarnException(msg);
        }
        catch (Exception e) {
            LOG.warn("Unable to submit the reservation {} to SubCluster {}.", new Object[]{resId, subClusterId, e});
            if (subClusterId != null) {
                blackList.add(subClusterId);
            }
            throw e;
        }
    }

    public Response updateReservation(ReservationUpdateRequestInfo resContext, HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        if (resContext == null || resContext.getReservationId() == null || resContext.getReservationDefinition() == null) {
            this.routerMetrics.incrUpdateReservationFailedRetrieved();
            String errMsg = "Missing updateReservation resContext or reservationId or reservation definition.";
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Update Reservation", "UNKNOWN", "RouterWebServices", errMsg);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
        String reservationId = resContext.getReservationId();
        try {
            RouterServerUtil.validateReservationId(reservationId);
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrUpdateReservationFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Update Reservation", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            throw e;
        }
        try {
            SubClusterInfo subClusterInfo = this.getHomeSubClusterInfoByReservationId(reservationId);
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorForSubCluster(subClusterInfo.getSubClusterId(), subClusterInfo.getRMWebServiceAddress());
            HttpServletRequestWrapper hsrCopy = this.clone(hsr);
            Response response = interceptor.updateReservation(resContext, (HttpServletRequest)hsrCopy);
            if (response != null) {
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Update Reservation", "RouterWebServices");
                return response;
            }
        }
        catch (Exception e) {
            this.routerMetrics.incrUpdateReservationFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Update Reservation", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("updateReservation Failed.", e);
        }
        this.routerMetrics.incrUpdateReservationFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Update Reservation", "UNKNOWN", "RouterWebServices", "updateReservation Failed, reservationId = " + reservationId);
        throw new YarnRuntimeException("updateReservation Failed, reservationId = " + reservationId);
    }

    public Response deleteReservation(ReservationDeleteRequestInfo resContext, HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        if (resContext == null || resContext.getReservationId() == null) {
            this.routerMetrics.incrDeleteReservationFailedRetrieved();
            String errMsg = "Missing deleteReservation request or reservationId.";
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Delete Reservation", "UNKNOWN", "RouterWebServices", errMsg);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
        String reservationId = resContext.getReservationId();
        try {
            RouterServerUtil.validateReservationId(reservationId);
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrDeleteReservationFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Delete Reservation", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            throw e;
        }
        try {
            SubClusterInfo subClusterInfo = this.getHomeSubClusterInfoByReservationId(reservationId);
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorForSubCluster(subClusterInfo.getSubClusterId(), subClusterInfo.getRMWebServiceAddress());
            HttpServletRequestWrapper hsrCopy = this.clone(hsr);
            Response response = interceptor.deleteReservation(resContext, (HttpServletRequest)hsrCopy);
            if (response != null) {
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Delete Reservation", "RouterWebServices");
                return response;
            }
        }
        catch (Exception e) {
            this.routerMetrics.incrDeleteReservationFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Delete Reservation", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("deleteReservation Failed.", e);
        }
        this.routerMetrics.incrDeleteReservationFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Delete Reservation", "UNKNOWN", "RouterWebServices", "deleteReservation Failed, reservationId = " + reservationId);
        throw new YarnRuntimeException("deleteReservation Failed, reservationId = " + reservationId);
    }

    public Response listReservation(String queue, String reservationId, long startTime, long endTime, boolean includeResourceAllocations, HttpServletRequest hsr) throws Exception {
        if (queue == null || queue.isEmpty()) {
            this.routerMetrics.incrListReservationFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "List Reservations", "UNKNOWN", "RouterWebServices", "Parameter error, the queue is empty or null.");
            throw new IllegalArgumentException("Parameter error, the queue is empty or null.");
        }
        if (reservationId == null || reservationId.isEmpty()) {
            this.routerMetrics.incrListReservationFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "List Reservations", "UNKNOWN", "RouterWebServices", "Parameter error, the reservationId is empty or null.");
            throw new IllegalArgumentException("Parameter error, the reservationId is empty or null.");
        }
        try {
            RouterServerUtil.validateReservationId(reservationId);
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrListReservationFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "List Reservations", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            throw e;
        }
        try {
            long startTime1 = this.clock.getTime();
            SubClusterInfo subClusterInfo = this.getHomeSubClusterInfoByReservationId(reservationId);
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorForSubCluster(subClusterInfo.getSubClusterId(), subClusterInfo.getRMWebServiceAddress());
            HttpServletRequestWrapper hsrCopy = this.clone(hsr);
            Response response = interceptor.listReservation(queue, reservationId, startTime, endTime, includeResourceAllocations, (HttpServletRequest)hsrCopy);
            if (response != null) {
                long stopTime = this.clock.getTime();
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "List Reservations", "RouterWebServices");
                this.routerMetrics.succeededListReservationRetrieved(stopTime - startTime1);
                return response;
            }
        }
        catch (YarnException e) {
            this.routerMetrics.incrListReservationFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "List Reservations", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("listReservation error.", e);
        }
        this.routerMetrics.incrListReservationFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "List Reservations", "UNKNOWN", "RouterWebServices", "listReservation Failed.");
        throw new YarnException("listReservation Failed.");
    }

    public AppTimeoutInfo getAppTimeout(HttpServletRequest hsr, String appId, String type) throws AuthorizationException {
        if (type == null || type.isEmpty()) {
            this.routerMetrics.incrGetAppTimeoutFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get App Timeout", "UNKNOWN", "RouterWebServices", "Parameter error, the type is empty or null.");
            throw new IllegalArgumentException("Parameter error, the type is empty or null.");
        }
        try {
            long startTime = this.clock.getTime();
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorByAppId(appId);
            AppTimeoutInfo appTimeoutInfo = interceptor.getAppTimeout(hsr, appId, type);
            if (appTimeoutInfo != null) {
                long stopTime = this.clock.getTime();
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Get App Timeout", "RouterWebServices");
                this.routerMetrics.succeededGetAppTimeoutRetrieved(stopTime - startTime);
                return appTimeoutInfo;
            }
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrGetAppTimeoutFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get App Timeout", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException(e, "Unable to get the getAppTimeout appId: %s.", appId);
        }
        catch (YarnException e) {
            this.routerMetrics.incrGetAppTimeoutFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get App Timeout", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("getAppTimeout error.", e);
        }
        this.routerMetrics.incrGetAppTimeoutFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get App Timeout", "UNKNOWN", "RouterWebServices", "getAppTimeout Failed.");
        throw new RuntimeException("getAppTimeout Failed.");
    }

    public AppTimeoutsInfo getAppTimeouts(HttpServletRequest hsr, String appId) throws AuthorizationException {
        try {
            long startTime = this.clock.getTime();
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorByAppId(appId);
            AppTimeoutsInfo appTimeoutsInfo = interceptor.getAppTimeouts(hsr, appId);
            if (appTimeoutsInfo != null) {
                long stopTime = this.clock.getTime();
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Get App Timeouts", "RouterWebServices");
                this.routerMetrics.succeededGetAppTimeoutsRetrieved(stopTime - startTime);
                return appTimeoutsInfo;
            }
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrGetAppTimeoutsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get App Timeouts", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException(e, "Unable to get the getAppTimeouts appId: %s.", appId);
        }
        catch (YarnException e) {
            this.routerMetrics.incrGetAppTimeoutsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get App Timeouts", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("getAppTimeouts error.", e);
        }
        this.routerMetrics.incrGetAppTimeoutsFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get App Timeouts", "UNKNOWN", "RouterWebServices", "getAppTimeouts Failed.");
        throw new RuntimeException("getAppTimeouts Failed.");
    }

    public Response updateApplicationTimeout(AppTimeoutInfo appTimeout, HttpServletRequest hsr, String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        if (appTimeout == null) {
            this.routerMetrics.incrUpdateApplicationTimeoutsRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Update ApplicationTimeouts", "UNKNOWN", "RouterWebServices", "Parameter error, the appTimeout is null.");
            throw new IllegalArgumentException("Parameter error, the appTimeout is null.");
        }
        try {
            long startTime = Time.now();
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorByAppId(appId);
            Response response = interceptor.updateApplicationTimeout(appTimeout, hsr, appId);
            if (response != null) {
                long stopTime = this.clock.getTime();
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Update ApplicationTimeouts", "RouterWebServices");
                this.routerMetrics.succeededUpdateAppTimeoutsRetrieved(stopTime - startTime);
                return response;
            }
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrUpdateApplicationTimeoutsRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Update ApplicationTimeouts", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException(e, "Unable to get the updateApplicationTimeout appId: %s.", appId);
        }
        catch (YarnException e) {
            this.routerMetrics.incrUpdateApplicationTimeoutsRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Update ApplicationTimeouts", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("updateApplicationTimeout error.", e);
        }
        this.routerMetrics.incrUpdateApplicationTimeoutsRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Update ApplicationTimeouts", "UNKNOWN", "RouterWebServices", "updateApplicationTimeout Failed.");
        throw new RuntimeException("updateApplicationTimeout Failed.");
    }

    public AppAttemptsInfo getAppAttempts(HttpServletRequest hsr, String appId) {
        try {
            long startTime = Time.now();
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorByAppId(appId);
            AppAttemptsInfo appAttemptsInfo = interceptor.getAppAttempts(hsr, appId);
            if (appAttemptsInfo != null) {
                long stopTime = Time.now();
                this.routerMetrics.succeededAppAttemptsRetrieved(stopTime - startTime);
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Get ApplicationAttempts", "RouterWebServices");
                return appAttemptsInfo;
            }
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrAppAttemptsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get ApplicationAttempts", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException(e, "Unable to get the AppAttempt appId: %s.", appId);
        }
        catch (YarnException e) {
            this.routerMetrics.incrAppAttemptsFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get ApplicationAttempts", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("getAppAttempts error.", e);
        }
        this.routerMetrics.incrAppAttemptsFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get ApplicationAttempts", "UNKNOWN", "RouterWebServices", "getAppAttempts Failed.");
        throw new RuntimeException("getAppAttempts Failed.");
    }

    public RMQueueAclInfo checkUserAccessToQueue(String queue, String username, String queueAclType, HttpServletRequest hsr) throws AuthorizationException {
        if (queue == null || queue.isEmpty()) {
            this.routerMetrics.incrCheckUserAccessToQueueFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Check User AccessToQueue", "UNKNOWN", "RouterWebServices", "Parameter error, the queue is empty or null.");
            throw new IllegalArgumentException("Parameter error, the queue is empty or null.");
        }
        if (username == null || username.isEmpty()) {
            this.routerMetrics.incrCheckUserAccessToQueueFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Check User AccessToQueue", "UNKNOWN", "RouterWebServices", "Parameter error, the username is empty or null.");
            throw new IllegalArgumentException("Parameter error, the username is empty or null.");
        }
        if (queueAclType == null || queueAclType.isEmpty()) {
            this.routerMetrics.incrCheckUserAccessToQueueFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Check User AccessToQueue", "UNKNOWN", "RouterWebServices", "Parameter error, the queueAclType is empty or null.");
            throw new IllegalArgumentException("Parameter error, the queueAclType is empty or null.");
        }
        try {
            long startTime = Time.now();
            Collection subClustersActive = this.federationFacade.getActiveSubClusters();
            HttpServletRequestWrapper hsrCopy = this.clone(hsr);
            Class[] argsClasses = new Class[]{String.class, String.class, String.class, HttpServletRequest.class};
            Object[] args = new Object[]{queue, username, queueAclType, hsrCopy};
            ClientMethod remoteMethod = new ClientMethod("checkUserAccessToQueue", argsClasses, args);
            Map<SubClusterInfo, RMQueueAclInfo> rmQueueAclInfoMap = this.invokeConcurrent(subClustersActive, remoteMethod, RMQueueAclInfo.class);
            FederationRMQueueAclInfo aclInfo = new FederationRMQueueAclInfo();
            rmQueueAclInfoMap.forEach((subClusterInfo, rMQueueAclInfo) -> {
                SubClusterId subClusterId = subClusterInfo.getSubClusterId();
                rMQueueAclInfo.setSubClusterId(subClusterId.getId());
                aclInfo.getList().add((RMQueueAclInfo)rMQueueAclInfo);
            });
            long stopTime = Time.now();
            RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Check User AccessToQueue", "RouterWebServices");
            this.routerMetrics.succeededCheckUserAccessToQueueRetrieved(stopTime - startTime);
            return aclInfo;
        }
        catch (NotFoundException e) {
            this.routerMetrics.incrCheckUserAccessToQueueFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Check User AccessToQueue", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("Get all active sub cluster(s) error.", e);
        }
        catch (IOException | YarnException e) {
            this.routerMetrics.incrCheckUserAccessToQueueFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Check User AccessToQueue", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("checkUserAccessToQueue error.", e);
        }
        this.routerMetrics.incrCheckUserAccessToQueueFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Check User AccessToQueue", "UNKNOWN", "RouterWebServices", "checkUserAccessToQueue error.");
        throw new RuntimeException("checkUserAccessToQueue error.");
    }

    @Override
    public AppAttemptInfo getAppAttempt(HttpServletRequest req, HttpServletResponse res, String appId, String appAttemptId) {
        try {
            RouterServerUtil.validateApplicationAttemptId(appAttemptId);
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrAppAttemptReportFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get AppAttempt", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            throw e;
        }
        try {
            long startTime = Time.now();
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorByAppId(appId);
            AppAttemptInfo appAttemptInfo = interceptor.getAppAttempt(req, res, appId, appAttemptId);
            if (appAttemptInfo != null) {
                long stopTime = Time.now();
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Get AppAttempt", "RouterWebServices");
                this.routerMetrics.succeededAppAttemptReportRetrieved(stopTime - startTime);
                return appAttemptInfo;
            }
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrAppAttemptReportFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get AppAttempt", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException(e, "Unable to getAppAttempt by appId: %s, appAttemptId: %s.", appId, appAttemptId);
        }
        catch (YarnException e) {
            this.routerMetrics.incrAppAttemptReportFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get AppAttempt", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException(e, "getAppAttempt error, appId: %s, appAttemptId: %s.", appId, appAttemptId);
        }
        this.routerMetrics.incrAppAttemptReportFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get AppAttempt", "UNKNOWN", "RouterWebServices", "getAppAttempt failed.");
        throw RouterServerUtil.logAndReturnRunTimeException("getAppAttempt failed, appId: %s, appAttemptId: %s.", appId, appAttemptId);
    }

    @Override
    public ContainersInfo getContainers(HttpServletRequest req, HttpServletResponse res, String appId, String appAttemptId) {
        try {
            RouterServerUtil.validateApplicationId(appId);
            RouterServerUtil.validateApplicationAttemptId(appAttemptId);
        }
        catch (IllegalArgumentException e) {
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get Containers", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            this.routerMetrics.incrGetContainersFailedRetrieved();
            throw e;
        }
        try {
            long startTime = this.clock.getTime();
            ContainersInfo containersInfo = new ContainersInfo();
            Collection subClustersActive = this.federationFacade.getActiveSubClusters();
            Class[] argsClasses = new Class[]{HttpServletRequest.class, HttpServletResponse.class, String.class, String.class};
            Object[] args = new Object[]{req, res, appId, appAttemptId};
            ClientMethod remoteMethod = new ClientMethod("getContainers", argsClasses, args);
            Map<SubClusterInfo, ContainersInfo> containersInfoMap = this.invokeConcurrent(subClustersActive, remoteMethod, ContainersInfo.class);
            if (containersInfoMap != null && !containersInfoMap.isEmpty()) {
                containersInfoMap.values().forEach(containers -> containersInfo.addAll((Collection)containers.getContainers()));
            }
            if (containersInfo != null) {
                long stopTime = this.clock.getTime();
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Get Containers", "RouterWebServices");
                this.routerMetrics.succeededGetContainersRetrieved(stopTime - startTime);
                return containersInfo;
            }
        }
        catch (NotFoundException e) {
            this.routerMetrics.incrGetContainersFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get Containers", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException(e, "getContainers error, appId = %s,  appAttemptId = %s, Probably getActiveSubclusters error.", appId, appAttemptId);
        }
        catch (IOException | YarnException e) {
            this.routerMetrics.incrGetContainersFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get Containers", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException(e, "getContainers error, appId = %s,  appAttemptId = %s.", appId, appAttemptId);
        }
        this.routerMetrics.incrGetContainersFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get Containers", "UNKNOWN", "RouterWebServices", "getContainers failed.");
        throw RouterServerUtil.logAndReturnRunTimeException("getContainers failed, appId: %s, appAttemptId: %s.", appId, appAttemptId);
    }

    @Override
    public ContainerInfo getContainer(HttpServletRequest req, HttpServletResponse res, String appId, String appAttemptId, String containerId) {
        try {
            RouterServerUtil.validateApplicationAttemptId(appAttemptId);
            RouterServerUtil.validateContainerId(containerId);
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrGetContainerReportFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get Container", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            throw e;
        }
        try {
            long startTime = Time.now();
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorByAppId(appId);
            ContainerInfo containerInfo = interceptor.getContainer(req, res, appId, appAttemptId, containerId);
            if (containerInfo != null) {
                long stopTime = Time.now();
                this.routerMetrics.succeededGetContainerReportRetrieved(stopTime - startTime);
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Get Container", "RouterWebServices");
                return containerInfo;
            }
        }
        catch (IllegalArgumentException e) {
            String msg = String.format("Unable to get the AppAttempt appId: %s, appAttemptId: %s, containerId: %s.", appId, appAttemptId, containerId);
            this.routerMetrics.incrGetContainerReportFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get Container", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException(msg, e);
        }
        catch (YarnException e) {
            this.routerMetrics.incrGetContainerReportFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get Container", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("getContainer Failed.", e);
        }
        this.routerMetrics.incrGetContainerReportFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get Container", "UNKNOWN", "RouterWebServices", "getContainer Failed.");
        throw new RuntimeException("getContainer Failed.");
    }

    public Response updateSchedulerConfiguration(SchedConfUpdateInfo mutationInfo, HttpServletRequest hsr) throws AuthorizationException, InterruptedException {
        if (mutationInfo == null) {
            this.routerMetrics.incrUpdateSchedulerConfigurationFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Update SchedulerConfiguration", "UNKNOWN", "RouterWebServices", "Parameter error, the schedConfUpdateInfo is empty or null.");
            throw new IllegalArgumentException("Parameter error, the schedConfUpdateInfo is empty or null.");
        }
        String pSubClusterId = mutationInfo.getSubClusterId();
        if (StringUtils.isBlank((CharSequence)pSubClusterId)) {
            this.routerMetrics.incrUpdateSchedulerConfigurationFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Update SchedulerConfiguration", "UNKNOWN", "RouterWebServices", "Parameter error, the subClusterId is empty or null.");
            throw new IllegalArgumentException("Parameter error, the subClusterId is empty or null.");
        }
        try {
            long startTime = this.clock.getTime();
            SubClusterInfo subClusterInfo = this.getActiveSubCluster(pSubClusterId);
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorForSubCluster(subClusterInfo.getSubClusterId(), subClusterInfo.getRMWebServiceAddress());
            Response response = interceptor.updateSchedulerConfiguration(mutationInfo, hsr);
            if (response != null) {
                long endTime = this.clock.getTime();
                this.routerMetrics.succeededUpdateSchedulerConfigurationRetrieved(endTime - startTime);
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Update SchedulerConfiguration", "RouterWebServices");
                return Response.status((int)response.getStatus()).entity(response.getEntity()).build();
            }
        }
        catch (NotFoundException e) {
            this.routerMetrics.incrUpdateSchedulerConfigurationFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Update SchedulerConfiguration", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException(e, "Get subCluster error. subClusterId = %s", pSubClusterId);
        }
        catch (Exception e) {
            this.routerMetrics.incrUpdateSchedulerConfigurationFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Update SchedulerConfiguration", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException(e, "UpdateSchedulerConfiguration error. subClusterId = %s", pSubClusterId);
        }
        this.routerMetrics.incrUpdateSchedulerConfigurationFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Update SchedulerConfiguration", "UNKNOWN", "RouterWebServices", "UpdateSchedulerConfiguration Failed.");
        throw new RuntimeException("UpdateSchedulerConfiguration error. subClusterId = " + pSubClusterId);
    }

    public Response getSchedulerConfiguration(HttpServletRequest hsr) throws AuthorizationException {
        try {
            long startTime = this.clock.getTime();
            FederationConfInfo federationConfInfo = new FederationConfInfo();
            Collection subClustersActive = this.federationFacade.getActiveSubClusters();
            HttpServletRequestWrapper hsrCopy = this.clone(hsr);
            Class[] argsClasses = new Class[]{HttpServletRequest.class};
            Object[] args = new Object[]{hsrCopy};
            ClientMethod remoteMethod = new ClientMethod("getSchedulerConfiguration", argsClasses, args);
            Map<SubClusterInfo, Response> responseMap = this.invokeConcurrent(subClustersActive, remoteMethod, Response.class);
            responseMap.forEach((subClusterInfo, response) -> {
                SubClusterId subClusterId = subClusterInfo.getSubClusterId();
                if (response == null) {
                    String errorMsg = subClusterId + " Can't getSchedulerConfiguration.";
                    federationConfInfo.getErrorMsgs().add(errorMsg);
                } else if (response.getStatus() == Response.Status.BAD_REQUEST.getStatusCode()) {
                    String errorMsg = String.valueOf(response.getEntity());
                    federationConfInfo.getErrorMsgs().add(errorMsg);
                } else if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                    ConfInfo fedConfInfo = (ConfInfo)response.getEntity();
                    fedConfInfo.setSubClusterId(subClusterId.getId());
                    federationConfInfo.getList().add(fedConfInfo);
                }
            });
            long endTime = this.clock.getTime();
            this.routerMetrics.succeededGetSchedulerConfigurationRetrieved(endTime - startTime);
            RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Get SchedulerConfiguration", "RouterWebServices");
            return Response.status((Response.Status)Response.Status.OK).entity((Object)federationConfInfo).build();
        }
        catch (NotFoundException e) {
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get SchedulerConfiguration", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            this.routerMetrics.incrGetSchedulerConfigurationFailedRetrieved();
            RouterServerUtil.logAndThrowRunTimeException("get all active sub cluster(s) error.", e);
        }
        catch (Exception e) {
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get SchedulerConfiguration", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            this.routerMetrics.incrGetSchedulerConfigurationFailedRetrieved();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"getSchedulerConfiguration error.").build();
        }
        this.routerMetrics.incrGetSchedulerConfigurationFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Get SchedulerConfiguration", "UNKNOWN", "RouterWebServices", "getSchedulerConfiguration Failed.");
        throw new RuntimeException("getSchedulerConfiguration Failed.");
    }

    @Override
    public void setNextInterceptor(RESTRequestInterceptor next) {
        throw new YarnRuntimeException("setNextInterceptor is being called on FederationInterceptorREST, which should be the last one in the chain. Check if the interceptor pipeline configuration is correct");
    }

    public Response signalToContainer(String containerId, String command, HttpServletRequest req) {
        try {
            RouterServerUtil.validateContainerId(containerId);
        }
        catch (IllegalArgumentException e) {
            this.routerMetrics.incrSignalToContainerFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Signal ToContainer", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            throw e;
        }
        if (command == null || command.isEmpty()) {
            this.routerMetrics.incrSignalToContainerFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Signal ToContainer", "UNKNOWN", "RouterWebServices", "Parameter error, the command is empty or null.");
            throw new IllegalArgumentException("Parameter error, the command is empty or null.");
        }
        try {
            long startTime = Time.now();
            ContainerId containerIdObj = ContainerId.fromString((String)containerId);
            ApplicationId applicationId = containerIdObj.getApplicationAttemptId().getApplicationId();
            SubClusterInfo subClusterInfo = this.getHomeSubClusterInfoByAppId(applicationId.toString());
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorForSubCluster(subClusterInfo.getSubClusterId(), subClusterInfo.getRMWebServiceAddress());
            Response response = interceptor.signalToContainer(containerId, command, req);
            if (response != null) {
                long stopTime = Time.now();
                RouterAuditLogger.logSuccess(this.getUser().getShortUserName(), "Signal ToContainer", "RouterWebServices");
                this.routerMetrics.succeededSignalToContainerRetrieved(stopTime - startTime);
                return response;
            }
        }
        catch (YarnException e) {
            this.routerMetrics.incrSignalToContainerFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Signal ToContainer", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("signalToContainer Failed.", e);
        }
        catch (AuthorizationException e) {
            this.routerMetrics.incrSignalToContainerFailedRetrieved();
            RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Signal ToContainer", "UNKNOWN", "RouterWebServices", e.getLocalizedMessage());
            RouterServerUtil.logAndThrowRunTimeException("signalToContainer Author Failed.", e);
        }
        this.routerMetrics.incrSignalToContainerFailedRetrieved();
        RouterAuditLogger.logFailure(this.getUser().getShortUserName(), "Signal ToContainer", "UNKNOWN", "RouterWebServices", "signalToContainer Failed.");
        throw new RuntimeException("signalToContainer Failed.");
    }

    @Override
    public void shutdown() {
        if (this.threadpool != null) {
            this.threadpool.shutdown();
        }
    }

    private <R> Map<SubClusterInfo, R> invokeConcurrent(Collection<SubClusterInfo> clusterIds, ClientMethod request, Class<R> clazz) throws YarnException {
        HashMap results = new HashMap();
        ExecutorCompletionService<SubClusterResult> compSvc = new ExecutorCompletionService<SubClusterResult>(this.threadpool);
        for (SubClusterInfo info : clusterIds) {
            compSvc.submit(() -> {
                DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorForSubCluster(info.getSubClusterId(), info.getRMWebServiceAddress());
                try {
                    Method method = DefaultRequestInterceptorREST.class.getMethod(request.getMethodName(), request.getTypes());
                    Object retObj = method.invoke((Object)interceptor, request.getParams());
                    Object ret = clazz.cast(retObj);
                    return new SubClusterResult(info, ret, null);
                }
                catch (Exception e) {
                    LOG.error("SubCluster {} failed to call {} method.", new Object[]{info.getSubClusterId(), request.getMethodName(), e});
                    return new SubClusterResult<Object>(info, null, e);
                }
            });
        }
        for (int i = 0; i < clusterIds.size(); ++i) {
            SubClusterInfo subClusterInfo = null;
            try {
                Exception exception;
                Future future = compSvc.take();
                SubClusterResult result = (SubClusterResult)future.get();
                subClusterInfo = result.getSubClusterInfo();
                Object response = result.getResponse();
                if (response != null) {
                    results.put(subClusterInfo, response);
                }
                if ((exception = result.getException()) == null) continue;
                throw exception;
            }
            catch (Throwable e) {
                String subClusterId = subClusterInfo != null ? subClusterInfo.getSubClusterId().getId() : "UNKNOWN";
                LOG.error("SubCluster {} failed to {} report.", new Object[]{subClusterId, request.getMethodName(), e});
                if (this.allowPartialResult) continue;
                throw new YarnException("SubCluster " + subClusterId + " failed to " + request.getMethodName() + " report.", e);
            }
        }
        return results;
    }

    private SubClusterInfo getHomeSubClusterInfoByAppId(String appId) throws YarnException {
        if (StringUtils.isBlank((CharSequence)appId)) {
            throw new IllegalArgumentException("applicationId can't null or empty.");
        }
        try {
            ApplicationId applicationId = ApplicationId.fromString((String)appId);
            SubClusterId subClusterId = this.federationFacade.getApplicationHomeSubCluster(applicationId);
            if (subClusterId == null) {
                RouterServerUtil.logAndThrowException(null, "Can't get HomeSubCluster by applicationId %s", applicationId);
            }
            return this.federationFacade.getSubCluster(subClusterId);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e);
        }
        catch (YarnException e) {
            RouterServerUtil.logAndThrowException(e, "Get HomeSubClusterInfo by applicationId %s failed.", appId);
            throw new YarnException("Unable to get subCluster by applicationId = " + appId);
        }
    }

    private SubClusterInfo getHomeSubClusterInfoByReservationId(String resId) throws YarnException {
        try {
            ReservationId reservationId = ReservationId.parseReservationId((String)resId);
            SubClusterId subClusterId = this.federationFacade.getReservationHomeSubCluster(reservationId);
            if (subClusterId == null) {
                RouterServerUtil.logAndThrowException(null, "Can't get HomeSubCluster by reservationId %s", resId);
            }
            return this.federationFacade.getSubCluster(subClusterId);
        }
        catch (IOException | YarnException e) {
            RouterServerUtil.logAndThrowException(e, "Get HomeSubClusterInfo by reservationId %s failed.", resId);
            throw new YarnException("Unable to get subCluster by reservationId = " + resId);
        }
    }

    @VisibleForTesting
    public LRUCacheHashMap<RouterAppInfoCacheKey, AppsInfo> getAppInfosCaches() {
        return this.appInfosCaches;
    }

    @VisibleForTesting
    public Map<SubClusterId, DefaultRequestInterceptorREST> getInterceptors() {
        return this.interceptors;
    }

    public void setAllowPartialResult(boolean allowPartialResult) {
        this.allowPartialResult = allowPartialResult;
    }

    @VisibleForTesting
    public Map<SubClusterInfo, NodesInfo> invokeConcurrentGetNodeLabel() throws IOException, YarnException {
        Collection subClustersActive = this.federationFacade.getActiveSubClusters();
        Class[] argsClasses = new Class[]{String.class};
        Object[] args = new Object[]{null};
        ClientMethod remoteMethod = new ClientMethod("getNodes", argsClasses, args);
        return this.invokeConcurrent(subClustersActive, remoteMethod, NodesInfo.class);
    }

    private /* synthetic */ void lambda$replaceLabelsOnNodes$17(HttpServletRequest hsrCopy, StringBuilder builder, SubClusterInfo subClusterInfo, NodeToLabelsEntryList nodeToLabelsEntryList) {
        SubClusterId subClusterId = subClusterInfo.getSubClusterId();
        try {
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorForSubCluster(subClusterInfo);
            interceptor.replaceLabelsOnNodes(nodeToLabelsEntryList, hsrCopy);
            builder.append("subCluster-").append(subClusterId.getId()).append(":Success,");
        }
        catch (Exception e) {
            LOG.error("replaceLabelsOnNodes Failed. subClusterId = {}.", (Object)subClusterId, (Object)e);
            builder.append("subCluster-").append(subClusterId.getId()).append(":Failed,");
        }
    }

    private /* synthetic */ AppsInfo lambda$getApps$2(HttpServletRequest hsrCopy, String stateQuery, Set statesQuery, String finalStatusQuery, String userQuery, String queueQuery, String count, String startedBegin, String startedEnd, String finishBegin, String finishEnd, Set applicationTypes, Set applicationTags, String name, Set unselectedFields, SubClusterInfo subCluster) {
        try {
            DefaultRequestInterceptorREST interceptor = this.getOrCreateInterceptorForSubCluster(subCluster);
            AppsInfo rmApps = interceptor.getApps(hsrCopy, stateQuery, statesQuery, finalStatusQuery, userQuery, queueQuery, count, startedBegin, startedEnd, finishBegin, finishEnd, applicationTypes, applicationTags, name, unselectedFields);
            if (rmApps != null) {
                return rmApps;
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to get application report.", (Throwable)e);
        }
        this.routerMetrics.incrMultipleAppsFailedRetrieved();
        LOG.error("Subcluster {} failed to return appReport.", (Object)subCluster.getSubClusterId());
        return null;
    }
}

