/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.function.Try;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.DiscoverySelectorIdentifier;
import org.junit.platform.engine.discovery.DiscoverySelectorIdentifierParser;
import org.junit.platform.engine.discovery.DiscoverySelectors;

@API(status=API.Status.STABLE, since="1.0")
public class MethodSelector
implements DiscoverySelector {
    private final ClassLoader classLoader;
    private final String className;
    private final String methodName;
    private final String parameterTypeNames;
    private volatile Class<?> javaClass;
    private volatile Method javaMethod;
    private volatile Class<?>[] parameterTypes;

    MethodSelector(ClassLoader classLoader, String className, String methodName, String parameterTypeNames) {
        this.classLoader = classLoader;
        this.className = className;
        this.methodName = methodName;
        this.parameterTypeNames = parameterTypeNames;
    }

    MethodSelector(Class<?> javaClass, String methodName, String parameterTypeNames) {
        this(javaClass.getClassLoader(), javaClass.getName(), methodName, parameterTypeNames);
        this.javaClass = javaClass;
    }

    MethodSelector(ClassLoader classLoader, String className, String methodName, Class<?> ... parameterTypes) {
        this(classLoader, className, methodName, ClassUtils.nullSafeToString(Class::getTypeName, (Class[])parameterTypes));
        this.parameterTypes = (Class[])parameterTypes.clone();
    }

    MethodSelector(Class<?> javaClass, String methodName, Class<?> ... parameterTypes) {
        this(javaClass.getClassLoader(), javaClass.getName(), methodName, ClassUtils.nullSafeToString(Class::getTypeName, (Class[])parameterTypes));
        this.javaClass = javaClass;
        this.parameterTypes = (Class[])parameterTypes.clone();
    }

    MethodSelector(Class<?> javaClass, Method method) {
        this(javaClass, method, method.getParameterTypes());
    }

    private MethodSelector(Class<?> javaClass, Method method, Class<?> ... parameterTypes) {
        this(javaClass.getClassLoader(), javaClass.getName(), method.getName(), ClassUtils.nullSafeToString(Class::getTypeName, (Class[])parameterTypes));
        this.javaClass = javaClass;
        this.javaMethod = method;
        this.parameterTypes = parameterTypes;
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.10")
    public String getMethodParameterTypes() {
        return this.getParameterTypeNames();
    }

    @API(status=API.Status.STABLE, since="1.10")
    public String getParameterTypeNames() {
        return this.parameterTypeNames;
    }

    public Class<?> getJavaClass() {
        this.lazyLoadJavaClass();
        return this.javaClass;
    }

    public Method getJavaMethod() {
        this.lazyLoadJavaMethod();
        return this.javaMethod;
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public Class<?>[] getParameterTypes() {
        this.lazyLoadParameterTypes();
        return (Class[])this.parameterTypes.clone();
    }

    private void lazyLoadJavaClass() {
        if (this.javaClass == null) {
            Try tryToLoadClass = this.classLoader == null ? ReflectionSupport.tryToLoadClass((String)this.className) : ReflectionSupport.tryToLoadClass((String)this.className, (ClassLoader)this.classLoader);
            this.javaClass = (Class)tryToLoadClass.getOrThrow(cause -> new PreconditionViolationException("Could not load class with name: " + this.className, (Throwable)cause));
        }
    }

    private void lazyLoadJavaMethod() {
        if (this.javaMethod == null) {
            this.lazyLoadJavaClass();
            this.lazyLoadParameterTypes();
            this.javaMethod = this.parameterTypes.length > 0 ? (Method)ReflectionSupport.findMethod(this.javaClass, (String)this.methodName, (Class[])this.parameterTypes).orElseThrow(() -> new PreconditionViolationException(String.format("Could not find method with name [%s] and parameter types [%s] in class [%s].", this.methodName, this.parameterTypeNames, this.javaClass.getName()))) : (Method)ReflectionSupport.findMethod(this.javaClass, (String)this.methodName, (Class[])new Class[0]).orElseThrow(() -> new PreconditionViolationException(String.format("Could not find method with name [%s] in class [%s].", this.methodName, this.javaClass.getName())));
        }
    }

    private void lazyLoadParameterTypes() {
        if (this.parameterTypes == null) {
            this.lazyLoadJavaClass();
            this.parameterTypes = ReflectionUtils.resolveParameterTypes(this.javaClass, (String)this.methodName, (String)this.parameterTypeNames);
        }
    }

    @API(status=API.Status.STABLE, since="1.3")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodSelector that = (MethodSelector)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.parameterTypeNames, that.parameterTypeNames);
    }

    @API(status=API.Status.STABLE, since="1.3")
    public int hashCode() {
        return Objects.hash(this.className, this.methodName, this.parameterTypeNames);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("className", (Object)this.getClassName()).append("methodName", (Object)this.getMethodName()).append("parameterTypes", (Object)this.getParameterTypeNames()).append("classLoader", (Object)this.getClassLoader()).toString();
    }

    @Override
    public Optional<DiscoverySelectorIdentifier> toIdentifier() {
        String fullyQualifiedMethodName = ReflectionUtils.getFullyQualifiedMethodName((String)this.className, (String)this.methodName, (String)this.parameterTypeNames);
        return Optional.of(DiscoverySelectorIdentifier.create("method", fullyQualifiedMethodName));
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static class IdentifierParser
    implements DiscoverySelectorIdentifierParser {
        private static final String PREFIX = "method";

        @Override
        public String getPrefix() {
            return PREFIX;
        }

        public Optional<MethodSelector> parse(DiscoverySelectorIdentifier identifier, DiscoverySelectorIdentifierParser.Context context) {
            return Optional.of(DiscoverySelectors.selectMethod(identifier.getValue()));
        }
    }
}

