/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.config.store.hdfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.config.common.impl.SingleLinkedListConfigKeyPath;
import org.apache.gobblin.config.store.api.ConfigKeyPath;
import org.apache.gobblin.config.store.api.ConfigStore;
import org.apache.gobblin.config.store.api.ConfigStoreWithStableVersioning;
import org.apache.gobblin.config.store.api.VersionDoesNotExistException;
import org.apache.gobblin.config.store.deploy.ConfigStream;
import org.apache.gobblin.config.store.deploy.Deployable;
import org.apache.gobblin.config.store.deploy.FsDeploymentConfig;
import org.apache.gobblin.config.store.hdfs.SimpleHDFSStoreMetadata;
import org.apache.gobblin.util.FileListUtils;
import org.apache.gobblin.util.PathUtils;
import org.apache.gobblin.util.io.SeekableFSInputStream;
import org.apache.gobblin.util.io.StreamUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigStoreWithStableVersioning
public class SimpleHadoopFilesystemConfigStore
implements ConfigStore,
Deployable<FsDeploymentConfig> {
    private static final Logger log = LoggerFactory.getLogger(SimpleHadoopFilesystemConfigStore.class);
    protected static final String CONFIG_STORE_NAME = "_CONFIG_STORE";
    private static final String MAIN_CONF_FILE_NAME = "main.conf";
    private static final String INCLUDES_CONF_FILE_NAME = "includes.conf";
    private static final String INCLUDES_KEY_NAME = "includes";
    private final FileSystem fs;
    private final URI physicalStoreRoot;
    private final URI logicalStoreRoot;
    private final Cache<String, Path> versions;
    private final SimpleHDFSStoreMetadata storeMetadata;

    protected SimpleHadoopFilesystemConfigStore(FileSystem fs, URI physicalStoreRoot, URI logicalStoreRoot) {
        Preconditions.checkNotNull((Object)fs, (Object)"fs cannot be null!");
        Preconditions.checkNotNull((Object)physicalStoreRoot, (Object)"physicalStoreRoot cannot be null!");
        Preconditions.checkNotNull((Object)logicalStoreRoot, (Object)"logicalStoreRoot cannot be null!");
        this.fs = fs;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)physicalStoreRoot.getScheme()) ? 1 : 0) != 0, (Object)"The physicalStoreRoot must have a valid scheme!");
        Preconditions.checkArgument((boolean)physicalStoreRoot.getScheme().equals(fs.getUri().getScheme()), (Object)"The scheme of the physicalStoreRoot and the filesystem must match!");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)physicalStoreRoot.getPath()) ? 1 : 0) != 0, (Object)"The path of the physicalStoreRoot must be valid as it is the root of the store!");
        this.physicalStoreRoot = physicalStoreRoot;
        this.logicalStoreRoot = logicalStoreRoot;
        this.versions = CacheBuilder.newBuilder().build();
        this.storeMetadata = new SimpleHDFSStoreMetadata(fs, new Path(new Path(this.physicalStoreRoot), CONFIG_STORE_NAME));
    }

    @Override
    public String getCurrentVersion() {
        try {
            return this.storeMetadata.getCurrentVersion();
        }
        catch (IOException e) {
            Path configStoreDir = new Path(new Path(this.physicalStoreRoot), CONFIG_STORE_NAME);
            throw new RuntimeException(String.format("Error while checking current version for configStoreDir: \"%s\"", configStoreDir), e);
        }
    }

    @Override
    public URI getStoreURI() {
        return this.logicalStoreRoot;
    }

    @Override
    public Collection<ConfigKeyPath> getChildren(ConfigKeyPath configKey, String version) throws VersionDoesNotExistException {
        Preconditions.checkNotNull((Object)configKey, (Object)"configKey cannot be null!");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)version) ? 1 : 0) != 0, (Object)"version cannot be null or empty!");
        ArrayList<ConfigKeyPath> children = new ArrayList<ConfigKeyPath>();
        Path datasetDir = this.getDatasetDirForKey(configKey, version);
        try {
            if (!this.fs.exists(datasetDir)) {
                return children;
            }
            for (FileStatus fileStatus : this.fs.listStatus(datasetDir)) {
                if (!fileStatus.isDirectory()) continue;
                children.add(configKey.createChild(fileStatus.getPath().getName()));
            }
            return children;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Error while getting children for configKey: \"%s\"", configKey), e);
        }
    }

    @Override
    public List<ConfigKeyPath> getOwnImports(ConfigKeyPath configKey, String version) {
        return this.getOwnImports(configKey, version, (Optional<Config>)Optional.absent());
    }

    @Override
    public List<ConfigKeyPath> getOwnImports(ConfigKeyPath configKey, String version, Optional<Config> runtimeConfig) throws VersionDoesNotExistException {
        ArrayList<ConfigKeyPath> configKeyPaths;
        block15: {
            Preconditions.checkNotNull((Object)configKey, (Object)"configKey cannot be null!");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)version) ? 1 : 0) != 0, (Object)"version cannot be null or empty!");
            configKeyPaths = new ArrayList<ConfigKeyPath>();
            Path datasetDir = this.getDatasetDirForKey(configKey, version);
            Path includesFile = new Path(datasetDir, INCLUDES_CONF_FILE_NAME);
            try {
                if (!this.fs.exists(includesFile)) {
                    return configKeyPaths;
                }
                FileStatus includesFileStatus = this.fs.getFileStatus(includesFile);
                if (includesFileStatus.isDirectory()) break block15;
                try (FSDataInputStream includesConfInStream = this.fs.open(includesFileStatus.getPath());){
                    configKeyPaths.addAll(Lists.newArrayList((Iterable)Iterables.transform((Iterable)Lists.reverse(SimpleHadoopFilesystemConfigStore.resolveIncludesList(IOUtils.readLines((InputStream)includesConfInStream, (Charset)Charsets.UTF_8), runtimeConfig)), (Function)new IncludesToConfigKey())));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error while getting config for configKey: \"%s\"", configKey), e);
            }
        }
        return configKeyPaths;
    }

    @VisibleForTesting
    public static List<String> resolveIncludesList(List<String> includes, Optional<Config> runtimeConfig) {
        StringBuilder includesBuilder = new StringBuilder();
        for (String include : includes) {
            if (!StringUtils.isNotBlank((String)include) || StringUtils.startsWith((String)include, (String)"#")) continue;
            includesBuilder.append(INCLUDES_KEY_NAME).append("+=").append(include).append("\n");
        }
        if (includesBuilder.length() > 0) {
            if (runtimeConfig.isPresent()) {
                return ConfigFactory.parseString((String)includesBuilder.toString()).withFallback((ConfigMergeable)ConfigFactory.defaultOverrides()).withFallback((ConfigMergeable)ConfigFactory.systemEnvironment()).withFallback((ConfigMergeable)runtimeConfig.get()).resolve().getStringList(INCLUDES_KEY_NAME);
            }
            return ConfigFactory.parseString((String)includesBuilder.toString()).withFallback((ConfigMergeable)ConfigFactory.defaultOverrides()).withFallback((ConfigMergeable)ConfigFactory.systemEnvironment()).resolve().getStringList(INCLUDES_KEY_NAME);
        }
        return Collections.emptyList();
    }

    public static List<String> resolveIncludesList(List<String> includes) {
        return SimpleHadoopFilesystemConfigStore.resolveIncludesList(includes, (Optional<Config>)Optional.absent());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Config getOwnConfig(ConfigKeyPath configKey, String version) throws VersionDoesNotExistException {
        Preconditions.checkNotNull((Object)configKey, (Object)"configKey cannot be null!");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)version) ? 1 : 0) != 0, (Object)"version cannot be null or empty!");
        Path datasetDir = this.getDatasetDirForKey(configKey, version);
        Path mainConfFile = new Path(datasetDir, MAIN_CONF_FILE_NAME);
        try {
            if (!this.fs.exists(mainConfFile)) {
                return ConfigFactory.empty();
            }
            FileStatus configFileStatus = this.fs.getFileStatus(mainConfFile);
            if (configFileStatus.isDirectory()) return ConfigFactory.empty();
            try (FSDataInputStream mainConfInputStream = this.fs.open(configFileStatus.getPath());){
                Config config = ConfigFactory.parseReader((Reader)new InputStreamReader((InputStream)mainConfInputStream, Charsets.UTF_8));
                return config;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Error while getting config for configKey: \"%s\"", configKey), e);
        }
    }

    private Path getDatasetDirForKey(ConfigKeyPath configKey, String version) throws VersionDoesNotExistException {
        String datasetFromConfigKey = SimpleHadoopFilesystemConfigStore.getDatasetFromConfigKey(configKey);
        if (StringUtils.isBlank((String)datasetFromConfigKey)) {
            return this.getVersionRoot(version);
        }
        return new Path(this.getVersionRoot(version), datasetFromConfigKey);
    }

    private static String getDatasetFromConfigKey(ConfigKeyPath configKey) {
        return StringUtils.removeStart((String)configKey.getAbsolutePathString(), (String)"/");
    }

    private Path getVersionRoot(String version) throws VersionDoesNotExistException {
        try {
            return (Path)this.versions.get((Object)version, (Callable)new VersionRootLoader(version));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(String.format("Error while checking if version \"%s\" for store \"%s\" exists", version, this.getStoreURI()), e);
        }
    }

    @Override
    public void deploy(FsDeploymentConfig deploymentConfig) throws IOException {
        log.info("Deploying with config : " + deploymentConfig);
        Path hdfsconfigStoreRoot = new Path(this.physicalStoreRoot.getPath(), CONFIG_STORE_NAME);
        if (!this.fs.exists(hdfsconfigStoreRoot)) {
            throw new IOException("Config store root not present at " + this.physicalStoreRoot.getPath());
        }
        Path hdfsNewVersionPath = new Path(hdfsconfigStoreRoot, deploymentConfig.getNewVersion());
        if (!this.fs.exists(hdfsNewVersionPath)) {
            this.fs.mkdirs(hdfsNewVersionPath, deploymentConfig.getStorePermissions());
            Set<ConfigStream> confStreams = deploymentConfig.getDeployableConfigSource().getConfigStreams();
            for (ConfigStream confStream : confStreams) {
                String confAtPath = confStream.getConfigPath();
                log.info("Copying resource at : " + confAtPath);
                Path hdsfConfPath = new Path(hdfsNewVersionPath, confAtPath);
                if (!this.fs.exists(hdsfConfPath.getParent())) {
                    this.fs.mkdirs(hdsfConfPath.getParent());
                }
                if (!confStream.getInputStream().isPresent()) continue;
                SeekableFSInputStream inputStream = new SeekableFSInputStream((InputStream)confStream.getInputStream().get());
                Throwable throwable = null;
                try {
                    FSDataOutputStream os = this.fs.create(hdsfConfPath, false);
                    Throwable throwable2 = null;
                    try {
                        StreamUtils.copy((InputStream)inputStream, (OutputStream)os);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (os == null) continue;
                        if (throwable2 != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        os.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            for (FileStatus fileStatus : FileListUtils.listPathsRecursively((FileSystem)this.fs, (Path)hdfsNewVersionPath, (PathFilter)FileListUtils.NO_OP_PATH_FILTER)) {
                this.fs.setPermission(fileStatus.getPath(), deploymentConfig.getStorePermissions());
            }
        } else {
            log.warn(String.format("STORE WITH VERSION %s ALREADY EXISTS. NEW RESOURCES WILL NOT BE COPIED. ONLY STORE MEATADATA FILE WILL BE UPDATED TO %s", deploymentConfig.getNewVersion(), deploymentConfig.getNewVersion()));
        }
        this.storeMetadata.setCurrentVersion(deploymentConfig.getNewVersion());
        log.info(String.format("New version %s of config store deployed at %s", deploymentConfig.getNewVersion(), hdfsconfigStoreRoot));
    }

    @VisibleForTesting
    URI getPhysicalStoreRoot() {
        return this.physicalStoreRoot;
    }

    private static class IncludesToConfigKey
    implements Function<String, ConfigKeyPath> {
        private IncludesToConfigKey() {
        }

        public ConfigKeyPath apply(String input) {
            if (input == null) {
                return null;
            }
            ConfigKeyPath configKey = SingleLinkedListConfigKeyPath.ROOT;
            for (String file : Splitter.on((String)"/").omitEmptyStrings().split((CharSequence)input)) {
                configKey = configKey.createChild(file);
            }
            return configKey;
        }
    }

    private class VersionRootLoader
    implements Callable<Path> {
        private String version;

        @Override
        public Path call() throws IOException {
            Path versionRootPath = PathUtils.combinePaths((String[])new String[]{SimpleHadoopFilesystemConfigStore.this.physicalStoreRoot.toString(), SimpleHadoopFilesystemConfigStore.CONFIG_STORE_NAME, this.version});
            if (SimpleHadoopFilesystemConfigStore.this.fs.isDirectory(versionRootPath)) {
                return versionRootPath;
            }
            throw new VersionDoesNotExistException(SimpleHadoopFilesystemConfigStore.this.getStoreURI(), this.version, String.format("Cannot find specified version under root %s", versionRootPath));
        }

        @ConstructorProperties(value={"version"})
        public VersionRootLoader(String version) {
            this.version = version;
        }
    }
}

