/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.config.store.deploy;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.config.store.deploy.ConfigStream;
import org.apache.gobblin.config.store.deploy.DeployableConfigSource;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class ClasspathConfigSource
implements DeployableConfigSource {
    private final String classpathRootName;
    private static final String DEFAULT_CONFIG_STORE_CLASSPATH_RESOURCE_NAME = "_CONFIG_STORE";
    public static final String CONFIG_STORE_CLASSPATH_RESOURCE_NAME_KEY = "gobblin.config.management.store.deploy.classpathresource";

    public ClasspathConfigSource(Properties props) {
        this.classpathRootName = props.getProperty(CONFIG_STORE_CLASSPATH_RESOURCE_NAME_KEY, DEFAULT_CONFIG_STORE_CLASSPATH_RESOURCE_NAME);
    }

    private Set<String> getDeployableConfigPaths() {
        ConfigurationBuilder cb = new ConfigurationBuilder().setUrls(ClasspathHelper.forClassLoader()).setScanners(new Scanner[]{new ResourcesScanner()}).filterInputsBy((Predicate)new FilterBuilder().include(String.format(".*%s.*", this.classpathRootName)));
        Reflections reflections = new Reflections((Configuration)cb);
        Pattern pattern = Pattern.compile(".*");
        return reflections.getResources(pattern);
    }

    private static InputStream getConfigStream(String configPath) {
        return ClasspathConfigSource.class.getClassLoader().getResourceAsStream(configPath);
    }

    @Override
    public Set<ConfigStream> getConfigStreams() throws IOException {
        HashSet configStreams = Sets.newHashSet();
        for (String configPath : this.getDeployableConfigPaths()) {
            configStreams.add(new ConfigStream((Optional<InputStream>)Optional.of((Object)ClasspathConfigSource.getConfigStream(configPath)), StringUtils.substringAfter((String)Strings.nullToEmpty((String)configPath), (String)(this.classpathRootName + "/"))));
        }
        return configStreams;
    }
}

