/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.config.common.impl;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.gobblin.config.common.impl.ConfigStoreTopologyInspector;
import org.apache.gobblin.config.common.impl.ConfigStoreValueInspector;
import org.apache.gobblin.config.store.api.ConfigKeyPath;
import org.apache.gobblin.config.store.api.ConfigStore;
import org.apache.gobblin.config.store.api.ConfigStoreWithBatchFetches;
import org.apache.gobblin.config.store.api.ConfigStoreWithResolution;

public class ConfigStoreBackedValueInspector
implements ConfigStoreValueInspector {
    private final ConfigStore cs;
    private final String version;
    private final ConfigStoreTopologyInspector topology;

    public ConfigStoreBackedValueInspector(ConfigStore cs, String version, ConfigStoreTopologyInspector topology) {
        this.cs = cs;
        this.version = version;
        this.topology = topology;
    }

    public ConfigStore getConfigStore() {
        return this.cs;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public Config getOwnConfig(ConfigKeyPath configKey) {
        return this.cs.getOwnConfig(configKey, this.version);
    }

    @Override
    public Map<ConfigKeyPath, Config> getOwnConfigs(Collection<ConfigKeyPath> configKeys) {
        if (this.cs instanceof ConfigStoreWithBatchFetches) {
            ConfigStoreWithBatchFetches batchStore = (ConfigStoreWithBatchFetches)this.cs;
            return batchStore.getOwnConfigs(configKeys, this.version);
        }
        HashMap<ConfigKeyPath, Config> result = new HashMap<ConfigKeyPath, Config>();
        for (ConfigKeyPath configKey : configKeys) {
            result.put(configKey, this.cs.getOwnConfig(configKey, this.version));
        }
        return result;
    }

    @SuppressWarnings
    private Config getResolvedConfigRecursive(ConfigKeyPath configKey, Set<String> alreadyLoadedPaths) {
        return this.getResolvedConfigRecursive(configKey, alreadyLoadedPaths, (Optional<Config>)Optional.absent());
    }

    private Config getResolvedConfigRecursive(ConfigKeyPath configKey, Set<String> alreadyLoadedPaths, Optional<Config> runtimeConfig) {
        if (this.cs instanceof ConfigStoreWithResolution) {
            return ((ConfigStoreWithResolution)this.cs).getResolvedConfig(configKey, this.version);
        }
        if (!alreadyLoadedPaths.add(configKey.getAbsolutePathString())) {
            return ConfigFactory.empty();
        }
        Config initialConfig = this.getOwnConfig(configKey);
        if (configKey.isRootPath()) {
            return initialConfig;
        }
        List<ConfigKeyPath> ownImports = this.topology.getOwnImports(configKey, runtimeConfig);
        if (ownImports != null) {
            for (ConfigKeyPath p : ownImports) {
                initialConfig = initialConfig.withFallback((ConfigMergeable)this.getResolvedConfigRecursive(p, alreadyLoadedPaths, runtimeConfig));
            }
        }
        initialConfig = initialConfig.withFallback((ConfigMergeable)this.getResolvedConfigRecursive(configKey.getParent(), alreadyLoadedPaths, runtimeConfig));
        return initialConfig;
    }

    @Override
    public Config getResolvedConfig(ConfigKeyPath configKey, Optional<Config> runtimeConfig) {
        return this.getResolvedConfigRecursive(configKey, Sets.newHashSet(), runtimeConfig).withFallback((ConfigMergeable)ConfigFactory.defaultOverrides()).withFallback((ConfigMergeable)ConfigFactory.systemEnvironment()).resolve();
    }

    @Override
    public Config getResolvedConfig(ConfigKeyPath configKey) {
        return this.getResolvedConfig(configKey, (Optional<Config>)Optional.absent());
    }

    @Override
    public Map<ConfigKeyPath, Config> getResolvedConfigs(Collection<ConfigKeyPath> configKeys) {
        if (this.cs instanceof ConfigStoreWithBatchFetches) {
            ConfigStoreWithBatchFetches batchStore = (ConfigStoreWithBatchFetches)this.cs;
            return batchStore.getResolvedConfigs(configKeys, this.version);
        }
        HashMap<ConfigKeyPath, Config> result = new HashMap<ConfigKeyPath, Config>();
        for (ConfigKeyPath configKey : configKeys) {
            result.put(configKey, this.getResolvedConfig(configKey));
        }
        return result;
    }
}

