/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.config.common.impl;

import com.google.common.base.Optional;
import com.typesafe.config.Config;
import java.util.Collection;
import java.util.List;
import org.apache.gobblin.config.common.impl.ConfigStoreTopologyInspector;
import org.apache.gobblin.config.store.api.ConfigKeyPath;
import org.apache.gobblin.config.store.api.ConfigStore;
import org.apache.gobblin.config.store.api.ConfigStoreWithImportedBy;
import org.apache.gobblin.config.store.api.ConfigStoreWithImportedByRecursively;
import org.apache.gobblin.config.store.api.ConfigStoreWithResolution;

public class ConfigStoreBackedTopology
implements ConfigStoreTopologyInspector {
    private final ConfigStore cs;
    private final String version;

    public ConfigStoreBackedTopology(ConfigStore cs, String version) {
        this.cs = cs;
        this.version = version;
    }

    public ConfigStore getConfigStore() {
        return this.cs;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public Collection<ConfigKeyPath> getChildren(ConfigKeyPath configKey) {
        return this.cs.getChildren(configKey, this.version);
    }

    @Override
    public List<ConfigKeyPath> getOwnImports(ConfigKeyPath configKey) {
        return this.getOwnImports(configKey, (Optional<Config>)Optional.absent());
    }

    @Override
    public List<ConfigKeyPath> getOwnImports(ConfigKeyPath configKey, Optional<Config> runtimeConfig) {
        if (runtimeConfig.isPresent()) {
            return this.cs.getOwnImports(configKey, this.version, runtimeConfig);
        }
        return this.cs.getOwnImports(configKey, this.version);
    }

    @Override
    public Collection<ConfigKeyPath> getImportedBy(ConfigKeyPath configKey) {
        return this.getImportedBy(configKey, (Optional<Config>)Optional.absent());
    }

    @Override
    public Collection<ConfigKeyPath> getImportedBy(ConfigKeyPath configKey, Optional<Config> runtimeConfig) {
        if (this.cs instanceof ConfigStoreWithImportedBy) {
            return ((ConfigStoreWithImportedBy)this.cs).getImportedBy(configKey, this.version, runtimeConfig);
        }
        throw new UnsupportedOperationException("Internal ConfigStore does not support this operation");
    }

    @Override
    public List<ConfigKeyPath> getImportsRecursively(ConfigKeyPath configKey) {
        return this.getImportsRecursively(configKey, (Optional<Config>)Optional.absent());
    }

    @Override
    public List<ConfigKeyPath> getImportsRecursively(ConfigKeyPath configKey, Optional<Config> runtimeConfig) {
        if (this.cs instanceof ConfigStoreWithResolution) {
            return ((ConfigStoreWithResolution)this.cs).getImportsRecursively(configKey, this.version, runtimeConfig);
        }
        throw new UnsupportedOperationException("Internal ConfigStore does not support this operation");
    }

    @Override
    public Collection<ConfigKeyPath> getImportedByRecursively(ConfigKeyPath configKey) {
        return this.getImportedByRecursively(configKey, (Optional<Config>)Optional.absent());
    }

    @Override
    public Collection<ConfigKeyPath> getImportedByRecursively(ConfigKeyPath configKey, Optional<Config> runtimeConfig) {
        if (this.cs instanceof ConfigStoreWithImportedByRecursively) {
            return ((ConfigStoreWithImportedByRecursively)this.cs).getImportedByRecursively(configKey, this.version, runtimeConfig);
        }
        throw new UnsupportedOperationException("Internal ConfigStore does not support this operation");
    }
}

