/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.tools.snapshot.gen;

import com.linkedin.restli.internal.tools.AdditionalDocProvidersUtil;
import com.linkedin.restli.tools.snapshot.gen.RestLiSnapshotExporter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestLiSnapshotExporterCmdLineApp {
    private static final Logger log = LoggerFactory.getLogger(RestLiSnapshotExporterCmdLineApp.class);
    private static final Options OPTIONS = new Options();

    public static void main(String[] args) {
        CommandLine cl = null;
        try {
            GnuParser parser = new GnuParser();
            cl = parser.parse(OPTIONS, args);
        }
        catch (ParseException e) {
            System.err.println("Invalid arguments: " + e.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("restliexporter -sourcepath sourcepath [-resourcepackages packagenames] [-resourceclasses classnames][-name api_name] [-outdir outdir]", OPTIONS);
            System.exit(0);
        }
        String resolverPath = System.getProperty("generator.resolver.path");
        try {
            RestLiSnapshotExporter exporter = new RestLiSnapshotExporter();
            exporter.setResolverPath(resolverPath);
            exporter.export(cl.getOptionValue("name"), null, cl.getOptionValues("sourcepath"), cl.getOptionValues("resourcepackages"), cl.getOptionValues("resourceClasses"), cl.getOptionValue("outdir", "."), AdditionalDocProvidersUtil.findDocProviders(log, cl.hasOption("loadAdditionalDocProviders")));
        }
        catch (Throwable e) {
            log.error("Error writing Snapshot files", e);
            System.out.println("Error writing Snapshot files:\n" + e);
            System.exit(1);
        }
    }

    static {
        OptionBuilder.isRequired();
        OptionBuilder.withArgName((String)"sourcepath");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Space-delimited list of directories in which to find resource Java source files\nIf neither -resourcepackages nor -resourcepackages is provided, all classes defined in the directories will be scanned");
        OPTIONS.addOption(OptionBuilder.create((String)"sourcepath"));
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Name of the API");
        OPTIONS.addOption(OptionBuilder.create((String)"name"));
        OptionBuilder.withArgName((String)"outdir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Directory in which to output the generated Snapshot files (default=current working dir)");
        OPTIONS.addOption(OptionBuilder.create((String)"outdir"));
        OptionBuilder.withArgName((String)"loadAdditionalDocProviders");
        OptionBuilder.withDescription((String)"Will load any additional DocProviders if available on the classpath.");
        OPTIONS.addOption(OptionBuilder.create((String)"loadAdditionalDocProviders"));
        OptionGroup sourceGroup = new OptionGroup();
        OptionBuilder.withArgName((String)"resourcepackages");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Space-delimited list of packages to scan for resource classes");
        Option sourcePkgs = OptionBuilder.create((String)"resourcepackages");
        OptionBuilder.withArgName((String)"resourceclasses");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"space-delimited list of resource classes to scan");
        Option sourceClasses = OptionBuilder.create((String)"resourceclasses");
        sourceGroup.addOption(sourcePkgs);
        sourceGroup.addOption(sourceClasses);
        OPTIONS.addOptionGroup(sourceGroup);
    }
}

