/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.tools.idlgen;

import com.linkedin.restli.internal.server.model.ResourceModelEncoder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLanguageDocsProvider
implements ResourceModelEncoder.DocsProvider {
    private static final Logger log = LoggerFactory.getLogger(MultiLanguageDocsProvider.class);
    private final List<ResourceModelEncoder.DocsProvider> _languageSpecificProviders;

    public static List<ResourceModelEncoder.DocsProvider> loadExternalProviders(List<ResourceModelEncoder.DocsProvider> docsProviders) {
        ArrayList<ResourceModelEncoder.DocsProvider> providers = new ArrayList<ResourceModelEncoder.DocsProvider>();
        for (ResourceModelEncoder.DocsProvider provider : docsProviders) {
            log.info("Executing " + provider.getClass().getSimpleName() + " tool...");
            try {
                if (provider instanceof ResourceModelEncoder.DocsProvider) {
                    ResourceModelEncoder.DocsProvider docsProvider = provider;
                    providers.add(docsProvider);
                    continue;
                }
                log.error("Unable to cast provided docs provider to DocsProvider class: " + provider + ", skipping.");
            }
            catch (Exception e) {
                log.error("Unable to registerSourceFiles documentation provider for class: " + provider + ", skipping.", (Throwable)e);
            }
        }
        return providers;
    }

    public MultiLanguageDocsProvider(List<ResourceModelEncoder.DocsProvider> languageSpecificProviders) {
        this._languageSpecificProviders = languageSpecificProviders;
    }

    public void registerSourceFiles(Collection<String> filenames) {
        for (ResourceModelEncoder.DocsProvider provider : this._languageSpecificProviders) {
            provider.registerSourceFiles(MultiLanguageDocsProvider.filterForFileExtensions(filenames, provider.supportedFileExtensions()));
        }
    }

    private static Collection<String> filterForFileExtensions(Collection<String> filenames, Collection<String> extensions) {
        ArrayList<String> filenamesMatchingExtension = new ArrayList<String>();
        for (String extension : extensions) {
            if (filenames == null) continue;
            for (String sourceFile : filenames) {
                if (!sourceFile.endsWith(extension)) continue;
                filenamesMatchingExtension.add(sourceFile);
            }
        }
        return filenamesMatchingExtension;
    }

    public Set<String> supportedFileExtensions() {
        HashSet supportedFileExtensions = new HashSet();
        for (ResourceModelEncoder.DocsProvider provider : this._languageSpecificProviders) {
            supportedFileExtensions.addAll(provider.supportedFileExtensions());
        }
        return Collections.unmodifiableSet(supportedFileExtensions);
    }

    public String getClassDoc(Class<?> resourceClass) {
        for (ResourceModelEncoder.DocsProvider provider : this._languageSpecificProviders) {
            String doc = provider.getClassDoc(resourceClass);
            if (doc == null) continue;
            return doc;
        }
        return null;
    }

    public String getClassDeprecatedTag(Class<?> resourceClass) {
        for (ResourceModelEncoder.DocsProvider provider : this._languageSpecificProviders) {
            String tag = provider.getClassDeprecatedTag(resourceClass);
            if (tag == null) continue;
            return tag;
        }
        return null;
    }

    public String getMethodDoc(Method method) {
        for (ResourceModelEncoder.DocsProvider provider : this._languageSpecificProviders) {
            String doc = provider.getMethodDoc(method);
            if (doc == null) continue;
            return doc;
        }
        return null;
    }

    public String getMethodDeprecatedTag(Method method) {
        for (ResourceModelEncoder.DocsProvider provider : this._languageSpecificProviders) {
            String tag = provider.getMethodDeprecatedTag(method);
            if (tag == null) continue;
            return tag;
        }
        return null;
    }

    public String getParamDoc(Method method, String name) {
        for (ResourceModelEncoder.DocsProvider provider : this._languageSpecificProviders) {
            String doc = provider.getParamDoc(method, name);
            if (doc == null) continue;
            return doc;
        }
        return null;
    }

    public String getReturnDoc(Method method) {
        for (ResourceModelEncoder.DocsProvider provider : this._languageSpecificProviders) {
            String doc = provider.getReturnDoc(method);
            if (doc == null) continue;
            return doc;
        }
        return null;
    }
}

