/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.tools.clientgen;

import com.linkedin.pegasus.generator.CodeUtil;
import com.linkedin.restli.restspec.ResourceSchema;
import com.linkedin.restli.restspec.RestSpecCodec;
import com.linkedin.util.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RestSpecParser {
    private static final RestSpecCodec _codec = new RestSpecCodec();

    public ParseResult parseSources(String[] sourcePaths) {
        ParseResult result = new ParseResult();
        for (String sourcePath : sourcePaths) {
            File[] sources;
            File source = new File(sourcePath);
            if (!source.exists()) {
                result._message.append("IDL file or directory doesn't exist: ").append(source.getAbsolutePath());
                continue;
            }
            if (source.isDirectory()) {
                FileUtil.FileExtensionFilter filter = new FileUtil.FileExtensionFilter(".restspec.json");
                List sourceFilesInDirectory = FileUtil.listFiles((File)source, (FileFilter)filter);
                sources = sourceFilesInDirectory.toArray(new File[0]);
            } else {
                sources = new File[]{source};
            }
            for (File sourceFile : sources) {
                try {
                    ResourceSchema resource = _codec.readResourceSchema((InputStream)new FileInputStream(sourceFile));
                    result._schemaAndFiles.add(new CodeUtil.Pair((Object)resource, (Object)sourceFile));
                    result._sourceFiles.add(sourceFile);
                }
                catch (IOException e) {
                    result._message.append("Error processing file [").append(sourceFile.getAbsolutePath()).append(']').append(e.getMessage());
                }
            }
        }
        return result;
    }

    public static class ParseResult {
        private final Collection<CodeUtil.Pair<ResourceSchema, File>> _schemaAndFiles = new ArrayList<CodeUtil.Pair<ResourceSchema, File>>();
        private final Collection<File> _sourceFiles = new ArrayList<File>();
        private final StringBuilder _message = new StringBuilder();

        public Collection<CodeUtil.Pair<ResourceSchema, File>> getSchemaAndFiles() {
            return this._schemaAndFiles;
        }

        public Collection<File> getSourceFiles() {
            return this._sourceFiles;
        }

        public StringBuilder getMessage() {
            return this._message;
        }
    }
}

