/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hive.service.auth.HttpAuthUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

public class HttpKerberosRequestInterceptor
implements HttpRequestInterceptor {
    String principal;
    String host;
    String serverHttpUrl;
    boolean assumeSubject;
    private static ReentrantLock kerberosLock = new ReentrantLock(true);

    public HttpKerberosRequestInterceptor(String principal, String host, String serverHttpUrl, boolean assumeSubject) {
        this.principal = principal;
        this.host = host;
        this.serverHttpUrl = serverHttpUrl;
        this.assumeSubject = assumeSubject;
    }

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        try {
            kerberosLock.lock();
            String kerberosAuthHeader = HttpAuthUtils.getKerberosServiceTicket((String)this.principal, (String)this.host, (String)this.serverHttpUrl, (boolean)this.assumeSubject);
            httpRequest.addHeader("Authorization: Negotiate ", kerberosAuthHeader);
        }
        catch (Exception e) {
            throw new HttpException(e.getMessage(), (Throwable)e);
        }
        finally {
            kerberosLock.unlock();
        }
    }
}

