/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.verify;

import java.beans.ConstructorProperties;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.gobblin.compaction.parser.CompactionPathParser;
import org.apache.gobblin.compaction.verify.CompactionVerifier;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionTimeRangeVerifier
implements CompactionVerifier<FileSystemDataset> {
    private static final Logger log = LoggerFactory.getLogger(CompactionTimeRangeVerifier.class);
    public static final String COMPACTION_VERIFIER_TIME_RANGE = "compaction-verifier-time-range";
    protected State state;

    @Override
    public CompactionVerifier.Result verify(FileSystemDataset dataset) {
        DateTime latest;
        DateTime earliest;
        try {
            CompactionPathParser.CompactionParserResult result = new CompactionPathParser(this.state).parse(dataset);
            DateTime folderTime = result.getTime();
            DateTimeZone timeZone = DateTimeZone.forID((String)this.state.getProp("compaction.timezone", "America/Los_Angeles"));
            DateTime compactionStartTime = new DateTime(this.state.getPropAsLong("compaction.init.time"), timeZone);
            PeriodFormatter formatter = new PeriodFormatterBuilder().appendMonths().appendSuffix("m").appendDays().appendSuffix("d").appendHours().appendSuffix("h").toFormatter();
            String maxTimeAgoStr = this.state.getProp("compaction.timebased.max.time.ago", "3d");
            Period maxTimeAgo = formatter.parsePeriod(maxTimeAgoStr);
            earliest = compactionStartTime.minus((ReadablePeriod)maxTimeAgo);
            String minTimeAgoStr = this.state.getProp("compaction.timebased.min.time.ago", "1d");
            Period minTimeAgo = formatter.parsePeriod(minTimeAgoStr);
            latest = compactionStartTime.minus((ReadablePeriod)minTimeAgo);
            if (earliest.isBefore((ReadableInstant)folderTime) && latest.isAfter((ReadableInstant)folderTime)) {
                log.debug("{} falls in the user defined time range", (Object)dataset.datasetRoot());
                return new CompactionVerifier.Result(true, "");
            }
        }
        catch (Exception e) {
            log.error("{} cannot be verified because of {}", (Object)dataset.datasetRoot(), (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            return new CompactionVerifier.Result(false, e.toString());
        }
        return new CompactionVerifier.Result(false, dataset.datasetRoot() + " is not in between " + earliest + " and " + latest);
    }

    @Override
    public String getName() {
        return COMPACTION_VERIFIER_TIME_RANGE;
    }

    @Override
    public boolean isRetriable() {
        return false;
    }

    @ConstructorProperties(value={"state"})
    public CompactionTimeRangeVerifier(State state) {
        this.state = state;
    }
}

