/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.mapreduce;

import com.google.common.base.Optional;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.gobblin.compaction.CliOptions;
import org.apache.gobblin.compaction.Compactor;
import org.apache.gobblin.compaction.CompactorCreationException;
import org.apache.gobblin.compaction.CompactorFactory;
import org.apache.gobblin.compaction.ReflectionCompactorFactory;
import org.apache.gobblin.compaction.listeners.CompactorListener;
import org.apache.gobblin.compaction.listeners.CompactorListenerCreationException;
import org.apache.gobblin.compaction.listeners.CompactorListenerFactory;
import org.apache.gobblin.compaction.listeners.ReflectionCompactorListenerFactory;
import org.apache.gobblin.metrics.Tag;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MRCompactionRunner {
    private static final Logger LOG = LoggerFactory.getLogger(MRCompactionRunner.class);
    private final Properties properties;
    private final Compactor compactor;

    public MRCompactionRunner(Properties properties) {
        this.properties = properties;
        this.compactor = this.getCompactor(this.getCompactorFactory(), this.getCompactorListener(this.getCompactorListenerFactory()));
    }

    public static void main(String[] args) throws IOException, ConfigurationException, ParseException, URISyntaxException {
        Properties jobProperties = CliOptions.parseArgs(MRCompactionRunner.class, args, new Configuration());
        MRCompactionRunner compactionRunner = new MRCompactionRunner(jobProperties);
        compactionRunner.compact();
    }

    public void compact() throws IOException {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    MRCompactionRunner.this.compactor.cancel();
                }
                catch (IOException e) {
                    LOG.warn("Unable to cancel the compactor jobs!", (Throwable)e);
                }
            }
        });
        try {
            this.compactor.compact();
        }
        catch (Exception e) {
            this.compactor.cancel();
        }
    }

    protected CompactorListenerFactory getCompactorListenerFactory() {
        return new ReflectionCompactorListenerFactory();
    }

    protected CompactorFactory getCompactorFactory() {
        return new ReflectionCompactorFactory();
    }

    private Compactor getCompactor(CompactorFactory compactorFactory, Optional<CompactorListener> compactorListener) {
        try {
            return compactorFactory.createCompactor(this.properties, new ArrayList<Tag<String>>(), compactorListener);
        }
        catch (CompactorCreationException e) {
            throw new RuntimeException("Unable to create compactor", e);
        }
    }

    private Optional<CompactorListener> getCompactorListener(CompactorListenerFactory compactorListenerFactory) {
        try {
            return compactorListenerFactory.createCompactorListener(this.properties);
        }
        catch (CompactorListenerCreationException e) {
            throw new RuntimeException("Unable to create compactor listener", e);
        }
    }
}

