/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.listeners;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.gobblin.compaction.listeners.CompactorListener;
import org.apache.gobblin.compaction.listeners.CompactorListenerCreationException;
import org.apache.gobblin.compaction.listeners.CompactorListenerFactory;
import org.apache.gobblin.compaction.listeners.SerialCompactorListener;
import org.apache.gobblin.configuration.State;

public class ReflectionCompactorListenerFactory
implements CompactorListenerFactory {
    @VisibleForTesting
    static final String COMPACTOR_LISTENERS = "compactor.listeners";

    @Override
    public Optional<CompactorListener> createCompactorListener(Properties properties) throws CompactorListenerCreationException {
        State state = new State(properties);
        if (Strings.isNullOrEmpty((String)state.getProp(COMPACTOR_LISTENERS))) {
            return Optional.absent();
        }
        ArrayList<CompactorListener> listeners = new ArrayList<CompactorListener>();
        for (String listenerClassName : state.getPropAsList(COMPACTOR_LISTENERS)) {
            try {
                listeners.add((CompactorListener)ConstructorUtils.invokeConstructor(Class.forName(listenerClassName), (Object[])new Object[]{properties}));
            }
            catch (ReflectiveOperationException e) {
                throw new CompactorListenerCreationException(String.format("Unable to create CompactorListeners from key \"%s\" with value \"%s\"", COMPACTOR_LISTENERS, properties.getProperty(COMPACTOR_LISTENERS)), e);
            }
        }
        return Optional.of((Object)new SerialCompactorListener(listeners));
    }
}

