/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.hive.registration;

import java.util.Properties;
import org.apache.gobblin.compaction.dataset.Dataset;
import org.apache.gobblin.compaction.listeners.CompactorListener;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.hive.HiveRegister;
import org.apache.gobblin.hive.policy.HiveRegistrationPolicy;
import org.apache.gobblin.hive.policy.HiveRegistrationPolicyBase;
import org.apache.gobblin.hive.spec.HiveSpec;

public class HiveRegistrationCompactorListener
implements CompactorListener {
    private final HiveRegister hiveRegister;
    private final HiveRegistrationPolicy hiveRegistrationPolicy;

    public HiveRegistrationCompactorListener(Properties properties) {
        State state = new State(properties);
        this.hiveRegister = HiveRegister.get((State)state);
        this.hiveRegistrationPolicy = HiveRegistrationPolicyBase.getPolicy((State)state);
    }

    @Override
    public void onDatasetCompactionCompletion(Dataset dataset) throws Exception {
        for (HiveSpec spec : this.hiveRegistrationPolicy.getHiveSpecs(dataset.outputPath())) {
            this.hiveRegister.register(spec);
        }
    }
}

