/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.hive;

import com.google.common.base.Splitter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.compaction.hive.HiveAttribute;
import org.apache.gobblin.util.HiveJdbcConnector;

public abstract class HiveTable {
    protected static final String DROP_TABLE_STMT = "DROP TABLE IF EXISTS %1$s";
    protected final String name;
    protected List<String> primaryKeys;
    protected List<HiveAttribute> attributes;

    protected HiveTable(Builder<?> builder) {
        this.name = builder.name;
        this.primaryKeys = Collections.unmodifiableList(builder.primaryKeys);
        this.attributes = Collections.unmodifiableList(builder.attributes);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public List<HiveAttribute> getAttributes() {
        return this.attributes;
    }

    public void dropTable(HiveJdbcConnector conn, String jobId) throws SQLException {
        String dropTableStmt = String.format(DROP_TABLE_STMT, this.getNameWithJobId(jobId));
        conn.executeStatements(new String[]{dropTableStmt});
    }

    protected String getNameWithJobId(String randomSuffix) {
        return this.name + "_" + randomSuffix;
    }

    protected boolean hasNoNewColumn(HiveTable table) {
        for (HiveAttribute attribute : table.attributes) {
            if (this.attributes.contains(attribute)) continue;
            return false;
        }
        return true;
    }

    public abstract void createTable(HiveJdbcConnector var1, String var2) throws SQLException;

    public abstract HiveTable addNewColumnsInSchema(HiveJdbcConnector var1, HiveTable var2, String var3) throws SQLException;

    public static class Builder<T extends Builder<?>> {
        protected String name = UUID.randomUUID().toString().replaceAll("-", "_");
        protected List<String> primaryKeys = new ArrayList<String>();
        protected List<HiveAttribute> attributes = new ArrayList<HiveAttribute>();

        public T withName(String name) {
            if (StringUtils.isNotBlank((String)name)) {
                this.name = name;
            }
            return (T)this;
        }

        public T withPrimaryKeys(List<String> primaryKeys) {
            this.primaryKeys = primaryKeys;
            return (T)this;
        }

        public T withPrimaryKeys(String keyAttrs) {
            List keyAttrsList = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)keyAttrs);
            this.primaryKeys.addAll(keyAttrsList);
            return (T)this;
        }

        public T withAttributes(List<HiveAttribute> attributes) {
            this.attributes = attributes;
            return (T)this;
        }
    }
}

