/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.dataset;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.gobblin.compaction.dataset.Dataset;
import org.apache.gobblin.compaction.dataset.DatasetsFinder;
import org.apache.gobblin.configuration.State;
import org.apache.hadoop.fs.Path;

public class SimpleDatasetsFinder
extends DatasetsFinder {
    public SimpleDatasetsFinder(State state) {
        super(state);
    }

    @Override
    public Set<Dataset> findDistinctDatasets() throws IOException {
        HashSet datasets = Sets.newHashSet();
        Path inputPath = new Path(this.inputDir);
        Path inputLatePath = new Path(inputPath, "_late");
        Path outputPath = new Path(this.destDir);
        Path outputLatePath = new Path(outputPath, "_late");
        Dataset dataset = new Dataset.Builder().withPriority(this.getDatasetPriority(inputPath.getName())).addInputPath(this.recompactDatasets ? outputPath : inputPath).addInputLatePath(this.recompactDatasets ? outputLatePath : inputLatePath).withOutputPath(outputPath).withOutputLatePath(outputLatePath).withOutputTmpPath(new Path(this.tmpOutputDir)).build();
        datasets.add(dataset);
        return datasets;
    }
}

