/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.transform.patch;

import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.transform.Instruction;
import com.linkedin.data.transform.Interpreter;
import com.linkedin.data.transform.InterpreterContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Patch
implements Interpreter {
    private static final String CHILD_PROCESS_PSEUDOCOMMAND = "$child-process";
    private static final List<String> NON_DELETE_OPERATIONS = Arrays.asList("$set");
    private IdentityHashMap<DataMap, Boolean> _hasDeletesOnly = new IdentityHashMap();
    private final boolean _logOperations;

    public Patch() {
        this(false);
    }

    public Patch(boolean logOperations) {
        this._logOperations = logOperations;
    }

    @Override
    public void interpret(InterpreterContext instrCtx) {
        Instruction instruction = instrCtx.getCurrentInstruction();
        assert (instruction.getOperation().getClass() == DataMap.class);
        assert (instruction.getData().getClass() == DataMap.class);
        HashMap<String, String> usedFields = new HashMap<String, String>();
        DataMap opNode = (DataMap)instruction.getOperation();
        DataMap dataNode = (DataMap)instruction.getData();
        this.executeSetCommand(opNode.get((Object)"$set"), dataNode, usedFields, instrCtx);
        this.executeDeleteCommand(opNode.get((Object)"$delete"), dataNode, usedFields, instrCtx);
        for (Map.Entry entry : opNode.entrySet()) {
            this.processChild(dataNode, (String)entry.getKey(), entry.getValue(), usedFields, instrCtx);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean processChild(DataMap dataNode, String name, Object opChild, Map<String, String> usedFields, InterpreterContext instrCtx) {
        instrCtx.setCurrentField(name);
        if (name.startsWith("$")) return true;
        if (usedFields.containsKey(name)) {
            instrCtx.addErrorMessage("field %1$s can not be used in both %2$s operation and be a branch in Patch at the same time", name, usedFields.get(name));
            return false;
        }
        if (opChild.getClass() != DataMap.class) {
            instrCtx.addErrorMessage("incorrect wire format of patch, simple type values are allowed only as children of commands; node name: %1$s, value: %2$s", name, opChild);
            return false;
        }
        usedFields.put(name, CHILD_PROCESS_PSEUDOCOMMAND);
        DataMap opChildDataMap = (DataMap)opChild;
        Object dataChild = dataNode.get((Object)name);
        if (dataChild == null) {
            if (this.hasDeletesOnly(opChildDataMap)) {
                if (!this._logOperations) return true;
            }
            dataChild = new DataMap();
            dataNode.put((Object)name, dataChild);
            instrCtx.scheduleInstruction(new Instruction(opChild, (DataComplex)((DataMap)dataChild), instrCtx.getPath()));
            return true;
        }
        if (dataChild.getClass() == DataMap.class) {
            instrCtx.scheduleInstruction(new Instruction(opChild, (DataComplex)((DataMap)dataChild), instrCtx.getPath()));
            return true;
        }
        instrCtx.addErrorMessage("patch incopatible with data object, expected %1$s field to be of type DataMap, but found: %2$s", name, dataChild.getClass().getName());
        return false;
    }

    private boolean executeDeleteCommand(Object deleteCommand, Object data, Map<String, String> usedFields, InterpreterContext instrCtx) {
        instrCtx.setCurrentField("$delete");
        if (deleteCommand != null) {
            assert (deleteCommand.getClass() == DataList.class);
            assert (data.getClass() == DataMap.class);
            DataList delDataList = (DataList)deleteCommand;
            DataMap dataDataMap = (DataMap)data;
            for (Object key : delDataList) {
                if (usedFields.containsKey(key)) {
                    instrCtx.addErrorMessage("field %1$s can not be used in both %2$s operation and $delete operation at the same time", key, usedFields.get(key));
                    return false;
                }
                usedFields.put(key.toString(), "$delete");
                dataDataMap.remove(key);
                if (!this._logOperations) continue;
                instrCtx.addInfoMessage(key.toString(), new Object[0]);
            }
        }
        return true;
    }

    private boolean executeSetCommand(Object setCommand, Object data, Map<String, String> usedFields, InterpreterContext instrCtx) {
        instrCtx.setCurrentField("$set");
        if (setCommand != null) {
            assert (setCommand.getClass() == DataMap.class) : setCommand.getClass();
            assert (data.getClass() == DataMap.class) : data.getClass();
            DataMap setDataMap = (DataMap)setCommand;
            DataMap dataDataMap = (DataMap)data;
            for (Map.Entry entry : setDataMap.entrySet()) {
                String key = (String)entry.getKey();
                if (usedFields.containsKey(key)) {
                    instrCtx.addErrorMessage("field %1$s can not be used in both %2$s operation and $set operation at the same time", key, usedFields.get(key));
                    return false;
                }
                usedFields.put(key.toString(), "$set");
                dataDataMap.put((Object)key, entry.getValue());
                if (!this._logOperations) continue;
                instrCtx.addInfoMessage(key, new Object[0]);
            }
        }
        return true;
    }

    private boolean hasDeletesOnly(DataMap opNode) {
        Boolean hdo = this._hasDeletesOnly.get(opNode);
        if (hdo == null) {
            Iterator<String> it = NON_DELETE_OPERATIONS.iterator();
            while (hdo == null && it.hasNext()) {
                if (!opNode.containsKey((Object)it.next())) continue;
                hdo = false;
            }
            Iterator nodeIt = opNode.values().iterator();
            while (hdo == null && nodeIt.hasNext()) {
                Object child = nodeIt.next();
                if (child.getClass() != DataMap.class || this.hasDeletesOnly((DataMap)child)) continue;
                hdo = false;
            }
            if (hdo == null) {
                hdo = true;
            }
            this._hasDeletesOnly.put(opNode, hdo);
        }
        return hdo;
    }
}

