/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.transform.filter;

import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.transform.Instruction;
import com.linkedin.data.transform.Interpreter;
import com.linkedin.data.transform.InterpreterContext;
import com.linkedin.data.transform.filter.AbstractFilter;
import com.linkedin.data.transform.filter.FilterConstants;
import java.util.Map;

public class Filter
extends AbstractFilter
implements Interpreter {
    private InterpreterContext _instrCtx;

    @Override
    public void interpret(InterpreterContext instrCtx) {
        this._instrCtx = instrCtx;
        Instruction instruction = this._instrCtx.getCurrentInstruction();
        DataComplex dataValue = instruction.getData();
        DataMap opNode = this.getOperation(instruction);
        this.filter(dataValue, opNode);
    }

    @Override
    protected Object onFilterDataList(DataList data, int start, int count, Object operation) {
        if (operation == FilterConstants.NEGATIVE) {
            data.clear();
        } else {
            if (start + count < data.size()) {
                data.removeRange(start + count, data.size());
            }
            if (start > 0) {
                if (start >= data.size()) {
                    data.clear();
                } else {
                    data.removeRange(0, start);
                }
            }
            if (operation.getClass() == DataMap.class) {
                for (int i = 0; i < data.size(); ++i) {
                    Object value = data.get(i);
                    if (!(value instanceof DataComplex)) continue;
                    this._instrCtx.setCurrentField(start + i);
                    this.scheduleInstruction((DataMap)operation, (DataComplex)value);
                }
            }
        }
        return data;
    }

    @Override
    protected Object onFilterDataMap(DataMap data, Map<String, Object> fieldToOperation) {
        for (Map.Entry<String, Object> operation : fieldToOperation.entrySet()) {
            if (operation.getValue() != FilterConstants.NEGATIVE) continue;
            data.remove((Object)operation.getKey());
        }
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            Object operation = fieldToOperation.get(entry.getKey());
            if (operation == null || operation.getClass() != DataMap.class) continue;
            this._instrCtx.setCurrentField(entry.getKey());
            this.scheduleInstruction((DataMap)operation, (DataComplex)entry.getValue());
        }
        return data;
    }

    @Override
    protected boolean isValidDataMapFieldOperation(Map<String, Object> result, String name, Object operation) {
        return operation != FilterConstants.POSITIVE;
    }

    @Override
    protected Object onError(Object field, String format, Object ... args) {
        if (field != null) {
            this._instrCtx.setCurrentField(field);
        }
        this._instrCtx.addErrorMessage(format, args);
        return null;
    }

    private DataMap getOperation(Instruction instruction) {
        Object opObj = instruction.getOperation();
        if (opObj != null) {
            if (opObj.getClass() == DataMap.class) {
                return (DataMap)opObj;
            }
            this._instrCtx.addErrorMessage("Instruction's operation must be instance of DataMap, but it is instance of %1$s", opObj.getClass().getName());
        } else {
            this._instrCtx.addErrorMessage("Instruction's operation must not be null", new Object[0]);
        }
        return null;
    }

    private void scheduleInstruction(DataMap childOperation, DataComplex childData) {
        this._instrCtx.scheduleInstruction(new Instruction(childOperation, childData, this._instrCtx.getPath()));
    }
}

