/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.transform;

import com.linkedin.util.ArgumentUtil;

public class ImmutableList<T> {
    private static final ImmutableList EMPTY = new ImmutableList<Object>(null, null);
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final T _tail;
    private final ImmutableList<T> _head;
    private final int _size;
    private final int _hashCode;

    private ImmutableList(T tail, ImmutableList<T> head) {
        this._tail = tail;
        this._head = head;
        this._size = (head != null ? head._size : 0) + (tail != null ? 1 : 0);
        this._hashCode = this.calculateHashCode(tail, head);
    }

    private int calculateHashCode(T tail, ImmutableList<T> head) {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._head == null ? 0 : this._head.hashCode());
        result = 31 * result + (this._tail == null ? 0 : this._tail.hashCode());
        return result;
    }

    public ImmutableList(T element) {
        if (element == null) {
            throw new NullPointerException();
        }
        this._tail = element;
        this._head = ImmutableList.empty();
        this._size = 1;
        this._hashCode = this.calculateHashCode(element, this._head);
    }

    public ImmutableList<T> append(T element) {
        ArgumentUtil.notNull(element, (String)"element");
        return new ImmutableList<T>(element, this);
    }

    public static final <T> ImmutableList<T> empty() {
        return EMPTY;
    }

    public Object[] toArray() {
        if (this._size == 0) {
            return EMPTY_ARRAY;
        }
        Object[] result = new Object[this._size];
        int index = this._size - 1;
        ImmutableList<T> current = this;
        while (current._tail != null) {
            result[index--] = current._tail;
            current = current._head;
        }
        return result;
    }

    public int size() {
        return this._size;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableList other = (ImmutableList)obj;
        if (this._head == null ? other._head != null : !this._head.equals(other._head)) {
            return false;
        }
        return !(this._tail == null ? other._tail != null : !this._tail.equals(other._tail));
    }
}

