/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.transform;

import com.linkedin.data.DataComplex;
import com.linkedin.data.DataMap;
import com.linkedin.data.message.Message;
import com.linkedin.data.message.MessageList;
import com.linkedin.data.transform.DataProcessingException;
import com.linkedin.data.transform.FILOScheduler;
import com.linkedin.data.transform.FastFailException;
import com.linkedin.data.transform.ImmutableList;
import com.linkedin.data.transform.Instruction;
import com.linkedin.data.transform.InstructionScheduler;
import com.linkedin.data.transform.Interpreter;
import com.linkedin.data.transform.InterpreterContext;
import java.util.List;

public class DataComplexProcessor {
    public static final String DATA_PROCESSING_FAILED = "data processing failed";
    private final InstructionScheduler _instructionScheduler;
    private final Interpreter _interpreter;
    private final DataMap _program;
    private final DataComplex _data;
    private static final ImmutableList<Object> _rootPath = ImmutableList.empty();

    public DataComplexProcessor(InstructionScheduler instructionScheduler, Interpreter interpreter, DataMap program, DataComplex data) {
        this._instructionScheduler = instructionScheduler;
        this._interpreter = interpreter;
        this._program = program;
        this._data = data;
    }

    public DataComplexProcessor(Interpreter interpreter, DataMap program, DataComplex data) {
        this(new FILOScheduler(), interpreter, program, data);
    }

    public MessageList<Message> runDataProcessing(boolean fastFail) throws DataProcessingException {
        if (this._program != null) {
            InterpreterContext ic = new InterpreterContext(fastFail, this._instructionScheduler);
            Instruction firstInstruction = new Instruction(this._program, this._data, _rootPath);
            this._instructionScheduler.scheduleInstruction(firstInstruction);
            while (this._instructionScheduler.hasNext()) {
                Instruction next = this._instructionScheduler.next();
                try {
                    ic.setCurrentInstruction(next);
                    this._interpreter.interpret(ic);
                }
                catch (FastFailException ff) {
                    throw new DataProcessingException(DATA_PROCESSING_FAILED, (List<Message>)ic.getErrorMessages());
                }
            }
            if (ic.failed()) {
                throw new DataProcessingException(DATA_PROCESSING_FAILED, (List<Message>)ic.getErrorMessages());
            }
            return ic.getInfoMessages();
        }
        return null;
    }

    public void run(boolean fastFail) throws DataProcessingException {
        this.runDataProcessing(fastFail);
    }
}

