/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.restspec;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import com.linkedin.restli.restspec.CustomAnnotationContentSchemaMap;
import com.linkedin.restli.restspec.ParameterSchemaArray;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ActionSchema
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"ActionSchema\",\"namespace\":\"com.linkedin.restli.restspec\",\"include\":[{\"type\":\"record\",\"name\":\"CustomAnnotationSchema\",\"doc\":\"Custom annotation for idl\",\"fields\":[{\"name\":\"annotations\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"record\",\"name\":\"CustomAnnotationContentSchema\",\"doc\":\"Unstructured record that represents arbitrary custom annotations for idl. Actual content is always a map with annotation's overridable member name as key and member value as value\",\"fields\":[]}},\"doc\":\"custom annotation data\",\"optional\":true}]}],\"fields\":[{\"name\":\"name\",\"type\":\"string\",\"doc\":\"name of this action\"},{\"name\":\"doc\",\"type\":\"string\",\"doc\":\"Documentation for this action\",\"optional\":true},{\"name\":\"parameters\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"ParameterSchema\",\"include\":[\"CustomAnnotationSchema\"],\"fields\":[{\"name\":\"name\",\"type\":\"string\",\"doc\":\"name of this parameter\"},{\"name\":\"type\",\"type\":\"string\",\"doc\":\"avro type of this parameter\"},{\"name\":\"items\",\"type\":\"string\",\"doc\":\"type of individual items, if this is an array parameter (used for finder parameters)\",\"optional\":true},{\"name\":\"optional\",\"type\":\"boolean\",\"doc\":\"indicates whether this parameter is optional.  omitted for required parameters\",\"optional\":true},{\"name\":\"default\",\"type\":\"string\",\"doc\":\"indicates the default value for this parameter\",\"optional\":true},{\"name\":\"doc\",\"type\":\"string\",\"doc\":\"Documentation for this parameter\",\"optional\":true}]}},\"doc\":\"parameters for this action\",\"optional\":true},{\"name\":\"returns\",\"type\":\"string\",\"doc\":\"avro type of this action's return value\",\"optional\":true},{\"name\":\"throws\",\"type\":{\"type\":\"array\",\"items\":\"string\"},\"doc\":\"list of exception types thrown by this action\",\"optional\":true}]}");
    private static final RecordDataSchema.Field FIELD_Annotations = SCHEMA.getField("annotations");
    private static final RecordDataSchema.Field FIELD_Name = SCHEMA.getField("name");
    private static final RecordDataSchema.Field FIELD_Doc = SCHEMA.getField("doc");
    private static final RecordDataSchema.Field FIELD_Parameters = SCHEMA.getField("parameters");
    private static final RecordDataSchema.Field FIELD_Returns = SCHEMA.getField("returns");
    private static final RecordDataSchema.Field FIELD_Throws = SCHEMA.getField("throws");

    public ActionSchema() {
        super(new DataMap(), SCHEMA);
    }

    public ActionSchema(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasAnnotations() {
        return this.contains(FIELD_Annotations);
    }

    public void removeAnnotations() {
        this.remove(FIELD_Annotations);
    }

    public CustomAnnotationContentSchemaMap getAnnotations(GetMode mode) {
        return (CustomAnnotationContentSchemaMap)this.obtainWrapped(FIELD_Annotations, CustomAnnotationContentSchemaMap.class, mode);
    }

    @Nullable
    public CustomAnnotationContentSchemaMap getAnnotations() {
        return (CustomAnnotationContentSchemaMap)this.obtainWrapped(FIELD_Annotations, CustomAnnotationContentSchemaMap.class, GetMode.STRICT);
    }

    public ActionSchema setAnnotations(CustomAnnotationContentSchemaMap value, SetMode mode) {
        this.putWrapped(FIELD_Annotations, CustomAnnotationContentSchemaMap.class, (DataTemplate)value, mode);
        return this;
    }

    public ActionSchema setAnnotations(@Nonnull CustomAnnotationContentSchemaMap value) {
        this.putWrapped(FIELD_Annotations, CustomAnnotationContentSchemaMap.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasName() {
        return this.contains(FIELD_Name);
    }

    public void removeName() {
        this.remove(FIELD_Name);
    }

    public String getName(GetMode mode) {
        return (String)this.obtainDirect(FIELD_Name, String.class, mode);
    }

    @Nonnull
    public String getName() {
        return (String)this.obtainDirect(FIELD_Name, String.class, GetMode.STRICT);
    }

    public ActionSchema setName(String value, SetMode mode) {
        this.putDirect(FIELD_Name, String.class, String.class, value, mode);
        return this;
    }

    public ActionSchema setName(@Nonnull String value) {
        this.putDirect(FIELD_Name, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasDoc() {
        return this.contains(FIELD_Doc);
    }

    public void removeDoc() {
        this.remove(FIELD_Doc);
    }

    public String getDoc(GetMode mode) {
        return (String)this.obtainDirect(FIELD_Doc, String.class, mode);
    }

    @Nullable
    public String getDoc() {
        return (String)this.obtainDirect(FIELD_Doc, String.class, GetMode.STRICT);
    }

    public ActionSchema setDoc(String value, SetMode mode) {
        this.putDirect(FIELD_Doc, String.class, String.class, value, mode);
        return this;
    }

    public ActionSchema setDoc(@Nonnull String value) {
        this.putDirect(FIELD_Doc, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasParameters() {
        return this.contains(FIELD_Parameters);
    }

    public void removeParameters() {
        this.remove(FIELD_Parameters);
    }

    public ParameterSchemaArray getParameters(GetMode mode) {
        return (ParameterSchemaArray)this.obtainWrapped(FIELD_Parameters, ParameterSchemaArray.class, mode);
    }

    @Nullable
    public ParameterSchemaArray getParameters() {
        return (ParameterSchemaArray)this.obtainWrapped(FIELD_Parameters, ParameterSchemaArray.class, GetMode.STRICT);
    }

    public ActionSchema setParameters(ParameterSchemaArray value, SetMode mode) {
        this.putWrapped(FIELD_Parameters, ParameterSchemaArray.class, (DataTemplate)value, mode);
        return this;
    }

    public ActionSchema setParameters(@Nonnull ParameterSchemaArray value) {
        this.putWrapped(FIELD_Parameters, ParameterSchemaArray.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasReturns() {
        return this.contains(FIELD_Returns);
    }

    public void removeReturns() {
        this.remove(FIELD_Returns);
    }

    public String getReturns(GetMode mode) {
        return (String)this.obtainDirect(FIELD_Returns, String.class, mode);
    }

    @Nullable
    public String getReturns() {
        return (String)this.obtainDirect(FIELD_Returns, String.class, GetMode.STRICT);
    }

    public ActionSchema setReturns(String value, SetMode mode) {
        this.putDirect(FIELD_Returns, String.class, String.class, value, mode);
        return this;
    }

    public ActionSchema setReturns(@Nonnull String value) {
        this.putDirect(FIELD_Returns, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasThrows() {
        return this.contains(FIELD_Throws);
    }

    public void removeThrows() {
        this.remove(FIELD_Throws);
    }

    public StringArray getThrows(GetMode mode) {
        return (StringArray)this.obtainWrapped(FIELD_Throws, StringArray.class, mode);
    }

    @Nullable
    public StringArray getThrows() {
        return (StringArray)this.obtainWrapped(FIELD_Throws, StringArray.class, GetMode.STRICT);
    }

    public ActionSchema setThrows(StringArray value, SetMode mode) {
        this.putWrapped(FIELD_Throws, StringArray.class, (DataTemplate)value, mode);
        return this;
    }

    public ActionSchema setThrows(@Nonnull StringArray value) {
        this.putWrapped(FIELD_Throws, StringArray.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public ActionSchema clone() throws CloneNotSupportedException {
        return (ActionSchema)super.clone();
    }

    public ActionSchema copy() throws CloneNotSupportedException {
        return (ActionSchema)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public CustomAnnotationContentSchemaMap.Fields annotations() {
            return new CustomAnnotationContentSchemaMap.Fields(this.getPathComponents(), "annotations");
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec doc() {
            return new PathSpec(this.getPathComponents(), "doc");
        }

        public ParameterSchemaArray.Fields parameters() {
            return new ParameterSchemaArray.Fields(this.getPathComponents(), "parameters");
        }

        public PathSpec returns() {
            return new PathSpec(this.getPathComponents(), "returns");
        }

        public PathSpec throws_() {
            return new PathSpec(this.getPathComponents(), "throws");
        }
    }
}

