/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.common;

import com.linkedin.data.ByteString;
import com.linkedin.data.template.DataTemplateUtil;

public class ValueConverter {
    public static Object coerceString(String value, Class<?> clazz) {
        if (value == null) {
            return null;
        }
        if (String.class.equals(clazz)) {
            return value;
        }
        if (Short.TYPE.equals(clazz) || Short.class.equals(clazz)) {
            return Short.valueOf(value);
        }
        if (Double.TYPE.equals(clazz) || Double.class.equals(clazz)) {
            return Double.valueOf(value);
        }
        if (Float.TYPE.equals(clazz) || Float.class.equals(clazz)) {
            return Float.valueOf(value);
        }
        if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
            return Boolean.valueOf(value);
        }
        if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz)) {
            return Integer.valueOf(value);
        }
        if (Long.TYPE.equals(clazz) || Long.class.equals(clazz)) {
            return Long.valueOf(value);
        }
        if (ByteString.class.equals(clazz)) {
            return ByteString.copyAvroString((String)value, (boolean)true);
        }
        if (clazz.isEnum()) {
            return DataTemplateUtil.coerceOutput((Object)value, clazz);
        }
        throw new IllegalArgumentException("Cannot coerce String to type: " + value + " -> " + clazz.getName());
    }
}

