/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common.attachments;

import com.linkedin.data.ByteString;
import com.linkedin.multipart.MultiPartMIMEReader;
import com.linkedin.multipart.MultiPartMIMEReaderCallback;
import com.linkedin.multipart.SinglePartMIMEReaderCallback;
import com.linkedin.multipart.exceptions.GeneralMultiPartMIMEReaderStreamException;
import com.linkedin.r2.RemoteInvocationException;
import com.linkedin.r2.message.stream.entitystream.WriteHandle;
import com.linkedin.restli.common.attachments.RestLiAttachmentDataSourceWriter;
import com.linkedin.restli.common.attachments.RestLiAttachmentReaderCallback;
import com.linkedin.restli.common.attachments.RestLiAttachmentReaderException;
import com.linkedin.restli.common.attachments.RestLiDataSourceIterator;
import com.linkedin.restli.common.attachments.RestLiDataSourceIteratorCallback;
import com.linkedin.restli.common.attachments.SingleRestLiAttachmentReaderCallback;

public class RestLiAttachmentReader
implements RestLiDataSourceIterator {
    private final MultiPartMIMEReader _multiPartMIMEReader;

    public RestLiAttachmentReader(MultiPartMIMEReader multiPartMIMEReader) {
        this._multiPartMIMEReader = multiPartMIMEReader;
    }

    public boolean haveAllAttachmentsFinished() {
        return this._multiPartMIMEReader.haveAllPartsFinished();
    }

    public void drainAllAttachments() {
        try {
            this._multiPartMIMEReader.drainAllParts();
        }
        catch (GeneralMultiPartMIMEReaderStreamException readerException) {
            throw new RestLiAttachmentReaderException(readerException);
        }
    }

    public void registerAttachmentReaderCallback(final RestLiAttachmentReaderCallback restLiAttachmentReaderCallback) {
        try {
            this._multiPartMIMEReader.registerReaderCallback(new MultiPartMIMEReaderCallback(){

                public void onNewPart(MultiPartMIMEReader.SinglePartMIMEReader singlePartMIMEReader) {
                    String contentID = (String)singlePartMIMEReader.dataSourceHeaders().get("Content-ID");
                    if (contentID == null) {
                        this.onStreamError((Throwable)new RemoteInvocationException("Illegally formed multipart mime envelope. RestLi attachment is missing the ContentID!"));
                    }
                    restLiAttachmentReaderCallback.onNewAttachment(new SingleRestLiAttachmentReader(singlePartMIMEReader, contentID));
                }

                public void onFinished() {
                    restLiAttachmentReaderCallback.onFinished();
                }

                public void onDrainComplete() {
                    restLiAttachmentReaderCallback.onDrainComplete();
                }

                public void onStreamError(Throwable throwable) {
                    restLiAttachmentReaderCallback.onStreamError(throwable);
                }
            });
        }
        catch (GeneralMultiPartMIMEReaderStreamException readerException) {
            throw new RestLiAttachmentReaderException(readerException);
        }
    }

    @Override
    public void abandonAllDataSources() {
        this._multiPartMIMEReader.abandonAllDataSources();
    }

    @Override
    public void registerDataSourceReaderCallback(final RestLiDataSourceIteratorCallback callback) {
        this.registerAttachmentReaderCallback(new RestLiAttachmentReaderCallback(){

            @Override
            public void onNewAttachment(SingleRestLiAttachmentReader singleRestLiAttachmentReader) {
                callback.onNewDataSourceWriter(singleRestLiAttachmentReader);
            }

            @Override
            public void onFinished() {
                callback.onFinished();
            }

            @Override
            public void onDrainComplete() {
                callback.onAbandonComplete();
            }

            @Override
            public void onStreamError(Throwable throwable) {
                callback.onStreamError(throwable);
            }
        });
    }

    public final class SingleRestLiAttachmentReader
    implements RestLiAttachmentDataSourceWriter {
        private final MultiPartMIMEReader.SinglePartMIMEReader _singlePartMIMEReader;
        private final String _attachmentID;

        SingleRestLiAttachmentReader(MultiPartMIMEReader.SinglePartMIMEReader singlePartMIMEReader, String attachmentID) {
            this._singlePartMIMEReader = singlePartMIMEReader;
            this._attachmentID = attachmentID;
        }

        @Override
        public String getAttachmentID() {
            return this._attachmentID;
        }

        public void requestAttachmentData() {
            try {
                this._singlePartMIMEReader.requestPartData();
            }
            catch (GeneralMultiPartMIMEReaderStreamException readerException) {
                throw new RestLiAttachmentReaderException(readerException);
            }
        }

        public void drainAttachment() {
            try {
                this._singlePartMIMEReader.drainPart();
            }
            catch (GeneralMultiPartMIMEReaderStreamException readerException) {
                throw new RestLiAttachmentReaderException(readerException);
            }
        }

        public void registerCallback(final SingleRestLiAttachmentReaderCallback callback) {
            try {
                this._singlePartMIMEReader.registerReaderCallback(new SinglePartMIMEReaderCallback(){

                    public void onPartDataAvailable(ByteString partData) {
                        callback.onAttachmentDataAvailable(partData);
                    }

                    public void onFinished() {
                        callback.onFinished();
                    }

                    public void onDrainComplete() {
                        callback.onDrainComplete();
                    }

                    public void onStreamError(Throwable throwable) {
                        callback.onAttachmentError(throwable);
                    }
                });
            }
            catch (GeneralMultiPartMIMEReaderStreamException readerException) {
                throw new RestLiAttachmentReaderException(readerException);
            }
        }

        public void onInit(WriteHandle wh) {
            this._singlePartMIMEReader.onInit(wh);
        }

        public void onWritePossible() {
            this._singlePartMIMEReader.onWritePossible();
        }

        public void onAbort(Throwable e) {
            this._singlePartMIMEReader.onAbort(e);
        }
    }
}

