/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.common.ComplexKeySpec;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.KeyValueRecord;
import com.linkedin.restli.common.TypeSpec;
import java.util.Map;

public class KeyValueRecordFactory<K, V extends RecordTemplate> {
    private static final String COMPOUND_KEY_SCHEMA_STRING = "{\n  \"type\": \"record\",\n  \"name\": \"CompoundKeySchema\",\n  \"namespace\": \"com.linkedin.restli.common\",\n  \"fields\": []\n}";
    static final DataSchema COMPOUND_KEY_SCHEMA = DataTemplateUtil.parseSchema((String)"{\n  \"type\": \"record\",\n  \"name\": \"CompoundKeySchema\",\n  \"namespace\": \"com.linkedin.restli.common\",\n  \"fields\": []\n}");
    private final TypeSpec<K> _keyType;
    private final ComplexKeySpec<?, ?> _complexKeyType;
    private final Map<String, CompoundKey.TypeInfo> _fieldTypes;
    private final TypeSpec<V> _valueType;
    private final ResourceKeyType _resourceKeyType;
    RecordDataSchema.Field _keyField;
    RecordDataSchema.Field _paramsField;
    RecordDataSchema.Field _valueField;

    public KeyValueRecordFactory(Class<K> keyClass, Class<? extends RecordTemplate> keyKeyClass, Class<? extends RecordTemplate> keyParamsClass, Map<String, CompoundKey.TypeInfo> fieldTypes, Class<V> valueClass) {
        this(TypeSpec.forClassMaybeNull(keyClass), ComplexKeySpec.forClassesMaybeNull(keyKeyClass, keyParamsClass), fieldTypes, TypeSpec.forClassMaybeNull(valueClass));
    }

    public KeyValueRecordFactory(TypeSpec<K> keyType, ComplexKeySpec<?, ?> complexKeyType, Map<String, CompoundKey.TypeInfo> fieldTypes, TypeSpec<V> valueType) {
        this._keyType = keyType;
        this._complexKeyType = complexKeyType;
        this._valueType = valueType;
        this._fieldTypes = fieldTypes;
        this._resourceKeyType = this.getResourceKeyType(this._keyType.getType());
        StringBuilder sb = new StringBuilder(10);
        switch (this._resourceKeyType) {
            case PRIMITIVE: {
                this._keyField = new RecordDataSchema.Field(this._keyType.getSchema());
                this._keyField.setName("key", sb);
                break;
            }
            case COMPLEX: {
                this._keyField = new RecordDataSchema.Field(this._complexKeyType.getKeyType().getSchema());
                this._keyField.setName("key", sb);
                this._paramsField = new RecordDataSchema.Field(this._complexKeyType.getParamsType().getSchema());
                this._paramsField.setName("$params", sb);
                break;
            }
            case COMPOUND: {
                if (this._fieldTypes == null) {
                    throw new IllegalArgumentException("Must specify field types for a CompoundKey!");
                }
                this._keyField = new RecordDataSchema.Field(COMPOUND_KEY_SCHEMA);
                this._keyField.setName("key", sb);
            }
        }
        this._valueField = new RecordDataSchema.Field(this._valueType.getSchema());
        this._valueField.setName("value", sb);
    }

    private ResourceKeyType getResourceKeyType(Class<?> type) {
        if (CompoundKey.class.isAssignableFrom(type)) {
            return ResourceKeyType.COMPOUND;
        }
        if (type.equals(ComplexResourceKey.class)) {
            return ResourceKeyType.COMPLEX;
        }
        return ResourceKeyType.PRIMITIVE;
    }

    public KeyValueRecord<K, V> create(K key, V value) {
        KeyValueRecord<K, V> keyValueRecord = new KeyValueRecord<K, V>();
        switch (this._resourceKeyType) {
            case PRIMITIVE: {
                keyValueRecord.setPrimitiveKey(this._keyField, key, this._keyType);
                break;
            }
            case COMPLEX: {
                keyValueRecord.setComplexKey(this._keyField, this._paramsField, key, this._complexKeyType);
                break;
            }
            case COMPOUND: {
                keyValueRecord.setCompoundKey(this._keyField, key, this._fieldTypes);
            }
        }
        keyValueRecord.setValue(this._valueField, value, this._valueType.getType());
        return keyValueRecord;
    }

    private static enum ResourceKeyType {
        PRIMITIVE,
        COMPLEX,
        COMPOUND;

    }
}

