/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.annotation.Alias;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassAliasResolver<T> {
    private static final Logger log = LoggerFactory.getLogger(ClassAliasResolver.class);
    private static final Reflections REFLECTIONS = new Reflections((Configuration)new ConfigurationBuilder().forPackages(new String[]{"gobblin", "com.linkedin.gobblin", "org.apache.gobblin"}));
    Map<String, Class<? extends T>> aliasToClassCache;
    private final List<Alias> aliasObjects;
    private final Class<T> subtypeOf;

    public ClassAliasResolver(Class<T> subTypeOf) {
        HashMap cache = Maps.newHashMap();
        this.aliasObjects = Lists.newArrayList();
        for (Class clazz : REFLECTIONS.getSubTypesOf(subTypeOf)) {
            if (!clazz.isAnnotationPresent(Alias.class)) continue;
            Alias aliasObject = clazz.getAnnotation(Alias.class);
            String alias = aliasObject.value().toUpperCase();
            if (cache.containsKey(alias)) {
                log.warn(String.format("Alias %s already mapped to class %s. Mapping for %s will be ignored", alias, ((Class)cache.get(alias)).getCanonicalName(), clazz.getCanonicalName()));
                continue;
            }
            this.aliasObjects.add(aliasObject);
            cache.put(clazz.getAnnotation(Alias.class).value().toUpperCase(), clazz);
        }
        this.subtypeOf = subTypeOf;
        this.aliasToClassCache = ImmutableMap.copyOf((Map)cache);
    }

    public String resolve(String possibleAlias) {
        if (this.aliasToClassCache.containsKey(possibleAlias.toUpperCase())) {
            return this.aliasToClassCache.get(possibleAlias.toUpperCase()).getName();
        }
        return possibleAlias;
    }

    public Class<? extends T> resolveClass(String aliasOrClassName) throws ClassNotFoundException {
        if (this.aliasToClassCache.containsKey(aliasOrClassName.toUpperCase())) {
            return this.aliasToClassCache.get(aliasOrClassName.toUpperCase());
        }
        try {
            return Class.forName(aliasOrClassName).asSubclass(this.subtypeOf);
        }
        catch (ClassCastException cce) {
            throw new ClassNotFoundException(String.format("Found class %s but it cannot be cast to %s.", aliasOrClassName, this.subtypeOf.getName()), cce);
        }
    }

    public Map<String, Class<? extends T>> getAliasMap() {
        return ImmutableMap.copyOf(this.aliasToClassCache);
    }

    public List<Alias> getAliasObjects() {
        return ImmutableList.copyOf(this.aliasObjects);
    }
}

