/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.retry;

import java.util.concurrent.CancellationException;
import java.util.function.Function;

public enum ErrorClassification {
    UNRECOVERABLE,
    RECOVERABLE;

    public static final Function<Throwable, ErrorClassification> DEFAULT;

    protected static boolean nonFatal(Throwable throwable) {
        return throwable instanceof StackOverflowError || !(throwable instanceof VirtualMachineError) && !(throwable instanceof ThreadDeath) && !(throwable instanceof InterruptedException) && !(throwable instanceof LinkageError) && !(throwable instanceof CancellationException);
    }

    static {
        DEFAULT = throwable -> ErrorClassification.nonFatal(throwable) ? RECOVERABLE : UNRECOVERABLE;
    }
}

