/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.promise;

import com.linkedin.parseq.function.Failure;
import com.linkedin.parseq.function.Success;
import com.linkedin.parseq.function.Try;
import com.linkedin.parseq.promise.Promise;
import com.linkedin.parseq.promise.PromiseTransformer;
import com.linkedin.parseq.promise.ResolvedError;
import com.linkedin.parseq.promise.ResolvedValue;
import com.linkedin.parseq.promise.Settable;
import com.linkedin.parseq.promise.SettablePromise;
import com.linkedin.parseq.promise.SettablePromiseImpl;
import com.linkedin.parseq.promise.TransformingPromiseListener;

public class Promises {
    public static final Promise<Void> VOID = Promises.value(null);

    private Promises() {
    }

    public static <T> Promise<T> value(T value) {
        if (value == null) {
            if (VOID == null) {
                return new ResolvedValue<T>(value);
            }
            return VOID;
        }
        return new ResolvedValue<T>(value);
    }

    public static <T> Promise<T> error(Throwable error) {
        return new ResolvedError(error);
    }

    public static <T> SettablePromise<T> settable() {
        return new SettablePromiseImpl();
    }

    public static <T> void propagateResult(Promise<T> source, Settable<T> dest) {
        source.addListener(new TransformingPromiseListener(dest, PromiseTransformer.identity()));
    }

    public static <T> void propagateResult(Promise<T> source, SettablePromise<T> dest) {
        Promises.propagateResult(source, dest);
    }

    public static <T> Try<T> toTry(Promise<T> promise) {
        if (promise.isFailed()) {
            return Failure.of(promise.getError());
        }
        return Success.of(promise.get());
    }
}

