/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.promise;

import com.linkedin.parseq.promise.Promise;
import com.linkedin.parseq.promise.PromiseListener;
import com.linkedin.parseq.promise.PromiseResolvedException;
import com.linkedin.parseq.promise.SettablePromise;
import java.util.concurrent.atomic.AtomicInteger;

public class FastFailCountDownPromiseListener<T>
implements PromiseListener<T> {
    private final AtomicInteger _counter;
    private final SettablePromise<T> _promise;
    private final T _value;

    public FastFailCountDownPromiseListener(int count, SettablePromise<T> promise, T value) {
        this._counter = new AtomicInteger(count);
        this._promise = promise;
        this._value = value;
    }

    @Override
    public void onResolved(Promise<T> resolvedPromise) {
        if (resolvedPromise.isFailed() && !this._promise.isDone()) {
            try {
                this._promise.fail(resolvedPromise.getError());
            }
            catch (PromiseResolvedException promiseResolvedException) {
                // empty catch block
            }
        }
        if (this._counter.decrementAndGet() == 0 && !this._promise.isDone()) {
            try {
                this._promise.done(this._value);
            }
            catch (PromiseResolvedException promiseResolvedException) {
                // empty catch block
            }
        }
    }
}

