/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.internal;

import java.util.ArrayDeque;
import java.util.Deque;

public class Continuations {
    private final ThreadLocal<Continuation> CONTINUATION = new ThreadLocal<Continuation>(){

        @Override
        protected Continuation initialValue() {
            return new Continuation();
        }
    };

    public void submit(Runnable action) {
        this.CONTINUATION.get().submit(action);
    }

    private static final class Continuation {
        private final Deque<Runnable> _siblingActions = new ArrayDeque<Runnable>();
        private final Deque<Runnable> _preOrderExecutionStack = new ArrayDeque<Runnable>();
        private boolean _inLoop = false;

        private Continuation() {
        }

        private void submit(Runnable action) {
            if (!this._inLoop) {
                this._preOrderExecutionStack.push(action);
                this.loop();
            } else {
                this._siblingActions.push(action);
            }
        }

        private void loop() {
            this._inLoop = true;
            try {
                do {
                    this._preOrderExecutionStack.pop().run();
                    while (this._siblingActions.size() > 0) {
                        this._preOrderExecutionStack.push(this._siblingActions.pop());
                    }
                } while (this._preOrderExecutionStack.size() > 0);
            }
            finally {
                this._preOrderExecutionStack.clear();
                this._siblingActions.clear();
                this._inLoop = false;
            }
        }
    }
}

