/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.internal;

import com.linkedin.parseq.After;
import com.linkedin.parseq.Cancellable;
import com.linkedin.parseq.Context;
import com.linkedin.parseq.Exceptions;
import com.linkedin.parseq.Task;
import com.linkedin.parseq.internal.InternalUtil;
import com.linkedin.parseq.internal.PlanContext;
import com.linkedin.parseq.internal.PrioritizableRunnable;
import com.linkedin.parseq.internal.TaskLogger;
import com.linkedin.parseq.promise.Promise;
import com.linkedin.parseq.promise.PromiseListener;
import com.linkedin.parseq.trace.ShallowTraceBuilder;
import com.linkedin.parseq.trace.TraceBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class ContextImpl
implements Context,
Cancellable {
    private static final Task<?> NO_PARENT = null;
    private static final List<Task<?>> NO_PREDECESSORS = Collections.emptyList();
    private final PlanContext _planContext;
    private final Task<Object> _task;
    private static final ThreadLocal<Task<?>> _inTask = new ThreadLocal();
    private final Task<?> _parent;
    private final List<Task<?>> _predecessorTasks;
    private final ConcurrentLinkedQueue<Cancellable> _cancellables = new ConcurrentLinkedQueue();

    public ContextImpl(PlanContext planContext, Task<?> task) {
        this(planContext, task, NO_PARENT, NO_PREDECESSORS);
    }

    private ContextImpl(PlanContext planContext, Task<?> task, Task<?> parent, List<Task<?>> predecessorTasks) {
        this._planContext = planContext;
        this._task = InternalUtil.unwildcardTask(task);
        this._parent = parent;
        this._predecessorTasks = predecessorTasks;
    }

    public void runTask() {
        this._task.addListener(new PromiseListener<Object>(){

            @Override
            public void onResolved(Promise<Object> resolvedPromise) {
                Iterator it = ContextImpl.this._cancellables.iterator();
                while (it.hasNext()) {
                    Cancellable cancellable = (Cancellable)it.next();
                    cancellable.cancel(Exceptions.EARLY_FINISH_EXCEPTION);
                    it.remove();
                }
            }
        });
        this._planContext.execute(new PrioritizableRunnable(){

            @Override
            public void run() {
                _inTask.set(ContextImpl.this._task);
                try {
                    ContextImpl.this._task.contextRun(ContextImpl.this, ContextImpl.this._parent, ContextImpl.this._predecessorTasks);
                }
                finally {
                    _inTask.remove();
                }
            }

            @Override
            public int getPriority() {
                return ContextImpl.this._task.getPriority();
            }
        });
    }

    @Override
    public Cancellable createTimer(long time, TimeUnit unit, final Task<?> task) {
        this.checkInTask();
        Cancellable cancellable = this._planContext.schedule(time, unit, new Runnable(){

            @Override
            public void run() {
                ContextImpl.this.runSubTask(task, NO_PREDECESSORS);
            }
        });
        this._cancellables.add(cancellable);
        return cancellable;
    }

    @Override
    public void run(Task<?> ... tasks) {
        this.checkInTask();
        for (Task<?> task : tasks) {
            this.runSubTask(task, NO_PREDECESSORS);
        }
    }

    @Override
    public void runSideEffect(Task<?> ... tasks) {
        this.checkInTask();
        for (Task<?> task : tasks) {
            this.runSideEffectSubTask(task, NO_PREDECESSORS);
        }
    }

    @Override
    public After after(final Promise<?> ... promises) {
        this.checkInTask();
        ArrayList<Task> tmpPredecessorTasks = new ArrayList<Task>();
        for (Promise<?> promise : promises) {
            if (!(promise instanceof Task)) continue;
            tmpPredecessorTasks.add((Task)promise);
        }
        final List predecessorTasks = Collections.unmodifiableList(tmpPredecessorTasks);
        return new After(){

            @Override
            public void run(final Task<?> task) {
                InternalUtil.after(new PromiseListener<Object>(){

                    @Override
                    public void onResolved(Promise<Object> resolvedPromise) {
                        ContextImpl.this.runSubTask(task, predecessorTasks);
                    }
                }, promises);
            }

            @Override
            public void run(final Supplier<Task<?>> taskSupplier) {
                InternalUtil.after(new PromiseListener<Object>(){

                    @Override
                    public void onResolved(Promise<Object> resolvedPromise) {
                        Task task = (Task)taskSupplier.get();
                        if (task != null) {
                            ContextImpl.this.runSubTask(task, predecessorTasks);
                        }
                    }
                }, promises);
            }
        };
    }

    @Override
    public boolean cancel(Exception reason) {
        boolean result = this._task.cancel(reason);
        this._task.contextRun(this, this._parent, this._predecessorTasks);
        return result;
    }

    @Override
    public Object getEngineProperty(String key) {
        return this._planContext.getEngineProperty(key);
    }

    private ContextImpl createSubContext(Task<?> task, List<Task<?>> predecessors) {
        return new ContextImpl(this._planContext, task, this._task, predecessors);
    }

    private void runSubTask(Task<?> task, List<Task<?>> predecessors) {
        ContextImpl subContext = this.createSubContext(task, predecessors);
        if (!this.isDone()) {
            this._cancellables.add(subContext);
            subContext.runTask();
        } else {
            subContext.cancel(Exceptions.EARLY_FINISH_EXCEPTION);
        }
    }

    private void runSideEffectSubTask(Task<?> taskWrapper, List<Task<?>> predecessors) {
        PlanContext subPlan = this._planContext.fork(taskWrapper);
        if (subPlan != null) {
            new ContextImpl(subPlan, taskWrapper, this._task, predecessors).runTask();
        } else {
            taskWrapper.cancel(new IllegalStateException("Plan is already completed"));
        }
    }

    private boolean isDone() {
        return this._task.isDone();
    }

    private void checkInTask() {
        Task<?> t = _inTask.get();
        if (t != this._task) {
            throw new IllegalStateException("Context method invoked while not in context's task");
        }
    }

    @Override
    public TraceBuilder getTraceBuilder() {
        return this._planContext.getRelationshipsBuilder();
    }

    @Override
    public ShallowTraceBuilder getShallowTraceBuilder() {
        return this._task.getShallowTraceBuilder();
    }

    @Override
    public Long getPlanId() {
        return this._planContext.getId();
    }

    @Override
    public Long getTaskId() {
        return this._task.getId();
    }

    @Override
    public TaskLogger getTaskLogger() {
        return this._planContext.getTaskLogger();
    }

    @Override
    public String getPlanClass() {
        return this._planContext.getPlanClass();
    }
}

