/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.ClientConstants;
import com.microsoft.azure.servicebus.RetryExponential;
import com.microsoft.azure.servicebus.ServerBusyException;
import com.microsoft.azure.servicebus.ServiceBusException;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;

public abstract class RetryPolicy {
    private static final RetryPolicy NO_RETRY = new RetryExponential(Duration.ofSeconds(0L), Duration.ofSeconds(0L), 0, "NoRetry");
    private final String name;
    private ConcurrentHashMap<String, Integer> retryCounts;
    private Object serverBusySync;

    protected RetryPolicy(String name) {
        this.name = name;
        this.retryCounts = new ConcurrentHashMap();
        this.serverBusySync = new Object();
    }

    public void incrementRetryCount(String clientId) {
        Integer retryCount = this.retryCounts.get(clientId);
        this.retryCounts.put(clientId, retryCount == null ? 1 : retryCount + 1);
    }

    public void resetRetryCount(String clientId) {
        Integer currentRetryCount = this.retryCounts.get(clientId);
        if (currentRetryCount != null && currentRetryCount != 0) {
            this.retryCounts.put(clientId, 0);
        }
    }

    public static boolean isRetryableException(Exception exception) {
        if (exception == null) {
            throw new IllegalArgumentException("exception cannot be null");
        }
        if (exception instanceof ServiceBusException) {
            return ((ServiceBusException)exception).getIsTransient();
        }
        return false;
    }

    public static RetryPolicy getDefault() {
        return new RetryExponential(ClientConstants.DEFAULT_RERTRY_MIN_BACKOFF, ClientConstants.DEFAULT_RERTRY_MAX_BACKOFF, 10, "Default");
    }

    public static RetryPolicy getNoRetry() {
        return NO_RETRY;
    }

    protected int getRetryCount(String clientId) {
        Integer retryCount = this.retryCounts.get(clientId);
        return retryCount == null ? 0 : retryCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Duration getNextRetryInterval(String clientId, Exception lastException, Duration remainingTime) {
        int baseWaitTime = 0;
        Object object = this.serverBusySync;
        synchronized (object) {
            if (lastException != null && (lastException instanceof ServerBusyException || lastException.getCause() != null && lastException.getCause() instanceof ServerBusyException)) {
                baseWaitTime += 4;
            }
        }
        return this.onGetNextRetryInterval(clientId, lastException, remainingTime, baseWaitTime);
    }

    protected abstract Duration onGetNextRetryInterval(String var1, Exception var2, Duration var3, int var4);

    public String toString() {
        return this.name;
    }
}

