/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.EventDataUtil;
import com.microsoft.azure.eventhubs.PartitionReceiveHandler;
import com.microsoft.azure.eventhubs.ReceivePump;
import com.microsoft.azure.servicebus.ClientEntity;
import com.microsoft.azure.servicebus.MessageReceiver;
import com.microsoft.azure.servicebus.MessagingFactory;
import com.microsoft.azure.servicebus.ServiceBusException;
import com.microsoft.azure.servicebus.StringUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.qpid.proton.message.Message;

public final class PartitionReceiver
extends ClientEntity {
    private static final int MINIMUM_PREFETCH_COUNT = 10;
    private static final int MAXIMUM_PREFETCH_COUNT = 999;
    static final int DEFAULT_PREFETCH_COUNT = 999;
    static final long NULL_EPOCH = 0L;
    public static final String START_OF_STREAM = "-1";
    private final String partitionId;
    private final MessagingFactory underlyingFactory;
    private final String eventHubName;
    private final String consumerGroupName;
    private final Object receiveHandlerLock;
    private String startingOffset;
    private boolean offsetInclusive;
    private Instant startingDateTime;
    private MessageReceiver internalReceiver;
    private Long epoch;
    private boolean isEpochReceiver;
    private ReceivePump receivePump;

    private PartitionReceiver(MessagingFactory factory, String eventHubName, String consumerGroupName, String partitionId, String startingOffset, boolean offsetInclusive, Instant dateTime, Long epoch, boolean isEpochReceiver) throws ServiceBusException {
        super(null, null);
        this.underlyingFactory = factory;
        this.eventHubName = eventHubName;
        this.consumerGroupName = consumerGroupName;
        this.partitionId = partitionId;
        this.startingOffset = startingOffset;
        this.offsetInclusive = offsetInclusive;
        this.startingDateTime = dateTime;
        this.epoch = epoch;
        this.isEpochReceiver = isEpochReceiver;
        this.receiveHandlerLock = new Object();
    }

    static CompletableFuture<PartitionReceiver> create(MessagingFactory factory, String eventHubName, String consumerGroupName, String partitionId, String startingOffset, boolean offsetInclusive, Instant dateTime, long epoch, boolean isEpochReceiver) throws ServiceBusException {
        if (epoch < 0L) {
            throw new IllegalArgumentException("epoch cannot be a negative value. Please specify a zero or positive long value.");
        }
        if (StringUtil.isNullOrWhiteSpace(consumerGroupName)) {
            throw new IllegalArgumentException("specify valid string for argument - 'consumerGroupName'");
        }
        final PartitionReceiver receiver = new PartitionReceiver(factory, eventHubName, consumerGroupName, partitionId, startingOffset, offsetInclusive, dateTime, epoch, isEpochReceiver);
        return receiver.createInternalReceiver().thenApplyAsync(new Function<Void, PartitionReceiver>(){

            @Override
            public PartitionReceiver apply(Void a) {
                return receiver;
            }
        });
    }

    private CompletableFuture<Void> createInternalReceiver() throws ServiceBusException {
        return MessageReceiver.create(this.underlyingFactory, StringUtil.getRandomString(), String.format("%s/ConsumerGroups/%s/Partitions/%s", this.eventHubName, this.consumerGroupName, this.partitionId), this.startingOffset, this.offsetInclusive, this.startingDateTime, 999, this.epoch, this.isEpochReceiver).thenAcceptAsync((Consumer)new Consumer<MessageReceiver>(){

            @Override
            public void accept(MessageReceiver r) {
                PartitionReceiver.this.internalReceiver = r;
            }
        });
    }

    final String getStartingOffset() {
        return this.startingOffset;
    }

    final boolean getOffsetInclusive() {
        return this.offsetInclusive;
    }

    public final String getPartitionId() {
        return this.partitionId;
    }

    public final int getPrefetchCount() {
        return this.internalReceiver.getPrefetchCount();
    }

    public final Duration getReceiveTimeout() {
        return this.internalReceiver.getReceiveTimeout();
    }

    public void setReceiveTimeout(Duration value) {
        this.internalReceiver.setReceiveTimeout(value);
    }

    public final void setPrefetchCount(int prefetchCount) throws ServiceBusException {
        if (prefetchCount < 10 || prefetchCount > 999) {
            throw new IllegalArgumentException(String.format(Locale.US, "PrefetchCount has to be between %s and %s", 10, 999));
        }
        this.internalReceiver.setPrefetchCount(prefetchCount);
    }

    public final long getEpoch() {
        return this.epoch;
    }

    public final Iterable<EventData> receiveSync(int maxEventCount) throws ServiceBusException {
        try {
            return this.receive(maxEventCount).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            Throwable throwable;
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if ((throwable = exception.getCause()) != null) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ServiceBusException) {
                    throw (ServiceBusException)throwable;
                }
                throw new ServiceBusException(true, throwable);
            }
            return null;
        }
    }

    public CompletableFuture<Iterable<EventData>> receive(int maxEventCount) {
        return this.internalReceiver.receive(maxEventCount).thenApply(new Function<Collection<Message>, Iterable<EventData>>(){

            @Override
            public Iterable<EventData> apply(Collection<Message> amqpMessages) {
                return EventDataUtil.toEventDataCollection(amqpMessages);
            }
        });
    }

    public CompletableFuture<Void> setReceiveHandler(PartitionReceiveHandler receiveHandler) {
        return this.setReceiveHandler(receiveHandler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> setReceiveHandler(PartitionReceiveHandler receiveHandler, boolean invokeWhenNoEvents) {
        Object object = this.receiveHandlerLock;
        synchronized (object) {
            if (receiveHandler == null) {
                if (this.receivePump != null && this.receivePump.isRunning()) {
                    return this.receivePump.stop();
                }
            } else {
                if (this.receivePump != null && this.receivePump.isRunning()) {
                    throw new IllegalArgumentException("Unexpected value for parameter 'receiveHandler'. PartitionReceiver was already registered with a PartitionReceiveHandler instance. Only 1 instance can be registered.");
                }
                this.receivePump = new ReceivePump(new ReceivePump.IPartitionReceiver(){

                    @Override
                    public Iterable<EventData> receive(int maxBatchSize) throws ServiceBusException {
                        return PartitionReceiver.this.receiveSync(maxBatchSize);
                    }

                    @Override
                    public String getPartitionId() {
                        return PartitionReceiver.this.getPartitionId();
                    }
                }, receiveHandler, invokeWhenNoEvents);
                Thread onReceivePumpThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        PartitionReceiver.this.receivePump.run();
                    }
                });
                onReceivePumpThread.start();
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    @Override
    public CompletableFuture<Void> onClose() {
        if (this.receivePump != null && this.receivePump.isRunning()) {
            this.receivePump.stop();
        }
        if (this.internalReceiver != null) {
            return this.internalReceiver.close();
        }
        return CompletableFuture.completedFuture(null);
    }
}

