/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.std;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.api.JobCatalogListenersContainer;
import org.apache.gobblin.runtime.api.JobExecutionDriver;
import org.apache.gobblin.runtime.api.JobExecutionState;
import org.apache.gobblin.runtime.api.JobExecutionStateListener;
import org.apache.gobblin.runtime.api.JobLifecycleListener;
import org.apache.gobblin.runtime.api.JobLifecycleListenersContainer;
import org.apache.gobblin.runtime.api.JobSpecSchedulerListenersContainer;
import org.apache.gobblin.util.callbacks.CallbacksDispatcher;
import org.slf4j.Logger;

public class JobLifecycleListenersList
implements JobLifecycleListenersContainer,
Closeable {
    private final CallbacksDispatcher<JobLifecycleListener> _dispatcher;
    private final JobCatalogListenersContainer _jobCatalogDelegate;
    private final JobSpecSchedulerListenersContainer _jobSchedulerDelegate;

    public JobLifecycleListenersList(JobCatalogListenersContainer jobCatalogDelegate, JobSpecSchedulerListenersContainer jobSchedulerDelegate, Optional<ExecutorService> execService, Optional<Logger> log) {
        this._dispatcher = new CallbacksDispatcher(execService, log);
        this._jobCatalogDelegate = jobCatalogDelegate;
        this._jobSchedulerDelegate = jobSchedulerDelegate;
    }

    public JobLifecycleListenersList(JobCatalogListenersContainer jobCatalogDelegate, JobSpecSchedulerListenersContainer jobSchedulerDelegate, Logger log) {
        this(jobCatalogDelegate, jobSchedulerDelegate, (Optional<ExecutorService>)Optional.absent(), (Optional<Logger>)Optional.of((Object)log));
    }

    public JobLifecycleListenersList(JobCatalogListenersContainer jobCatalogDelegate, JobSpecSchedulerListenersContainer jobSchedulerDelegate) {
        this(jobCatalogDelegate, jobSchedulerDelegate, (Optional<ExecutorService>)Optional.absent(), (Optional<Logger>)Optional.absent());
    }

    @Override
    public void registerJobLifecycleListener(JobLifecycleListener listener) {
        this._dispatcher.addListener((Object)listener);
        this._jobCatalogDelegate.addListener(listener);
        this._jobSchedulerDelegate.registerJobSpecSchedulerListener(listener);
    }

    @Override
    public void unregisterJobLifecycleListener(JobLifecycleListener listener) {
        this._jobSchedulerDelegate.unregisterJobSpecSchedulerListener(listener);
        this._jobCatalogDelegate.removeListener(listener);
        this._dispatcher.removeListener((Object)listener);
    }

    @Override
    public void close() throws IOException {
        this._dispatcher.close();
    }

    @Override
    public List<JobLifecycleListener> getJobLifecycleListeners() {
        return this._dispatcher.getListeners();
    }

    public void onStatusChange(JobExecutionState state, JobState.RunningState previousStatus, JobState.RunningState newStatus) {
        try {
            this._dispatcher.execCallbacks((Function)new JobExecutionStateListener.StatusChangeCallback(state, previousStatus, newStatus));
        }
        catch (InterruptedException e) {
            this._dispatcher.getLog().warn("onStatusChange interrupted.");
        }
    }

    public void onStageTransition(JobExecutionState state, String previousStage, String newStage) {
        try {
            this._dispatcher.execCallbacks((Function)new JobExecutionStateListener.StageTransitionCallback(state, previousStage, newStage));
        }
        catch (InterruptedException e) {
            this._dispatcher.getLog().warn("onStageTransition interrupted.");
        }
    }

    public void onMetadataChange(JobExecutionState state, String key, Object oldValue, Object newValue) {
        try {
            this._dispatcher.execCallbacks((Function)new JobExecutionStateListener.MetadataChangeCallback(state, key, oldValue, newValue));
        }
        catch (InterruptedException e) {
            this._dispatcher.getLog().warn("onMetadataChange interrupted.");
        }
    }

    public void onJobLaunch(JobExecutionDriver driver) {
        try {
            this._dispatcher.execCallbacks((Function)new JobLifecycleListener.JobLaunchCallback(driver));
        }
        catch (InterruptedException e) {
            this._dispatcher.getLog().warn("onJobLaunch interrupted.");
        }
    }

    @Override
    public void registerWeakJobLifecycleListener(JobLifecycleListener listener) {
        this._dispatcher.addWeakListener((Object)listener);
        this._jobCatalogDelegate.registerWeakJobCatalogListener(listener);
        this._jobSchedulerDelegate.registerWeakJobSpecSchedulerListener(listener);
    }
}

