/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.std;

import com.google.common.base.Optional;
import java.net.URI;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.api.JobExecutionDriver;
import org.apache.gobblin.runtime.api.JobExecutionState;
import org.apache.gobblin.runtime.api.JobLifecycleListener;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.JobSpecSchedule;
import org.slf4j.Logger;

public class DefaultJobLifecycleListenerImpl
implements JobLifecycleListener {
    protected final Optional<Logger> _log;

    public DefaultJobLifecycleListenerImpl(Optional<Logger> log) {
        this._log = log;
    }

    public DefaultJobLifecycleListenerImpl(Logger log) {
        this((Optional<Logger>)Optional.of((Object)log));
    }

    public DefaultJobLifecycleListenerImpl() {
        this((Optional<Logger>)Optional.absent());
    }

    @Override
    public void onAddJob(JobSpec addedJob) {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("New JobSpec detected: " + addedJob.toShortString());
        }
    }

    @Override
    public void onDeleteJob(URI deletedJobURI, String deletedJobVersion) {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("JobSpec deleted: " + deletedJobURI + "/" + deletedJobVersion);
        }
    }

    @Override
    public void onUpdateJob(JobSpec updatedJob) {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("JobSpec changed: " + updatedJob.toShortString());
        }
    }

    @Override
    public void onStatusChange(JobExecutionState state, JobState.RunningState previousStatus, JobState.RunningState newStatus) {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("JobExection status change for " + state.getJobSpec().toShortString() + ": " + (Object)((Object)previousStatus) + " --> " + (Object)((Object)newStatus));
        }
    }

    @Override
    public void onStageTransition(JobExecutionState state, String previousStage, String newStage) {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("JobExection stage change for " + state.getJobSpec().toShortString() + ": " + previousStage + " --> " + newStage);
        }
    }

    @Override
    public void onMetadataChange(JobExecutionState state, String key, Object oldValue, Object newValue) {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("JobExection metadata change for " + state.getJobSpec().toShortString() + key + ": '" + oldValue + "' --> '" + newValue + "'");
        }
    }

    @Override
    public void onJobScheduled(JobSpecSchedule jobSchedule) {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("job scheduled: " + jobSchedule);
        }
    }

    @Override
    public void onJobUnscheduled(JobSpecSchedule jobSchedule) {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("job unscheduled: " + jobSchedule);
        }
    }

    @Override
    public void onJobTriggered(JobSpec jobSpec) {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("job triggered: " + jobSpec);
        }
    }

    @Override
    public void onJobLaunch(JobExecutionDriver jobDriver) {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("job launched: " + jobDriver);
        }
    }
}

