/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.spec_catalog;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecCatalogListener;
import org.apache.gobblin.runtime.api.SpecCatalogListenersContainer;
import org.apache.gobblin.util.callbacks.CallbacksDispatcher;
import org.slf4j.Logger;

public class SpecCatalogListenersList
implements SpecCatalogListener,
SpecCatalogListenersContainer,
Closeable {
    private final CallbacksDispatcher<SpecCatalogListener> _disp;

    public SpecCatalogListenersList() {
        this((Optional<Logger>)Optional.absent());
    }

    public SpecCatalogListenersList(Optional<Logger> log) {
        this._disp = new CallbacksDispatcher(Optional.absent(), log);
    }

    public Logger getLog() {
        return this._disp.getLog();
    }

    public synchronized List<SpecCatalogListener> getListeners() {
        return this._disp.getListeners();
    }

    @Override
    public synchronized void addListener(SpecCatalogListener newListener) {
        this._disp.addListener((Object)newListener);
    }

    @Override
    public synchronized void removeListener(SpecCatalogListener oldListener) {
        this._disp.removeListener((Object)oldListener);
    }

    @Override
    public synchronized void onAddSpec(Spec addedSpec) {
        Preconditions.checkNotNull((Object)addedSpec);
        try {
            this._disp.execCallbacks((Function)new SpecCatalogListener.AddSpecCallback(addedSpec));
        }
        catch (InterruptedException e) {
            this.getLog().warn("onAddSpec interrupted.");
        }
    }

    @Override
    public synchronized void onDeleteSpec(URI deletedSpecURI, String deletedSpecVersion) {
        Preconditions.checkNotNull((Object)deletedSpecURI);
        try {
            this._disp.execCallbacks((Function)new SpecCatalogListener.DeleteSpecCallback(deletedSpecURI, deletedSpecVersion));
        }
        catch (InterruptedException e) {
            this.getLog().warn("onDeleteSpec interrupted.");
        }
    }

    @Override
    public synchronized void onUpdateSpec(Spec updatedSpec) {
        Preconditions.checkNotNull((Object)updatedSpec);
        try {
            this._disp.execCallbacks((Function)new SpecCatalogListener.UpdateSpecCallback(updatedSpec));
        }
        catch (InterruptedException e) {
            this.getLog().warn("onUpdateSpec interrupted.");
        }
    }

    @Override
    public void close() throws IOException {
        this._disp.close();
    }

    public void callbackOneListener(Function<SpecCatalogListener, Void> callback, SpecCatalogListener listener) {
        try {
            this._disp.execCallbacks(callback, (Object)listener);
        }
        catch (InterruptedException e) {
            this.getLog().warn("callback interrupted: " + callback);
        }
    }

    @Override
    public void registerWeakSpecCatalogListener(SpecCatalogListener specListener) {
        this._disp.addWeakListener((Object)specListener);
    }
}

