/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.metastore.filesystem;

import java.io.IOException;
import org.apache.gobblin.metastore.DatasetStateStore;
import org.apache.gobblin.metastore.metadata.DatasetStateStoreEntryManager;
import org.apache.gobblin.runtime.FsDatasetStateStore;
import org.apache.gobblin.runtime.JobState;
import org.apache.hadoop.fs.FileStatus;

public class FsDatasetStateStoreEntryManager
extends DatasetStateStoreEntryManager<JobState.DatasetState> {
    private final FsDatasetStateStore stateStore;

    public FsDatasetStateStoreEntryManager(FileStatus fileStatus, FsDatasetStateStore stateStore) {
        super(fileStatus.getPath().getParent().getName(), fileStatus.getPath().getName(), fileStatus.getModificationTime(), new DatasetStateStore.TableNameParser(fileStatus.getPath().getName()), (DatasetStateStore)stateStore);
        this.stateStore = stateStore;
    }

    public JobState.DatasetState readState() throws IOException {
        return this.stateStore.getInternal(this.getStoreName(), this.getTableName(), this.getSanitizedDatasetUrn(), true);
    }

    public void delete() throws IOException {
        this.stateStore.delete(this.getStoreName(), this.getTableName());
    }
}

