/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.listeners;

import com.google.common.base.Optional;
import org.apache.gobblin.runtime.JobContext;
import org.apache.gobblin.runtime.listeners.JobListener;
import org.slf4j.Logger;

public abstract class AbstractJobListener
implements JobListener {
    private final Optional<Logger> _log;

    public AbstractJobListener(Optional<Logger> log) {
        this._log = log;
    }

    public AbstractJobListener() {
        this((Optional<Logger>)Optional.absent());
    }

    @Override
    public void onJobPrepare(JobContext jobContext) throws Exception {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("jobPrepare: " + jobContext);
        }
    }

    @Override
    public void onJobStart(JobContext jobContext) throws Exception {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("jobStart: " + jobContext);
        }
    }

    @Override
    public void onJobCompletion(JobContext jobContext) throws Exception {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("jobCompletion: " + jobContext);
        }
    }

    @Override
    public void onJobCancellation(JobContext jobContext) throws Exception {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("jobCancellation: " + jobContext);
        }
    }

    @Override
    public void onJobFailure(JobContext jobContext) throws Exception {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("jobFailure: " + jobContext);
        }
    }

    protected Optional<Logger> getLog() {
        return this._log;
    }
}

