/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.job_catalog;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Service;
import java.net.URI;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.runtime.api.GobblinInstanceEnvironment;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.MutableJobCatalog;
import org.apache.gobblin.runtime.job_catalog.JobCatalogBase;
import org.slf4j.Logger;

public abstract class MutableJobCatalogBase
extends JobCatalogBase
implements MutableJobCatalog {
    public MutableJobCatalogBase() {
    }

    public MutableJobCatalogBase(Optional<Logger> log) {
        super(log);
    }

    public MutableJobCatalogBase(GobblinInstanceEnvironment env) {
        super(env);
    }

    public MutableJobCatalogBase(Optional<Logger> log, Optional<MetricContext> parentMetricContext, boolean instrumentationEnabled) {
        super(log, parentMetricContext, instrumentationEnabled);
    }

    @Override
    public void put(JobSpec jobSpec) {
        Preconditions.checkState((this.allowMutationsBeforeStartup() || this.state() == Service.State.RUNNING ? 1 : 0) != 0, (Object)String.format("%s is not running.", this.getClass().getName()));
        Preconditions.checkNotNull((Object)jobSpec);
        JobSpec oldSpec = this.doPut(jobSpec);
        if (null == oldSpec) {
            this.listeners.onAddJob(jobSpec);
        } else {
            this.listeners.onUpdateJob(jobSpec);
        }
    }

    protected abstract JobSpec doPut(JobSpec var1);

    @Override
    public void remove(URI uri) {
        Preconditions.checkState((this.state() == Service.State.RUNNING ? 1 : 0) != 0, (Object)String.format("%s is not running.", this.getClass().getName()));
        Preconditions.checkNotNull((Object)uri);
        JobSpec jobSpec = this.doRemove(uri);
        if (null != jobSpec) {
            this.listeners.onDeleteJob(jobSpec.getUri(), jobSpec.getVersion());
        }
    }

    protected abstract JobSpec doRemove(URI var1);

    protected boolean allowMutationsBeforeStartup() {
        return true;
    }
}

