/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValueFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metastore.StateStore;
import org.apache.gobblin.runtime.CheckpointableWatermarkState;
import org.apache.gobblin.source.extractor.CheckpointableWatermark;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.io.GsonInterfaceAdapter;
import org.apache.gobblin.writer.WatermarkStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateStoreBasedWatermarkStorage
implements WatermarkStorage {
    private static final Logger log = LoggerFactory.getLogger(StateStoreBasedWatermarkStorage.class);
    private static final Gson GSON = GsonInterfaceAdapter.getGson(Object.class);
    public static final String WATERMARK_STORAGE_TYPE_KEY = "streaming.watermarkStateStore.type";
    public static final String WATERMARK_STORAGE_TYPE_DEFAULT = "zk";
    public static final String WATERMARK_STORAGE_CONFIG_PREFIX = "streaming.watermarkStateStore.config.";
    private static final String WATERMARK_STORAGE_PREFIX = "streamingWatermarks:";
    public final StateStore<CheckpointableWatermarkState> _stateStore;
    private final String _storeName;

    Config getStateStoreConfig(State state) {
        Properties properties = state.getProperties();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith(WATERMARK_STORAGE_CONFIG_PREFIX)) continue;
            properties.setProperty(key.substring(WATERMARK_STORAGE_CONFIG_PREFIX.length()), (String)properties.get(key));
        }
        Config config = ConfigFactory.parseProperties((Properties)properties);
        if (!config.hasPath("state.store.dir")) {
            config = config.withValue("state.store.dir", ConfigValueFactory.fromAnyRef((Object)"/streamingWatermarks"));
        }
        return config;
    }

    public StateStoreBasedWatermarkStorage(State taskState) {
        StateStore.Factory stateStoreFactory;
        Preconditions.checkArgument((taskState != null ? 1 : 0) != 0);
        Preconditions.checkArgument((!taskState.getProp("job.name").isEmpty() ? 1 : 0) != 0);
        String watermarkStateStoreType = taskState.getProp(WATERMARK_STORAGE_TYPE_KEY, WATERMARK_STORAGE_TYPE_DEFAULT);
        ClassAliasResolver resolver = new ClassAliasResolver(StateStore.Factory.class);
        try {
            stateStoreFactory = (StateStore.Factory)resolver.resolveClass(watermarkStateStoreType).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        Config config = this.getStateStoreConfig(taskState);
        this._stateStore = stateStoreFactory.createStateStore(config, CheckpointableWatermarkState.class);
        this._storeName = WATERMARK_STORAGE_PREFIX + taskState.getProp("job.name");
        log.info("State Store directory configured as : {}", (Object)config.getString("state.store.dir"));
        log.info("Configured the StateStoreBasedWatermarkStorage with storeName: {}", (Object)this._storeName);
    }

    public void commitWatermarks(Iterable<CheckpointableWatermark> watermarks) throws IOException {
        for (CheckpointableWatermark watermark : watermarks) {
            String tableName = watermark.getSource();
            this._stateStore.put(this._storeName, tableName, (State)new CheckpointableWatermarkState(watermark, GSON));
        }
    }

    public Map<String, CheckpointableWatermark> getCommittedWatermarks(Class<? extends CheckpointableWatermark> watermarkClass, Iterable<String> sourcePartitions) throws IOException {
        HashMap<String, CheckpointableWatermark> committed = new HashMap<String, CheckpointableWatermark>();
        for (String sourcePartition : sourcePartitions) {
            CheckpointableWatermarkState watermarkState = (CheckpointableWatermarkState)this._stateStore.get(this._storeName, sourcePartition, sourcePartition);
            if (watermarkState == null) continue;
            CheckpointableWatermark watermark = (CheckpointableWatermark)GSON.fromJson(watermarkState.getProp(sourcePartition), watermarkClass);
            committed.put(sourcePartition, watermark);
        }
        if (committed.isEmpty()) {
            log.warn("Didn't find any committed watermarks");
        }
        return committed;
    }

    Iterable<CheckpointableWatermarkState> getAllCommittedWatermarks() throws IOException {
        return this._stateStore.getAll(this._storeName);
    }
}

