/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.metastore.DatasetStateStore;
import org.apache.gobblin.runtime.FsDatasetStateStore;
import org.apache.gobblin.runtime.JobState;
import org.apache.hadoop.fs.FileSystem;

public class NoopDatasetStateStore
extends FsDatasetStateStore {
    public NoopDatasetStateStore(FileSystem fs, String storeRootDir, Integer threadPoolSize) {
        super(fs, storeRootDir, threadPoolSize);
    }

    public NoopDatasetStateStore(FileSystem fs, String storeRootDir) {
        super(fs, storeRootDir);
    }

    @Override
    public List<JobState.DatasetState> getAll(String storeName, String tableName) throws IOException {
        return Lists.newArrayList();
    }

    @Override
    public List<JobState.DatasetState> getAll(String storeName) throws IOException {
        return Lists.newArrayList();
    }

    @Override
    public Map<String, JobState.DatasetState> getLatestDatasetStatesByUrns(String jobName) throws IOException {
        return Maps.newHashMap();
    }

    @Override
    public void persistDatasetState(String datasetUrn, JobState.DatasetState datasetState) throws IOException {
    }

    public boolean create(String storeName) throws IOException {
        return true;
    }

    public boolean create(String storeName, String tableName) throws IOException {
        return true;
    }

    public boolean exists(String storeName, String tableName) throws IOException {
        return false;
    }

    public void put(String storeName, String tableName, JobState.DatasetState state) throws IOException {
    }

    public void putAll(String storeName, String tableName, Collection<JobState.DatasetState> states) throws IOException {
    }

    public void createAlias(String storeName, String original, String alias) throws IOException {
    }

    public void delete(String storeName, String tableName) throws IOException {
    }

    public void delete(String storeName) throws IOException {
    }

    @Alias(value="noop")
    public static class Factory
    implements DatasetStateStore.Factory {
        public DatasetStateStore<JobState.DatasetState> createStateStore(Config config) {
            Config config2 = config.withValue("state.store.dir", ConfigValueFactory.fromAnyRef((Object)""));
            return FsDatasetStateStore.createStateStore(config2, NoopDatasetStateStore.class.getName());
        }
    }
}

