/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closer;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.gobblin.runtime.TaskState;
import org.apache.gobblin.runtime.util.TaskMetrics;
import org.apache.gobblin.source.extractor.DataRecordException;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.gobblin.util.Decorator;
import org.apache.gobblin.util.limiter.Limiter;

public class LimitingExtractorDecorator<S, D>
implements Extractor<S, D>,
Decorator {
    private final Extractor<S, D> extractor;
    private final Limiter limiter;
    private final TaskState taskState;
    public static final String LIMITER_STOP_EVENT_NAME = "PrematureExtractorStop";
    public static final String LIMITER_STOP_CAUSE_KEY = "limiterStopCause";
    public static final String LIMITER_STOP_CAUSE_VALUE = "LimiterPermitAcquireFailure";
    private EventSubmitter eventSubmitter;

    public LimitingExtractorDecorator(Extractor<S, D> extractor, Limiter limiter, TaskState state) {
        this.extractor = extractor;
        this.limiter = limiter;
        this.taskState = state;
        this.limiter.start();
        this.eventSubmitter = new EventSubmitter.Builder(TaskMetrics.get(this.taskState).getMetricContext(), "gobblin.runtime.task").build();
    }

    public Object getDecoratedObject() {
        return this.extractor;
    }

    public S getSchema() throws IOException {
        return (S)this.extractor.getSchema();
    }

    private ImmutableMap<String, String> getLimiterStopMetadata() {
        WorkUnit workUnit = this.taskState.getWorkunit();
        Properties properties = workUnit.getProperties();
        String metadataKeyList = properties.getProperty("limiter.report.key.list", "");
        List keyList = Splitter.on((char)',').omitEmptyStrings().trimResults().splitToList((CharSequence)metadataKeyList);
        if (keyList.isEmpty()) {
            return ImmutableMap.of();
        }
        Set<String> names = properties.stringPropertyNames();
        TreeMap<String, String> orderedProperties = new TreeMap<String, String>();
        for (String name : names) {
            orderedProperties.put(name, properties.getProperty(name));
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String oldKey : keyList) {
            builder.putAll(orderedProperties.subMap(oldKey, oldKey + '\uffff'));
        }
        builder.put((Object)LIMITER_STOP_CAUSE_KEY, (Object)LIMITER_STOP_CAUSE_VALUE);
        return builder.build();
    }

    private void submitLimiterStopMetadataEvents() {
        ImmutableMap<String, String> metaData = this.getLimiterStopMetadata();
        if (!metaData.isEmpty()) {
            this.eventSubmitter.submit(LIMITER_STOP_EVENT_NAME, metaData);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public D readRecord(@Deprecated D reuse) throws DataRecordException, IOException {
        try (Closer closer = Closer.create();){
            if (closer.register(this.limiter.acquirePermits(1L)) != null) {
                Object object = this.extractor.readRecord(reuse);
                return (D)object;
            }
            this.submitLimiterStopMetadataEvents();
            D d = null;
            return d;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while trying to acquire the next permit", ie);
        }
    }

    public long getExpectedRecordCount() {
        return this.extractor.getExpectedRecordCount();
    }

    @Deprecated
    public long getHighWatermark() {
        return this.extractor.getHighWatermark();
    }

    public void close() throws IOException {
        try {
            this.extractor.close();
        }
        finally {
            this.limiter.stop();
        }
    }
}

