/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.runtime.Task;
import org.apache.gobblin.runtime.TaskStateTracker;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.MDC;

public abstract class AbstractTaskStateTracker
extends AbstractIdleService
implements TaskStateTracker {
    private final ListeningScheduledExecutorService taskMetricsUpdaterExecutor;
    private final Logger logger;

    public AbstractTaskStateTracker(int coreThreadPoolSize, Logger logger) {
        Preconditions.checkArgument((coreThreadPoolSize > 0 ? 1 : 0) != 0, (Object)"Thread pool size should be positive");
        this.taskMetricsUpdaterExecutor = ExecutorsUtils.loggingDecorator((ScheduledExecutorService)new ScheduledThreadPoolExecutor(coreThreadPoolSize, ExecutorsUtils.newThreadFactory((Optional)Optional.of((Object)logger), (Optional)Optional.of((Object)"TaskStateTracker-%d"))));
        this.logger = logger;
    }

    public AbstractTaskStateTracker(Properties properties, Logger logger) {
        this(Integer.parseInt(properties.getProperty("tasktracker.threadpool.coresize", Integer.toString(1))), logger);
    }

    public AbstractTaskStateTracker(Configuration configuration, Logger logger) {
        this(Integer.parseInt(configuration.get("tasktracker.threadpool.coresize", Integer.toString(1))), logger);
    }

    protected void startUp() throws Exception {
        this.logger.info("Starting the task state tracker");
    }

    protected void shutDown() throws Exception {
        this.logger.info("Stopping the task state tracker");
        ExecutorsUtils.shutdownExecutorService((ExecutorService)this.taskMetricsUpdaterExecutor, (Optional)Optional.of((Object)this.logger));
    }

    protected ScheduledFuture<?> scheduleTaskMetricsUpdater(Runnable taskMetricsUpdater, Task task) {
        return this.taskMetricsUpdaterExecutor.scheduleAtFixedRate(taskMetricsUpdater, task.getTaskContext().getStatusReportingInterval(), task.getTaskContext().getStatusReportingInterval(), TimeUnit.MILLISECONDS);
    }

    @Deprecated
    protected class TaskMetricsUpdater
    implements Runnable {
        protected final Task task;

        public TaskMetricsUpdater(Task task) {
            this.task = task;
        }

        @Override
        public void run() {
            MDC.put((String)"task.key", (String)this.task.getTaskKey());
            this.updateTaskMetrics();
        }

        protected void updateTaskMetrics() {
            if (GobblinMetrics.isEnabled((State)this.task.getTaskState().getWorkunit())) {
                this.task.updateRecordMetrics();
                this.task.updateByteMetrics();
            }
        }
    }
}

